# Hba to Switch or Storage Rule
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

package FCRules::Rule8;
use TO;
use Data::Dumper;
use Debug;
use FCRules;
use strict;

# READ
sub description {
  return "HBA port error with target device directly attached or Iport";
}

sub category {
  return "CRC";
}

# '0|5080020000067560|hba|a5k' => '0      1       0'

sub run {
  my($class, $To, $hm, $report,  $count, $key, $info, $reads, $writes,
     $fc_type) = @_;

  my($hba, $wwn, $port, $type) = split(/\|/, $key);
  my($renv) = System->get_renv();
  my($current_hba, $hba_no, $link, $host);

  if ($port eq "hba") {  # luxadm -e rdls
    $host = $To->nodeByName("host:" . $renv->{hostname});
    if (!$host) {
      return ("FCRule8: Cannot find host Topology", undef);
    }
    my $hbas =  $host->{port};
    my $hb = $info->{hba}{$hba};
    my $port_info = $host->{portInfo};
    $hba_no = -1;
    my($x, $ip, $p);

    for ($x=0 ; $x <= $#$port_info; $x++) {
      $p = $port_info->[$x];
      if ($p->{path} =~ /$hb/ ) {
        $current_hba = $p;
        $hba_no = $x;
        last;
      }
    }
    if ($hba_no < 0) {
       return ();
    } 
    $link = $hbas->[$hba_no]; # where is this hba going?

  } elsif ($type eq "host") { # discman -oh
    $host     = $To->nodeByName("host:$wwn");
    return () if (!$host);
    my $ports = $host->port();
    $hba_no   = substr($port,5);
    $link     = $ports->[$hba_no];
  } else {
    return ();
  }

  my($ltype, $dev_name, $pno) = split(/:/, $link);

  my $target = $To->nodeByName("$ltype:$dev_name");

  if (!$target) {
     Debug->print2("FCRule8: cannot find $ltype:$dev_name in TO");
     return ();
  }

  my($level, $cnt, $desc, $mins) = Thresholds->test("${fc_type}counters","rule8",
                                        $port, $count, $wwn);
  $mins = 1 if (!$mins);

  return () if ($level ne "E");

  my $CIMKey2 = $host->{info}{hostid} . ".hba.$hba_no";
  my $key2    = $host->name() . ":$hba_no";

  my($CIMKey1, $key1);

  my $swI = $target->{portInfo};
  $key1    = $target->name() . ":$pno";
  my $portLabel = $target->portLabel($pno);

  $desc = "$fc_type-ERROR ($cnt in $mins mins): ".
         "Detector: hba $hba_no on '$host->{info}{name}" . 
           ", Link: $portLabel on '" . $target->id()
             ;


  $hm->linkEvent($report, $ltype, $key1, "host",  $key2, $desc, 
                    $reads, $writes, $current_hba, $fc_type, $host->{info}{name});
  return ("FC", "");

}

1;
