package EventDB;
use strict;
use System;
use Message;
use RasDB;
use vars qw ($EVENTS);

sub write {
  my($class, $ed ) = @_;

  my $ev = $ed->instances(0);
  #return if ($ev->value("Severity") == 0);  bug 4990785

  $EVENTS = RasDB->new("EVENTS");
  my $hash = $EVENTS->{hash};

  
  my $eventid = $ev->value("EventId");
  my $data = {};
  foreach my $prop (@{$ev->properties()})  {
     my $e = $prop->[0];
     $data->{$e} = $ev->value($e);
  }
  my $Data = $ev->value("Data");
  if ($data->{Parent}) {
    $data->{Aggregate} = -1;
  }
  $data->{Data}      = $Data if (index($Data, "#INSTRUMENTATION_REPORT") < 0);
  $data->{agg_list}  = $ed->id("agg_list");
  $data->{EventTime2} = Message->eventTime0($ev->value("EventTime"));

  $EVENTS->Lock();

  my $info = $hash->{INFO} || {};
  $info->{count}++;
  $hash->{INFO} = $info;

  $hash->{$eventid} = $data;

  $EVENTS->UnLock();
}

# 
# keep only 10 days
# 
sub clean {
  my($class, $max) = @_;
  $EVENTS = RasDB->new("EVENTS");
  my $hash = $EVENTS->{hash};
  $EVENTS->Lock();
  my $now = time;
  my $week = 60 * 60 * 24 * $max;
  my($k,$v);
  while (($k,$v) = each %$hash) {
     my($t1, $rest) = split(/\./, $k);
     if ( $now - $t1 > $week ) {
	 delete $hash->{$k};
     }
  }
  $EVENTS->UnLock();
}

#
# RETURN Devices-Involved and SUB-Events
#
sub sub_events {
  my($class, $ed_list, $html, $skip_grid, $xml) = @_;

  my ($data, $involved, $sub_events);
  my $sub_events_xml;
  my ($ALL, %TRACK_CODE, $dcnt);
  my $renv = System->get_renv();

  $EVENTS = RasDB->new("EVENTS");
  my $hash = $EVENTS->{hash};
  $EVENTS->ReadLock();
  my $G = Labels->read();
  my $done = 1;
  my $inv_cnt = 0;

  foreach my $e_id (split(/,/, $ed_list) ) {
     my $ev     = $hash->{$e_id};
     my $sev2   = $ev->{Severity};
     my $desc   = $ev->{Description};
     my $comp   = $ev->{Component} || $ev->{Caption};
     my $caption= $ev->{Caption};
     my $etype  = $ev->{EventType};
     my $g_no   = $ev->{GridNo};
     my $g_code = $ev->{GridCode};
     my @edata  = split(/\n/, $ev->{Data});
     $dcnt++;

     my($etype0, $etype1) = split(/\./, $etype);

     $desc =~ s/[\n\r]/ /g;
     my $ta = $ev->{Target};
     if (index($ALL, $ta) < 0) {
        $involved .= " $etype0 " . ($ev->{TargetName} || $ta) . "\n";
        $inv_cnt++;
        $ALL .= ",$ta";
     }
     my $text = $G->{'sev' . int($sev2+0.5)};

     my $e1 = $etype;
     $e1 .= "/$comp" if (index($etype, $comp) < 0);
     my $date = $ev->{EventTime};
     $date = substr($date,0,4) . "-" . substr($date,4,2) . "-" . substr($date,6,2) . " ".
             substr($date,8,2) . ":" . substr($date,10,2) . ":" . substr($date,12,2);
     if ($html) {
       $sub_events .= "\n<b>$dcnt) $date</b> [$text, $e1, $g_no]\n";
     } else {
       $sub_events .= "\n$dcnt) $date [$text, $e1, $g_no]\n";
     }

     if ($renv->{fsa_debug}) {
       $sub_events .= " (etype=$etype, comp=$ev->{Component},caption=$caption) \n";
     }
     $sub_events .= "</b>" if ($html);
     $sub_events .= "$desc\n";
     if (substr($desc,-1) eq ":") {
       my $x2;
       my $start = (index($desc, $edata[0]) > 0) ? 1:0;
       for ($x2 = $start; $x2 < 10; $x2++) {
          $sub_events .= "  $edata[$x2]\n" if ($edata[$x2]);
       }
       $sub_events .= "...\n" if ($#edata >= 10);
     }
     if (!$skip_grid && !$done) {
        my $grid_info  = Grid->getInfoString($etype, $caption, $g_code);
        $done = 1;
        if ($grid_info) {
          $grid_info =~ s/\n/\n   /g;
          $sub_events .= "   $grid_info\n";
        }
     }

     # if we are in XML mode, generate XML formatted data.
     if ($xml) {
       $sub_events_xml .= "<SUB_EVENT>\n";
       $sub_events_xml .= "  <INDEX>$dcnt</INDEX>\n";
       $sub_events_xml .= "  <DATE>$date</DATE>\n";
       $sub_events_xml .= "  <TEXT>$text</TEXT>\n";
       $sub_events_xml .= "  <ELEMENT>$e1</ELEMENT>\n";
       $sub_events_xml .= "  <NUMBER>$g_no</NUMBER>\n";
       $sub_events_xml .= "  <DESC>$desc</DESC>\n";
       $sub_events_xml .= "  <DATA>$ev->{Data}</DATA>\n";
       if ($renv->{fsa_debug}) {
         $sub_events_xml .= "  <FSA>";
         $sub_events_xml .= " (etype=$etype, comp=$ev->{Component},caption=$caption) \n";
         $sub_events_xml .= "</FSA>\n";
       }
       if (!$skip_grid && !$done) {
         my $grid_info  = Grid->getInfoString($etype, $caption, $g_code);
         $done = 1;
         if ($grid_info) {
           $grid_info =~ s/\n/\n   /g;
           $sub_events_xml .= "  <GRID_INFO>$grid_info</GRID_INFO>\n";
         }
       }
       $sub_events_xml .= "</SUB_EVENT>\n";
     }

  }
  $EVENTS->UnLock();
  if ($inv_cnt > 1) {
     $involved = "DEVICE(s) INVOLVED:\n$involved\n";
  } elsif ($inv_cnt == 1) {
     $involved = "";
  }

  if ($xml) {
     $sub_events = $sub_events_xml;
  }
  return ($involved, $sub_events, $inv_cnt);
}

1;


