package Discover;
use strict;
use System;
use Lease;

# select: hostname or '' for all hosts.
# ID: deviceIP

sub ras_admin {
  my($class, $select, $command, $renv, $hosts, $ID) = @_;
  my $L = Labels->read("GUIAdmin::default")->section("discover");

  my $DIR = System->get_home() . "/DATA/Discover";
  mkdir $DIR,0777 if (!-d $DIR);

  if ($select eq "local" || !$select) {
     #open(O, ">$DIR/$ID.local"); print O "#START\n"; close(O);
     print $L->expand(getting2 => $renv->{hostname}) . "<br>(ras_admin $command)<br>";
     my $com = System->get_home() . "/bin/ras_admin $command";
     my $pid = fork();
     if (!$pid) {
        close(STDIN); close(STDOUT); close(STDERR);
        exec "$com";
     }
  }
  foreach my $h (@$hosts) {
     next if($h->{dh} eq "Y");
     if ($h->{hostname} eq $select || !$select) {
       print $L->expand(getting2 => $h->{hostname}) . "<br>(ras_admin $command)<br>";
       Util::Http->remoteCommand($h->{ipno}, "ras_admin $command", 20);
     }
  }
}

sub stats {
  my($class) = @_;

  my(%TOT, $l);
  my $D1 = System->get_home() . "/DATA/Discover";
  opendir(O, $D1);
  my @F = readdir(O); closedir(O);
  foreach my $f (@F) {
     next if (-d "$D1/$f");
     next if (substr($f,0,1) eq ".");
     my($a, $b) = split(/\./, $f);
     $TOT{$a}{cnt}++;
     open(O2, "$D1/$f");
     my($start, $stop, $cnt);
     while ($l = <O2>) {
        if (substr($l,0,6) eq "#START") {
           $start++;
        } elsif (substr($l,0,4) eq "#END") {
           $stop = 1;
        } elsif (index($l, "|") >= 0) {
           $cnt++;
        }
     }
     close(O2);
     $TOT{$a}{start} += $start;
     $TOT{$a}{stop}  += $stop;
     $TOT{$a}{lines} += $cnt;
  }
  return \%TOT;
}

use Logic::SWITCH;

sub process_discovery {
  my($class, $q) = @_;
  my($l);
  my(%TOT, $c1, %F);
  my ($lease, $all_running, $info);
  my $tag;

  if(!$q->{mode}){
     $tag = "<br>";
  }
     
  if (!($lease = Lease->get("config.process_discovery", 10, 5)) ) {
    return ("CANNOT TAKE process_discovery lease", 0);
  }

  my $D1 = System->get_home() . "/DATA/Discover";
  opendir(O, $D1);

  my($renv, $devs, $hosts,$notifs) = PDM::ConfigFile->read();
  foreach my $d (@$devs) {
     $F{$d->{key}} = 1;
  }

  my @F = readdir(O); closedir(O);
  foreach my $f (@F) {
     next if (substr($f,0,1) eq "." || -d "$D1/$f");

     my($adding, $running);
     if (open(O, "$D1/$f")) {
       while ($l = <O>) {
         chop($l);
         if ($l =~ /#START/) {
           $running = 1;
         } elsif ($l =~ /#END/) {
           $running = 0;
         }
         next if (substr($l,0,1) eq "#" || index($l, "|") < 0);
         if (substr($l,0,3) eq "ERR") {
           $info .= "$l<br>\n";
         } else {
           my $err_text;
           my($adding0, $nodes) = 
              Logic::SWITCH::process_line({}, $l, \%F, \$err_text, $devs, undef , $tag);
           $adding += $adding0;
         }
       }
       close(O);
     }
     if ($adding) {
        PDM::ConfigFile->write($renv, $devs, $hosts, $notifs);
     }
     unlink "$D1/$f" if (!$running);
     $all_running += $running;
  }
  $lease->release();
  return (undef, $all_running, $info);
}

1;

