#!/opt/SUNWstade/bin/perl -w
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

##################################################################
#T3Tokenss.pm
#Package T3Tokenss
##################################################################
package T3Tokens;

use strict;
use T3Connection;
use LWP::UserAgent;
use HTTP::Request;
use HTTP::Response;
use URI::Heuristic;

##################################################################
#T3Tokens Consturctor
##################################################################
sub new {
  my $this = {}; 
  # object properties
  shift;
  $this->{connection} = shift;
  $this->{tokens} = {sysprop=>{},elemprop=>{}};
  bless $this; 
  return $this;
}

##################################################################
#T3Tokens::set_debug
##################################################################
sub set_debug {
  my $this = shift;
  $this->{set_debug}="On";
  return "On";
}

##################################################################
#T3Tokens::set_verbose
##################################################################
sub set_verbose {
  my $this = shift;
  print "T3Token Refresh\n";
  $this->{set_verbose}="On";
  return "On";
}

##################################################################
#T3Tokens::refresh
##################################################################
sub refresh {
  my $this = shift;
  my $option =shift;
  my @html=undef;

  if(!($option =~ /elemprop/i)){
    print $this->{connection}."\n";
    print %$this->{connection}."\n";
    @html= split(/\n/, $this->{connection}->get_html("sysprop"));
    foreach my $line (@html){
      (my $IP, my $token, my $value)=split(/,/,$line);
      $this->{tokens}->{sysprop}->{$token}=$value;
    }
  }
  if(!($option =~ /sysprop/i)){
    $this->{connection}->refresh("elemprop");
    @html= split(/\n/, $this->{connection}->get_html("elemprop"));
    foreach my $line (@html){
      (my $element, my $token, my $value)=split(/,/,$line);
      $this->{tokens}->{elemprop}->{$element}->{token}=$value;
    }
  }
}


1;

