package DeviceReport::V880DISK;
use System;
use strict;
use DeviceReport;


sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'} },
      device_type            => {order => 2, value => $rep->{'id.device_type'} },
      device_key             => {order => 3, value => $rep->{'id.device_key'}  },
      device_label           => {order => 5, value => Util->abb("v880disk.medium")  },
      revision               => {order => 4, value => $rep->{'revision.value'} },
      temp_base              => {order => 4, value => $rep->{'temperature.base.status'} },
      temp_expansion         => {order => 4, value => $rep->{'temperature.expansion.status'} },
  };

  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       if (!$summary) {
          if ($L[0] eq "disk" && $L[2] eq "product_id") {

              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => $rep->{"$k.state"},
                                         status  => $rep->{"$k.status"},
                                            type => "disk",
                                        revision => $rep->{"$k.revision"},
                                           model => $rep->{"$k.vendor"} . "." . $rep->{"$k.product_id"},
                                          serial => $rep->{"$k.serial_no"},
                                         keyLabel=> "WWN",
                                         keyValue=> $rep->{"$k.wwn"},
                                       };

          } elsif ($L[0] eq "SSC" && $L[2] eq "status" ) {

              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => "",
                                         status  => $rep->{"$k.status"},
                                         type    => $L[1],
                                         revision=> "",
                                           model => "",
                                          serial => "",
                                       };

          } elsif ($L[0] eq "lun" && $L[2] eq "status") {

              $S{LOGICAL}{$k} =  { name => $rep->{"$k.device"},
                                    id  => $k,
                                  type  => "lun",
                                 status => $rep->{"$k.status"},
                                 };

          } elsif ($L[0] eq "temperature") {
              $k = "$L[0].$L[1].$L[2]";
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return $out;
}




1;
