package DeviceReport::T3;
use System;
use strict;
use DeviceReport;



# no $q->{summary}                    # only frus,vols, system, id
# $q->{summary} = "controller.u1ctr." # this controller
# $q->{summary} = "controller."       # all controllers
# Main sections:
# <FRU> <LOGICAL> <SYSTEM> <ID>

sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $fru_list = ",controller,disk,loopcard,midplane,power,";
  my $logical  = ",volume,slice,";
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";
  my $wwn2 = $rep->{'port.u2p1.portWWN'} || $rep->{'port.u3p1.portWWN'} || $rep->{'port.u4p1.portWWN'};
  my $units = $rep->{"unit.count"} || $rep->{"controller.count"};
  my $cu    = $rep->{"controller.count"} . "x$units";
  my $pg    = "PG" if ($units > 1);

  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'}},
      device_type            => {order => 2, value => "$rep->{'id.device_type'} $pg ($cu)"},
      device_key             => {order => 3, value => $rep->{'id.device_key'} },
      device_ip              => {order => 4, value => $rep->{'id.ipno'} },
      port_wwn               => {order => 5, value => "$rep->{'port.u1p1.portWWN'} / $wwn2"},
      communication_status   => {order => 6,
                             value => ($report->{_status} eq "CC") ? "Management-Path Lost!" : "OK"},
      system_revision        => {order => 7, value => $rep->{"system.sysRevision"}},
      multipath_support      => {order => 8, value => $rep->{"system.sysMpSupport"}},

      fru_count              => {order => 9, value => $rep->{"system.fruCount"}},
      disk_count             => {order => 10, value => $rep->{"system.fruDiskCount"}},
      disk_scrubber          => {order => 11, value => $rep->{"system.sysDiskScrubber"} || "Off"},
      fc_speed               => {order => 12, value => $rep->{"system.sysFcSpeed"}},
      online_diagnostic      => {order => 13, value => $rep->{"system.sysOndgMode"}},
      
      };


  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       next if (index($el, "fruDiskPerf") >= 0);
       if (!$summary) {
          if (index($fru_list, ",$L[0],") >= 0) {
            if ($L[1] ne "count" && $L[1] ne "header") {
              my $rev = $rep->{"$k.fruCtlrVersion"} || $rep->{"$k.fruLoopVersion"} || 
                        $rep->{"$k.fruRevision"};
              my $key = $rep->{"$k.fruVendor"} . "." . $rep->{"$k.fruModel"} . 
                        "." . $rep->{"$k.fruSerialNo"} ;
              $key = "" if ($key eq "..");

              $S{FRU}{$k}            = { name    => $L[1], 
                                           id    => $k,
                                         state   => $rep->{"$k.fruState"},
                                         status  => $rep->{"$k.fruStatus"},
                                         type    => $rep->{"$k.fruType"},
                                         revision=> $rev,
                                           model => $rep->{"$k.fruModel"},
                                          serial => $rep->{"$k.fruSerialNo"},
                                         keyLabel=> "serialno",
                                         keyValue=> $key ,
                                       };
            }

          } elsif ($L[0] eq "port") {
              $S{FRU}{$k} = {    name => $L[1],
                                   id => $k,
                               state  =>  $rep->{"$k.portState"},
                               status =>  $rep->{"$k.portStatus"},
                             keyLabel => "wwn",
                             keyValue => $rep->{"$k.portWWN"},
                                 type => $rep->{"$k.portType"},
                                       };

          } elsif ($L[0] eq "system") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } elsif ($L[0] eq "volume_disk" && $L[2] eq "volDiskFruId")  {
              my @s = split(/\-/, $L[1]);
              $VD{$s[0]} .= $rep->{$el} . ",";

          } elsif ($L[0] eq "volume")  {
              $S{LOGICAL}{$k} =  { name => $rep->{"$k.volName"}, 
                                    id  => $k,
                                  type  => "volume",
                                 status => $rep->{"$k.volStatus"},
                                 };
                                           
          } elsif ($L[0] eq "slice")  {
              $S{LOGICAL}{$k} =  {  name => $rep->{"$k.volSliceName"},  
                                     id  => $k,
                                   type  => "slice",
                                 status  => $rep->{"$k.volSliceStatus"} ,
                                 };
          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }
  foreach my $v (sort keys %VD) {
     $S{LOGICAL}{"volume_disk.$v"} = { name => $v, type => "volume_disk", disks => $VD{$v} };
  }
  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return $out;
}




1;
