package DeviceReport::SE;
use System;
use strict;
use DeviceReport;
use Agent::3310;



# no $q->{summary}                    # only frus,vols, system, id
# $q->{summary} = "controller.u1ctr." # this controller
# $q->{summary} = "controller."       # all controllers
# Main sections:
# <FRU> <LOGICAL> <SYSTEM> <ID>

sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $product_id = "$rep->{'info.Product'} $rep->{'info.unique_id'}";
  my $type = $rep->{'id.device_type'};

  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'}},
      device_type            => {order => 2, value => $rep->{'id.device_type'} },
      device_key             => {order => 3, value => $rep->{'id.device_key'} },
      device_ip              => {order => 4, value => $rep->{'id.ipno'} },
      product_ID             => {order => 5, value => $product_id },
      device_label           => {order => 6, value => Util->abb("$type.medium") },
     
      };

  
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       next if (index($el, "fruDiskPerf") >= 0);
       if (!$summary) {
          if ($L[0] eq "fru" && $L[2] eq "fruType") {
              my $I = SE->fruInfo($rep, $L[1]);

              my $name = $rep->{"$k.fruType"} . "." . $rep->{"$k.fruId"};
              $S{FRU}{$k}            = { name    => $name,
                                           id    => "fru.$L[1]",
                                         state   => "",
                                         status  => $I->{state},
                                         type    => $I->{fruType},
                                         revision=> $I->{revString},
                                           model => "$I->{vendor}.$I->{model}",
                                          serial => $I->{serial},
                                         keyLabel=> "SERIAL",
                                         keyValue=> $I->{serial},
                                       };

          } elsif ($L[0] eq "fcPort" && $L[2] eq "PortWWN") {
              my $wwn  = $rep->{"$k.LocalPortWWN"} || $rep->{"$k.PortWWN"};
              my $name = "$k." . $rep->{"$k.SlotId"};
              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => "",
                                         status  => $rep->{"$k.status-desc"},
                                         type    => $rep->{"$k.portType"},
                                          model  => "",
                                          serial => "",
                                        revision => "",
                                        keyLabel => "WWN",
                                        keyValue => $wwn,
                                       };

          } elsif ($L[0] eq "system") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } elsif ($L[0] eq "lun" && $L[2] eq "lunName")  {
              $S{LOGICAL}{$k} =  { name => $rep->{"$k.lunName"},
                                    id  => $k,
                                  type  => $rep->{"$k.lunType"},
                                 status => $rep->{"$k.lunStatus"},
                                   wwn  => $rep->{"$k.lunWwn"},
                                 };

          } elsif ($L[0] eq "slice" && $L[2] eq "lunName")  {

              my $name = $rep->{"$k.lunName"} . "." . $rep->{"$k.volId"} . "." . 
                         $rep->{"$k.volSliceName"};
              $S{LOGICAL}{$k} =  { name => $name,
                                    id  => $k,
                                  type  => "slice",
                                 status => "",$rep->{"$k.lunStatus"},
                                 };

                                           
          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return $out;
}




1;
