package DeviceReport::HOST;
use System;
use strict;
use DeviceReport;


# xml for GUI Interface

sub xmlSummary {
   my($class, $report, $q) = @_;

  my $rep = $report->content();
  my $summary = $q->{summary};
  my (%S);

  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  my $name   = $report->id("name") ;
  my $ip     = Util->name2ip($name);
  my $hostid = $rep->{"location.hostId"};
  my $key0   = $report->id("deviceName") ;

  $S{HEADER} =   {
                  device_key   => { order => 1 , value => $hostid },
                  device_name  => { order => 2 , value => $name },
                  device_ip    => { order => 3 , value => $ip   },

                 };

  $S{FRU}{"enclosure"} = {  name=> $name,
                            id  => 1,
                        status  => $report->status(),
                          type  => $report->id("category"),
                       revision => "",
                         serial => $hostid,
                          model => "",
                       keyLabel => "HOSTID",
                       keyValue => $hostid,
                           };
  my $lun_cnt;
  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $x  = "$L[0].$L[1].$L[2]";

       if (!$summary) {
          if ($L[0] eq "lun" && $L[3] eq "wwn") {
            $L[1] =~ s/_+/_/g;
            my $key = "$key0.$L[1].$L[2]";
            $lun_cnt++;
            my $status = $rep->{"$x.statusA"};
            $status .= " / " . $rep->{"$x.statusB"} if ($rep->{"$x.statusB"});
            my $type = $L[1];
            $S{LOGICAL}{"lun.$lun_cnt"} = { 
                             name  => "$L[0].$L[1].$L[2]" ,
                               id  => "lun.$lun_cnt",
                           status  => $status,
                             type  => $type,
                          revision => "",
                            serial => $L[2],
                             model => "",
                          keyLabel => "WWN",
                          keyValue => $rep->{"$x.wwn"},
                           };

          } elsif ($L[0] eq "ports") {
              $x = "$L[0].$L[1]";
              my($front, $front2, $type) = split(/[\/\@]/, $L[1]);
              $S{PORT}{$x} = {  name  => $L[1],
                                 id  =>  $L[1],
                              state  => $rep->{$x},
                             status  => "",
                               type  => $type,
                           keyLabel  => "DevicePath",
                           keyValue  => $L[1],
                            };


          } elsif ($L[0] eq "id") {
              $x = "$L[0].$L[1]";
              $S{ID}{$x} = { value => $rep->{$el} };
        
          } elsif ($L[0] eq "freeSpace") {
              $x = "$L[0].$L[1]";
              my $val = $rep->{$el};
              if (index($x,"|") >= 0) {
                 $x =~ s/\|/ \(/;
                 $x .= ")";
              }
              $S{SYSTEM}{$x} = { value => $val };

          } else {
              #$S{OTHER}{$x} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }
  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return $out;
}



1;
