package DeviceReport::D2;
use System;
use strict;
use DeviceReport;


sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'} },
      device_type            => {order => 2, value => $rep->{'id.device_type'} },
      device_key             => {order => 3, value => $rep->{'id.device_key'}  },
      device_path            => {order => 4, value => $rep->{'id.device_wwn'}  },
      fan0_status            => {order => 5, value => $rep->{'fan.0.status'} },
      fan1_status            => {order => 6, value => $rep->{'fan.1.status'} },
      power0_status          => {order => 5, value => $rep->{'power.0.status'} },
      power1_status          => {order => 6, value => $rep->{'power.1.status'} },
  };


  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       if (!$summary) {
          if ( ($L[0] eq "midplane" || $L[0] eq "esm") && $L[2] eq "frutype") {

              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => "",
                                         status  => "",
                                         type    => $rep->{"$k.frutype"},
                                         revision=> $rep->{"$k.revision"},
                                           model => $rep->{"$k.product"},
                                          serial => $rep->{"$k.serial"},
                                         keyLabel=> "serial",
                                         keyValue=> $rep->{"$k.serial"},
                                       };

          } elsif ($L[0] eq "slot" && $L[3] eq "vendor") {
              $k= "$L[0].$L[1].$L[2]";

              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => "",
                                         status  => $rep->{"$k.status"},
                                         type    => "disk",
                                         revision=> $rep->{"$k.revision"},
                                           model => $rep->{"$k.vendor"} . "." . $rep->{"$k.model"},
                                          serial => $rep->{"$k.serial"},
                                         keyLabel=> "serial",
                                         keyValue=> $rep->{"$k.serial"},
                                       };


          } elsif ($L[0] eq "info") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return $out;
}




1;
