package DeviceReport::A3500FC;
use System;
use strict;
use DeviceReport;


sub xmlSummary {
  my($class, $report, $q) = @_;

  my $summary = $q->{summary}; # summary
  my $rep = $report->content();

  my $normal  = $q->{normal};  # normalized
  my (%S, %VD);
  my $out = "<REPORT>\n";
  $out .= " <CONTENT>\n";

  $S{HEADER} = {
      device_name            => {order => 1, value => $rep->{'id.device_name'} },
      device_type            => {order => 2, value => $rep->{'id.device_type'} },
      device_key             => {order => 3, value => $rep->{'id.device_key'}  },
      device_ip              => {order => 4, value => $rep->{'id.ipno'}  },
      device_label           => {order => 5, value => Util->abb("a3500fc.medium")  },
  };

  foreach my $el (sort keys %$rep) {
       my @L = split(/\./, $el);
       my $k = "$L[0].$L[1]";
       if (!$summary) {
          if ($L[0] eq "disk" && $L[2] eq "product_id") {

              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => "",
                                         status  => $rep->{"$k.status"},
                                            type => "disk",
                                        revision => $rep->{"$k.firmware_version"},
                                           model => $rep->{"$k.vendor"} . "." . $rep->{"$k.product_id"},
                                          serial => $rep->{"$k.serial"},
                                         keyLabel=> "serial",
                                         keyValue=> $rep->{"$k.serial"},
                                       };

          } elsif ($L[0] eq "controller" && $L[2] eq "device") {

              $S{FRU}{$k}            = { name    => $k,
                                           id    => $k,
                                         state   => $rep->{"$k.state"},
                                         status  => "",
                                         type    => "controller",
                                         revision=> "",
                                           model => "",
                                          serial => $rep->{"$k.serial"},
                                         keyLabel=> "serial",
                                         keyValue=> $rep->{"$k.serial"},
                                       };

          } elsif ($L[0] eq "lun" && $L[2] eq "status") {

              $S{LOGICAL}{$k} =  { name => $rep->{"$k.device"},
                                    id  => $k,
                                  type  => "lun",
                                 status => $rep->{"$k.status"},
                                 };

          } elsif ($L[0] eq "device_info") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "drive_grouping") {
              $S{SYSTEM}{$k} = { value => $rep->{$el} };

          } elsif ($L[0] eq "id") {
              $S{ID}{$k} =  { value => $rep->{$el} };

          } else {
              #$S{OTHER}{"$L[0].$L[1]"} = 1;
          }
       } elsif (substr($el,0, length($summary)) eq $summary) {
          $out .= "   <VALUE ID=\"$el\">$rep->{$el}</VALUE>\n";
       }
  }

  if (!$summary) {
    $out .= DeviceReport->xml(\%S, "ID,SYSTEM");
  }

  $out .= " </CONTENT>\n";
  $out .= "</REPORT>\n";
  return $out;
}




1;
