package Daemons;
use strict;

use System;

#  $Id: Daemons.pm,v 1.6 2004/06/15 19:49:44 bkeslin Exp $

# will start deamons.
# will restart deamons (snmptrapd) every time
# it find that the process is there but the LOGFILE is missing.
# $PID file contains the pid of the snmptrapd process.
# It needs to be there for this module to attempt to kill snmptrapd. 

sub restart {
  my($class) = @_;

  my $renv = System->get_renv();
  my $HOME = System->get_home();

# SYSTEM EDITIONS

  if ($renv->{solution} ne "N") { 

# Dont Start Trap listener (6920 requirement for PatchPRO)
#    my $l = System->findProcess("/snmptrapd");
#    if ("@$l" !~ /snmptrapd/) {
#      system("$HOME/snmp/bin/start_trap");
#    }
    my $l = System->findProcess("/snmpd");
    if ("@$l" !~ /snmpd/) {
       system("$HOME/sysbin/start_snmp");
    }

# DEVICE EDITION
  } else {  
    my $LOG = "/var/adm/trap_messages";
    my $PID = "$HOME/DATA/trap_pid";
    my $BIN = "$HOME/snmp/sbin/snmptrapd";
    my $PORT= $renv->{snmptrap_port} || "1162";
    my $MIBS = "$HOME/snmp/share/snmp/mibs/SUN-SAM-MIB.mib";
    
    my $com = "$BIN -p $PORT -o $LOG -m $MIBS -O n -u $PID";
    
    my $l = System->findProcess("/snmptrapd");

    if ("@$l" !~ /snmptrapd/) {
      system($com);

    } elsif (!-f $LOG) {
      open(FD, $PID); 
      my $pid = <FD>; close(FD); 
      if ($pid) {
         kill 9, $pid;
         system($com);
      }
    }
  }
}

1;
