package Client::TestPatchPro;
use Client;
use strict;

sub test {

  my($q) = @_;
  my $args;
  my $url;

  if($q->{source} eq "CD" || $q->{source} eq "cd") {
    print Client->error("xml", 1101,"$q->{source}");
  } else {
    $url = $q->{source};
    if ($q->{proxy}) {
      $ENV{http_proxy} = $q->{proxy};
      $args .= " --proxy=on";
      $args .= " --proxy-user=$q->{proxyUser}" if ($q->{proxyUser});
      $args .= " --proxy-user=$q->{proxyPassword}" if ($q->{proxyPassword});
    } else {
      $args .= " --proxy=off";
    }

    my $com = System->get_home() . "/bin/wget -O /dev/null $args $url";
    open(O, "$com 2>&1|");
    my @result = <O>; close(O);

    if ("@result" =~ /200 OK/) {
      print "<TESTPATCHPRO>$com \n @result </TESTPATCHPRO>\n";
    } elsif ("@result" =~ /Unsupported scheme/)   {
      print Client->error("xml", 1102, "$com \n @result");
    } else {
      print Client->error("xml", 1103, "$com \n @result");
    }
  }
  
}

1;
