package Client::TestMail;
use Client;
use strict;
use System;
use Net::SMTP;

sub mail {
  my($to, $from, $subject, $data, $TO, $sendmailServer) = @_;
  
  my $renv = System->get_renv();
  my $ef = $renv->{email_from};
  if ($ef) {
    if ($ef =~ /\@/) {
       $from = $ef;
    } elsif ($ef !~ /\@/) {
       $from .= "\@$ef";
    }
  }

  $TO = 30 if (!$TO);

  my $smtp = Net::SMTP->new($sendmailServer, Timeout => $TO);

  if (!$smtp) {
     return "Cannot create SMTP handle to $sendmailServer: $!";
  }

  my $ct = "Content-Type: text/plain; charset=us-ascii";

  my $text;
  $text = "From: $from\nTo: $to\nSubject: $subject\n\n$data";

  #$smtp->auth("88871","chris60");

  if ($smtp->mail()) {
     if ($smtp->to($to)) {
       $smtp->data();
       $smtp->datasend($text);
       $smtp->dataend;
       $smtp->quit;
       return undef;
     } else {
       my $err = $smtp->message();
       $smtp->quit;
       return $err;
     }
  } else {
     my $err = $smtp->message();
     $smtp->quit;
     return $err;
  }
}

sub mailData {
  my($to, $data, $TO, $sendmailServer) = @_;

  my $renv = System->get_renv();

  my $email_from     = $renv->{email_from};
  if ($email_from) {
    my $ix = index($email_from, "\@");
    $email_from = substr($email_from, $ix+1) if ($ix > 0);
  }

  $TO = 30 if (!$TO);

  my $smtp = Net::SMTP->new($sendmailServer, Timeout => $TO, Hello => $email_from );
  if (!$smtp) {
     Debug->print2("Cannot create SMTP handle");
     return "SMTP error";
  }

  if ($smtp->mail() && $smtp->to($to)) {
     $smtp->data();
     $smtp->datasend($data);
     $smtp->dataend;
     $smtp->quit;
     return undef;
  } else {
     my $err = $smtp->message();
     $smtp->quit;
     return $err;
  }
}

######################################################
#   TEST EMAIL
######################################################

sub test {
  my($q) = @_;
  my($renv, $dev, $host, $notifs) = PDM::ConfigFile->read();

  my $rc = mail($q->{email}, "Storage_ADE", "Test Message", 
		$q->{message}, 30, $q->{sendmailServer});

  if ($rc) {
    print Client->error("xml", 801, "$q->{sendmailServer}");
  } else {
    print "<TESTEMAIL>\n";
    print "<VALUE ID=\"$q->{sendmailServer}, $q->{email}\">sent</VALUE>\n";
    print "</TESTEMAIL>\n";
  }
}

1;
