package Client::TO;
use System;
use TO;
use strict;
use Client;

# Topology

sub list {
  my($q) = @_;

  opendir(O, System->get_home() . "/DATA/topo");
  my @L = readdir(O); closedir(O);
 
  print Client->http_OK();

  print "<?xml version=\"1.0\"?>\n";
  print "<TOPOLIST>\n";

  foreach my $to (@L) {
     next if (substr($to,0,1) eq ".");
     print "  <TOPO ID=\"$to\"/>\n";
  }
  print "</TOPOLIST>\n";

}

# will return default topology when used with no argument
# http://ccadieux:80/rashttp?GO=Client::TO::details

sub details {
  my($q) = @_;

  my $renv = System->get_renv();

  my $to_name = $q->{topo};
  my $to = TO->readTopo($to_name);
  $to_name = $renv->{hostname} if (!$to_name);

  print Client->http_OK();

  print "<?xml version=\"1.0\"?>\n<TOPOLOGY ID=\"$to_name\">\n" .
        $to->toXML() .
        "</TOPOLOGY>\n";
}

###################################
# data needed for applet params

sub applet {
  my($q) = @_;

  print Client->http_OK();
  require GUI::Graph;
  my ($parms, $to, $dev_cnt) = TO::Applet->genAppletData($q) ;
  print $parms;
}


1;

