package Client::SWITCHUtil;

#use strict;
#use System;
#use Launch;
#use Client;


use Roles;
use Util;
use strict 'vars';
use GUI::SAN;
use System;
use Data::Dumper;
use Agent::SWITCH;
use bytes;

sub FCfromDevice {
  my($dev) = @_;

  my $L = Labels->read("GUI::Util")->section("fc");
  my $agent = "Agent::" . uc($dev->{type});
  my $err1;
  if ( $err1= Modules->loadOne($agent)) {
	return  ($L->expand(no_agent => $dev->{type},$dev->{name}));
  }
  #$agent .= "::new";
  #$agent = &$agent;

  if (!$agent->can("FCfromDevice")) {
	return ($L->expand(cannot_extract => $dev->{type}, $dev->{name}));
  }
  my $x = $agent->FCfromDevice($dev);

  my $data = $x->{data};
  my $map  = $x->{map};
  my @K = keys %$data;
  if ($#K < 0) {
	return  ($L->expand(cannot_extract => $dev->{type}, $dev->{name}.
                   ": " . $agent->ERR() ));
  }
  return (undef, $x, $data, $map);
}

#
# { 
#    SW => the switch ID
# }
#
sub fc_data {
  my($q) = @_;

  my $Config = PDM::ConfigFile->read();

  print "<SWITCH_STATISTICS> \n";
  if ($q->{SW}) {
    my $dev = $Config->deviceByWWN($q->{SW});
    print "  <ID>".$q->{SW}."</ID>\n";

    my($err2, $x, $data, $map) = &FCfromDevice($dev);
    my($y);

    my $data = $x->{data};
    foreach $y (keys %$data) {
      my(@c) = split(/\|/, $y);
      print "  <COMPONENT ID=\"".$c[2]."\">\n";
      my ($link,$sig,$seq,$crc,$sync,$invtxw,$inframes,$outframes) = split(/\t/, $data->{$y});
      print "    <LINK>".$link."</LINK>\n";
      print "    <SIG>".$sig."</SIG>\n";
      print "    <SEQ>".$seq."</SEQ>\n";
      print "    <CRC>".$crc."</CRC>\n";
      print "    <SYNC>".$sync."</SYNC>\n";
      print "    <INVTXW>".$invtxw."</INVTXW>\n";
      print "    <INFRAMES>".$inframes."</INFRAMES>\n";
      print "    <OUTFRAMES>".$outframes."</OUTFRAMES>\n";
      print "  </COMPONENT>\n";
    }
  }
  print "</SWITCH_STATISTICS> \n"
}

1;
