# Copyright 2004 Sun Microsystems, Inc., All Rights Reserved.
package Client::SAE;
use Debug;
use Client;
use Util;
use Util::Http;
use strict;

sub Record {
  my($q) = @_;
  my $command = $q->{command};
  my $format = $q->{format} || "tab";
  my $saeDir = System->get_home() ."/DATA/sae";
  my $oldsaeDir = System->get_home() ."/DATA/oldsae";

  Debug->logLine("Client::SAE::Control $command");
  print Client->http_OK();

  if ($command){
    if ($command eq "on") {
      if (! -d $saeDir){
	if (-d $oldsaeDir){
	  rename  $oldsaeDir,$saeDir;
	}
	else {
	  mkdir $saeDir, 0777;
	}
      }
    }
    elsif ($command eq "off") {
       if (-d $saeDir){
	 if (-d $oldsaeDir){
	   system "rm -rf $oldsaeDir";
	 }
	 rename $saeDir,$oldsaeDir;
       }
    }
  }
  if (-d $saeDir){
    print "OK on\n";
  }
  else {
    print "OK off\n";
  }
}


sub List {
  my($q) = @_;
  my $format = $q->{format} || "tab";
  my $D = System->get_home() . "/DATA/sae";

  print Client->http_OK();

  if ( $format eq "xml"){
    print "<SAEEventList>";
  }
  opendir(O, $D);
  my @L = readdir(O);
  closedir(O);
  foreach my $e (reverse sort @L) {
    next if (substr($e,0,1) eq ".");
    open(O, "$D/$e");
    my $comment = <O>; close(O);
    $comment = "" if (substr($comment,0,1) ne "#");
    if ( $format eq "xml"){
      print Client->xmlTagOpen("SAEEventItem");
      print Client->xmlAttrib("Name", $e);
      print Client->xmlTagClose();
      print Client->xmlEncode($comment);
      print Client->xmlEndTag("ITEM");
    }
    else {
      print "$e\t>$comment\n";
    }
  }
  if ( $format eq "xml"){
    print "</SAEEventList>";
  }
}


sub Print {
  my($q) = @_;
  my $format = $q->{format} || "tab";
  my $efile   = $q->{event};
  my $D = System->get_home() . "/DATA/sae";

  if (! -f "$D/$efile"){
    print Client->error($format, 100,
			"No data for event $efile.");
    return;
  }
  open(O, "$D/$efile");
  my @L = <O> ; close(O);
  my $ev = -1;
  my ($out, $comment, $cnt);

  print Client->http_OK();
  print "#<pre>\n";
  foreach my $l (@L) {
    print "$l";
   }
  print "#DONE";
}


sub Send {
  my($q) = @_;
  my $renv = System->get_renv();
  my $format = $q->{format} || "tab";
  my $efile  = $q->{event};
  my $ip     = $q->{url} || $renv->{"pro.sae.ip"};
  my $D = System->get_home() . "/DATA/sae";

  if (! -f "$D/$efile"){
    print Client->error($format, 100,
			"No data for event $efile.");
    return;
  }

  open(O, "$D/$efile");
  my ($send, $l);
  while ($l = <O>) {
     next if (substr($l,0,1) eq "#");
     $send .= $l;
  }
  close(O);

  if ($renv->{"pro.sae.active"} eq "N") {
    print Client->error($format, 101,
			"SAE not active at this time.");
    return;
  }

  my $url = ($ip =~ /^http/) ? $ip : "http://$ip";
  my($err, $resp) = Util::Http->post($url, $send, 60);

  print Client->http_OK();
  print "OK $efile";
}

  
1;
