package Client::Revision;

use strict;
use Modules;
use Html;
use Util;
use Data::Dumper;
use Matrix;
use Revision;
use Html::Tabs;
use Process;
use System;

sub run {
  my($q) = @_;

  my $host = $q->{host};
  my $matrix_name = $q->{matrix};
  my $args = $q->{modules};
  my $email = $q->{email};

  if (Process->status($q->{host}, "Revision") =~ /Running/) {
    print Client->error("xml", 901, "$host");
    return;
  }

  my $command = System->get_home() . "/bin/ras_revcheck -h \"$host\" -m \"$matrix_name\" -M \"$args\" -e \"$email\" -b > /dev/null";
  
  system($command);
  sleep(1);

  if ($Process::ERROR =~ /Can't connect/ ) {
    print Client->error("xml", 902, "$host");
  } else {
    print "<RUN>$host</RUN>";
  }
}

sub getReport {
  my($q) = @_;
  
  my ($rep, $VAR1);
  my $host = $q->{host};
  my $date;
  my $log;
  my $err;

  if (System->hostname() eq $host) {
    $rep = Util->deserialize("tmp/Revision");
    $date = Util->get_file_created(System->get_home() . "/DATA/tmp/Revision");
 
    my $logfile = System->get_home() . "/DATA/tmp/Revision_log";
    open(O, $logfile);
    my @lines = <O>; 
    close(O);
    $log = "@lines";
  
  } else {
    my $rc = Util::Http->readFile($host, "tmp/Revision");
    eval $rc;
    $rep = $VAR1;
    $date = $rep->{date};
    ($err, $log) = Util::Http->readFile($host, "tmp/Revision_log");
  }

  if (Process->status($host, "Revision") =~ /Running/) {
    print "<RevisionReport status=\"running\">\n";
    print "    <LOG>$log</LOG>\n";
    print "</RevisionReport>\n";
  } else { 
    my $data = $rep->{data};
    
    print "<RevisionReport status=\"end\">\n";
    print "    <LOG>$log</LOG>\n";
    foreach my $line (@$data) {
      print "  <REVISION>\n";
      print "    <TYPE>".$line->[0]."</TYPE>\n";
      print "    <NAME>".$line->[1]."</NAME>\n";
      print "    <STATUS>".$line->[2]."</STATUS>\n";
      print "    <CURVERSION>".$line->[3]."</CURVERSION>\n";
      print "    <EXPVERSION>".$line->[4]."</EXPVERSION>\n";
      print "    <CURPATCH>".$line->[5]."</CURPATCH>\n";
      print "    <EXPPATCH>".$line->[6]."</EXPPATCH>\n";
      print "    <COMMENT>".$line->[7]."</COMMENT>\n";
      print "  </REVISION>\n";
    }

    print "</RevisionReport>\n";
    
  }
    
}


sub getHosts {

  my($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read;
  print "<Hosts> \n";
  print "  <VALUE ID=\"".System->hostname()."\">".System->hostname()."</VALUE> \n";
  foreach my $h (@$hosts) {
    print "  <VALUE ID=\"".$h->{hostname}."\">".$h->{hostname}."</VALUE> \n";
  }
  print "</Hosts> \n";

}


sub getMatrice {
  my($q) = @_;

  my($D) =  System->get_home() . "/System/Matrix";
  opendir(O, $D);
  my @mats = readdir(O); closedir(O);
  my ($tem1, $tem2, $revi, $expire, $date);
  my @rev_mats = reverse @mats;
  my $today = substr(Util->get_today(), 0, 10);

  print "<RevMatrice>\n";
  foreach my $m (@rev_mats) {
     next if (substr($m,0,1) eq ".");
     next if (-d "$D/$m");
     open(OO2,"$D/$m");
     my $l;
     my $cnt;
     $expire = "";
     while ($l = <OO2>) {
          last if ($cnt++ > 40);
          if ($l =~ /XXEXPIRATION\s+(.*)/ ){
             $expire = $1;
          }
          if ($l =~ /Created/ ){
             ($tem1, $tem2, $date) = split (/\s+/, $l);
              if (!$expire || $expire ge $today) {
		print "  <VALUE ID=\"$m\">$m  -- $tem2 $date</VALUE>\n";
              }
          }

     }
     close(OO2); 
  }
  print "</RevMatrice>\n";

}

sub getModules {

  my($q) = @_;
 
  my($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read;

  my $F = System->get_home() . "/DATA/tmp/Revision";
  my $PIDF = System->get_home() . "/DATA/tmp/Revision_pid";
  my $LOG = System->get_home() . "/DATA/tmp/Revision_log";
  my $mods = Modules->load("Revision");
  my $cats = $Config->findActiveCategories($q->{host});

  my $hostname = System->hostname();
  my $solution = $renv->{solution} ne "N";

  # check if it is master
  if($hostname eq $q->{host}) {
    $solution = $renv->{solution} ne "N";
  } else {
    foreach my $h (@$hosts) {
      if ($h->{hostname} eq $q->{host}) {
	my $solution = $h->{solution} ne "N";
	last;
      } 
    }
  }
 
  $cats .= "|hba|host|" if (!$solution);
  $cats .= "|switch2|switch" if ($cats =~ /switch2/);

  print "<RevModules>\n";
  foreach my $m (sort @$mods) {
     my $func = "Revision::$m";           
     my $type = $func->type();
     if (index("|$cats|", "|$type|") >= 0) {
       print "  <VALUE ID=\"$m\">".$func->description()."</VALUE>\n"
     }    
  }
  print "</RevModules>\n";
 
}


1;





