package Client::Diagx;
use Client;
use Debug;
use strict;
use AutoForm;
use Scheduler;
use TO;
use Report;
use Diag;

use vars qw ($TT);
$TT = "ST";

sub help {
  print Client->http_OK();
  print "#<pre>\n";
  print <<EOF;
 Http Syntax:

 http://host:7654/rashttp?GO=Client::Diag::list&key=switch:12012e12
 http://host:7654/rashttp?GO=Client::Diag::list&mgmtLevel=DS
 http://host:7654/rashttp?GO=Client::Diag::list&type=switch|switch2|a5k|se...
 GO=Client::Diag::run&test=se_configcheck&opt_v=on
 GO=Client::Diag::status&pid=121212
 GO=Client::Diag::abort&pid=121212

EOF
}

use Data::Dumper;

# Return a list of diagnostic test options for either a device type or
# for a given device with options specific for the given device.
sub list {
  my($q) = @_;
  my($comp, $tests, $dev, $x, $key0);
  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $format = $q->{format} || "xml";

  my($err,$af) = AutoForm->new("System/Tests", {noInfo => 1});
  my $key      = $q->{key};
  my $devType  = $q->{type};
  my $testNo   = $q->{test};
  my $cnt=1;

  my $mode = $q->{mode};

  # Return test for a specific device.
  if ($key) {
     Debug->logLine("Client::Diag::list for $key test $testNo");

     my $to = TO->readTopo("MERGE-MASTER") || TO->readTopo();
     my($type, $k) = split(/\:/, $key);
     $dev = $to->nodeByName($key);
     if (!$dev) {
       TO->clearTopo();
       eval {
	 $to = TO->readTopo();
       };
       $dev = $to->nodeByName($key);
       if (!$dev) {
         print Client->error($format, 109, "Device $key not found in topology, need to re-create the snapshot.");
         return;
       }
     }

     Debug->logLine("Client::Diag::list dev=$dev key=$key type=$type");

     $tests = Tasks->ST_getTestList($af, $type, $dev, "e");
     if ($#$tests < 0) {
         print Client->error($format, 110, "No test available for $key");
         return;
     }

     require Diag;
     print Client->http_OK();
     print Client->xmlTag("DIAG_LIST");

     foreach my $t (@$tests) {
       my $testName = $t->{info}{sectionName};
       my $c = $af->commandByName($testName);
       my($form_err, $form_data) = Diag->validation($c, $testName, $to, $dev, {}, "preForm");
       # if we are in storade mode, keep parameters as is
       if ($mode ne "storade") {
         $form_data->{'#PASSES'} = 1;
       }
       my($cn, $reg_select, $all, $all_reg, $node, $multiple) =
	 Diag->register_list($type, $af, $t->sectionName() , $dev, "e", {mode => 'list'});
       &printit($af, $t, $cnt, $reg_select, $form_data);
       $cnt++;
     }
     print Client->xmlEndTag("DIAG_LIST");
     return;
  }

  Debug->logLine("Client::Diag::list for $devType");

  print Client->http_OK();
  print Client->xmlTag("DIAG_LIST");
  $Data::Dumper::Indent = 1;

# BY DEFAULT, SHOW RACK-LEVEL TESTS
  my $mgmtLevel = $q->{mgmtLevel};
  $mgmtLevel = "DS" if (!$devType && !$mgmtLevel);

  foreach my $com ($af->commandList()) {
     my $c = $af->commandByName($com);
     my $info = $c->info();
     next if ($devType && $info->{devType} ne $devType);
     next if ($mgmtLevel eq "DS" && $info->{devType} ne $renv->{solution});
     &printit($af, $c, $cnt);
     $cnt++;
  }
  print Client->xmlEndTag("DIAG_LIST");
}

sub printit {
  my($af, $c, $cnt, $regs, $form_data) = @_;
  my($x);
  my $info = $c->info();

  print Client->xmlTag("DIAG_TEST");
  print Client->xmlTag("TEST_INFO");

  foreach my $v (sort keys %$info) {
    print Client->xmlVALUE($v, $info->{$v});
  }
  print Client->xmlEndTag("TEST_INFO");

  if ($regs) {
    $regs =~ s/\t/\|/g;
    print Client->xmlTag("TEST_OPT");
    print Client->xmlVALUE("desc", "Register");
    print Client->xmlVALUE("name", "Register");
    print Client->xmlVALUE("opt", "register");
    print Client->xmlVALUE("type", "select");
    print Client->xmlVALUE("values", $regs);
    print Client->xmlEndTag("TEST_OPT");
  }

  my $opts = $c->{opts};
  for ($x=0; $x <= $#$opts; $x++) {
    print Client->xmlTag("TEST_OPT");
    my $opt = $opts->[$x];
    foreach my $v (sort keys %$opt) {
      my $V = exists $form_data->{$opt->{$v}} ? $form_data->{$opt->{$v}} : $opt->{$v};
      print Client->xmlVALUE($v, $V);
    }
    print Client->xmlEndTag("TEST_OPT");
  }


  if ($info->{defaults}) {
    my $c = $af->commandByName("DEFAULTS");
    my $def_opts = $c->{opts};
    for ($x=0; $x <= $#$def_opts; $x++) {
      print Client->xmlTag("TEST_OPT");
      my $opt = $def_opts->[$x];
      foreach my $v (sort keys %$opt) {
	my $V = exists $form_data->{$opt->{$v}} ? $form_data->{$opt->{$v}} : $opt->{$v};
	print Client->xmlVALUE($v, $V);
      }
      print Client->xmlEndTag("TEST_OPT");
    }
  }

  print Client->xmlEndTag("DIAG_TEST");
}

# GO=Client::Diag::run&key=sve:sdasda&test=se_configcheck&opt_verbose=on&opt_register=port1:1:192..

sub run {

  my($q) = @_;
  my($comp, $tests, $dev, $x);
  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $selected_test = $q->{test};
  my $host = $renv->{hostname};
  my $key = $q->{key};
  my $format = $q->{format} || "xml";
  $q->{register} = $q->{opt_register} if ($q->{opt_register});


  if (!$key) {
     Debug->logLine("Client::Diag::run Device key not found!");
      print Client->error($format, 110, "Device key not found!");
      return;
  }
  my $to = TO->readTopo("MERGE-MASTER") || TO->readTopo();
  my($type, $k) = split(/\:/, $key);
  my $dev = $to->nodeByName($key);

  if (!$dev) {
    Debug->logLine("Client::Diag::run $key not found in topo!");
    print Client->error($format, 111, "Device $key not found in topo!");
    return;
  }

  my($af_err,$af) = AutoForm->new("System/Tests", {noInfo => 1});

  my $af_test = $af->commandByName($selected_test);

  my($valid_err, $run_err, $text, $pid, $test_command, $opts ) = 
         Diag->run($af, $host, $q, $af_test, $selected_test, $to, $dev, "$key:e", 1);  # quiet


  if ($valid_err) {
    Debug->logLine("Client::Diag::run Validation Error: $valid_err");
      print Client->error($format, 111,"Validation Error: $test_command: $valid_err");
      return;
  }
  if ($text) {
    Debug->logLine("Client::Diag::run Command: $text");
    print Client->http_OK();
    print Client->xmlTag("DIAG_RUN");
    print Client->xmlEncode($text);
    print Client->xmlEndTag("DIAG_RUN");
    return;
  }

  if ($run_err) {
    Debug->logLine("Client::Diag::run $test_command: $run_err");
    print Client->error($format, 111,"$test_command: $run_err");
    return;
  } else {
    print Client->http_OK();
    if ($q->{DIRECT}) {
      return $pid;
    } else {
      Debug->logLine("Client::Diag::run $key $pid");
      print Client->xmlTagOpen("DIAG_RUN");
      print Client->xmlAttrib("status", "OK");
      print Client->xmlAttrib("pid", $pid);
      print Client->xmlTagClose();
    }
  }
}

# returns status and report itself
sub status {
  my($q) = @_;
  my $format = $q->{format} || "xml";
  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $selected_test = $q->{test};
  my $host = $renv->{hostname};
  my $pid  = $q->{pid};

  print Client->http_OK();
  print Client->xmlTagOpen("DIAG_STATUS");
  print Client->xmlAttrib("pid", $pid);
  print Client->xmlTagClose();

  my ($info, $pro, $out, $err) = Scheduler->read($TT, $host, $pid) ;

  foreach my $v (sort keys %$info) {
    print Client->xmlTag("STATUS_INFO");
    if ($v eq "info" ){
      print Client->xmlTag("INFO_DETAILS");
      my $sub = $info->{$v};
      foreach my $v1 (sort keys %$sub) {
	print Client->xmlVALUE($v1, $sub->{$v1});
      }
      print Client->xmlTagEnd("INFO_DETAILS");
    } else {
      my $sub = $info->{$v};
      print Client->xmlVALUE($v, $sub->{$v});
    }
    print Client->xmlTagEnd("STATUS_INFO");
  }

  my($x, $y);
  for ($x=0; $x <= $#$err; $x++) {
    print Client->xmlTag("DIAG_ERROR");
    print Client->xmlEncode($err->[$x]);
    print Client->xmlEndTag("DIAG_ERROR");
  }

  for ($x=0; $x <= $#$out; $x++) {
    my $rc = $out->[$x]{rc}; chomp($rc);
    print Client->xmlTagOpen("DIAG_OUTPUT");
    print Client->xmlAttrib("rc", $rc);
    print Client->xmlAttrib("date",$out->[$x]{date});
    print Client->xmlTagClose();
    print Client->xmlEncode($out->[$x]{output});
    print Client->xmlTagEnd("DIAG_OUTPUT");
  }

  print Client->xmlEndTag("DIAG_TEST");
}

# Abort a running test given a pid.
sub abort {
  my($q) = @_;
  my $format = $q->{format} || "xml";

  print Client->http_OK();
  print Client->xmlTagOpen("DIAG_ABORT");

  my($renv, $devices, $hosts, $notifs) = PDM::ConfigFile->read();
  my $host = $renv->{hostname};
  my $pid  = $q->{pid};
  my ($info, $pro, $out, $err) = Scheduler->read($TT, $host, $pid) ;
  my $done = Scheduler->kill($TT,$pid, $host , {child => 1, signal => 15});

  if (!$done) {
    print Client->xmlAttrib("status", "ERROR");
    print Client->xmlTagClose();
    print Client->xmlEncode($Scheduler::ERROR);
    print Client->xmlEndTag("DIAG_ABORT");
  } else {
    print Client->xmlAttrib("status", "OK");
    print Client->xmlTagClose();
  }
  Debug->logLine("Client::Diag::abort $pid $done $Scheduler::ERROR");
}

1;
