package Client;
use strict;

use vars qw($HEADER_DONE);

sub error {
  my($class, $format, $no, $v) = @_;

  my $out;
  $out .= "HTTP/1.0 200 OK\n" if (!$ENV{FCGI});
  $out .= "Content-type: text/html\n\n";

  if ($format eq "xml") {
     $out .= "<ERROR no=\"$no\">";
     $out .= Client->xmlEncode($v);
     $out .= "\n</ERROR>\n";
  } else {
     $out .= "#ERROR\t$no\t$v\n";
  }
  return $out;
}

sub http_OK {
  my($class)= @_;
  
  my $out;
  if (!$HEADER_DONE) {
    $out .= "HTTP/1.0 200 OK\n" if (!$ENV{FCGI});
    $out .= "Content-type: text/html\n\n";
    $HEADER_DONE=1;
  }
  return $out;
}

sub xmlHeader {
  return "<?xml version=\"1.0\"?>\n";
}

sub xmlEncode {
  my($class, $value) = @_;

  my $ret = $value;
  $ret =~ s/&/&amp;/g;
  $ret =~ s/</&lt;/g;
  $ret =~ s/>/&gt;/g;
  $ret =~ s/"/&quot;/g;
  $ret =~ s/'/&apos;/g;

  return $ret;
}

sub xmlAttrib {
   my($class, $attrib, $value) = @_;
   if ($value){
     return $attrib . "='" . Client->xmlEncode($value) . "' ";
   }
   else {
     return "";
   }
}

sub xmlTagOpen {
  my($class, $tag) = @_;
  return "<" . $tag . "\n";
}

sub xmlTagClose {
  return ">\n";
}

sub xmlTag {
  my($class, $tag) = @_;
  return "<" . $tag . ">\n";
}

sub xmlEndTag {
  my($class, $tag) = @_;
  return "</" . $tag . ">\n";
}

sub xmlVALUE {
  my ($class, $name, $value) = @_;
  if ($value){
    my $out;

    $out .= "<VALUE ID='";
    $out .= $name;
    $out .= "'>";
    $out .= Client->xmlEncode($value);
    $out .= "</VALUE>\n";

    return $out;
  }
  return "";
}


# [ {hash1}, {hash2} ... ]

sub xmlHashList {
  my($class, $name, $hashList) = @_;
  my $out;
  foreach my $e (@$hashList) {
     $out .= "  <$name>\n";
     foreach my $el (sort keys %$e) {
        $out .= "    <$el>$e->{$el}</$el>\n";
     }
     $out .= "  </$name>\n";
  }
  return $out;
}

1;
