package CIM::Key;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: Key.pm,v 1.4 2004/02/20 18:58:24 ccadieux Exp $

use Data::Dumper;
use strict;
use Carp;

#
#  key = [class, key1, val1, key2, val2...]
#
# create with validation: check for missing or invalid parts.

sub new {
  my($class, $arg) = @_;
  my($name, $type, $keys, $parent, $x, %K);
  my($self) = $arg;
  my($E) = NWS::Schema->database;
  my($e) = $E->{$arg->[0]};
  croak("InvalidKey " . ref($class) . ":$arg->[0]") if (!$e);
  my($db_props)  = $e->[1];

  foreach my $db_el (@$db_props) {
    if ($db_el->[2]) {  # a key
      $K{$db_el->[0]} = 0;
    }
  }

  for ($x=1; $x <= $#$arg ; $x+=2) {
    if ( !exists($K{$arg->[$x]}) ) {
       print "Invalid Key part: $arg->[$x] ($keys)" if (Debug->level() > 2);
    } else {
       $K{$arg->[$x]} = 1;
    }
  }
  foreach $x (keys %K) {
     print ",Key part '$x' missing on $arg->[0] " if (Debug->level() && $K{$x} == 0);
  }
       
  bless($self, "CIM::Key");
  return $self;
}

#  No validation
sub nv_new {
  my($class, $arg) = @_;

  my($self) = $arg;

  bless($self, "CIM::Key");

  return $self;
}

sub toInstance {
  my($key) = @_;
  my(@props, $x);

  for ($x=1; $x <= $#$key; $x+=2) {
    my($type) = (ref($key->[$x+1]) eq "CIM::Key")? "reference":"string";
    push(@props, CIM::Property->new( [$key->[$x], $key->[$x+1], $type, 1]) );
  }
  return CIM::GenInstance->new($key->[0], "C", \@props);
  
}

sub className {
  my($key) = @_;
  return $key->[0];
}

sub keys {
  my($key) = @_;
  my(@x) = @$key;
  shift(@x);
  return \@x;
}

sub toSerial {
  my($key) = @_;

  $Data::Dumper::Indent = 0;
  my($o) = Dumper($key);
  return substr($o, 7);
}

sub fromSerial {
  my($class, $s) = @_;
  my($o) = '';
  $s = '$o=' . $s;
  eval $s;
  return undef if ($@);
  return $o;
}

sub toXML {
  my($key) = @_;
  my($n , $v, $x);

  my($o) = "<INSTANCENAME CLASSNAME=\"$key->[0]\">";
  for ($x=1; $x <= $#$key; $x+=2) {
      $n = $key->[$x]; $v = $key->[$x+1];
      $o .= "<KEYBINDING NAME=\"$n\">";
      if (ref($v)) {
        $o .= "<VALUE.REFERENCE>" . $v->toXML . "</VALUE.REFERENCE>";
      } else {
        $o .= "<KEYVALUE VALUETYPE=\"string\">$v</KEYVALUE>";
      }
      $o .= "</KEYBINDING>";
  }
  $o .= "</INSTANCENAME>";
  return $o;
}

sub shortString {
  my($key) = @_;
  my($v, $k, $x);
  my($o) = ""; 
  for ($x=1; $x <= $#$key; $x+=2) {
     $v = $key->[$x+1];
     if (ref($v)) {
        $o .= "$key->[$x]=[" . $v->shortString . "],";
     } else {
        $o .= "$key->[$x]=$v,";
     }
  }
  chop($o) if ($o);
  return "$key->[0].$o";
}

sub values {
  my($key) = @_;
  my($v, $k, $x);
  my($o) = ""; 
  for ($x=1; $x <= $#$key; $x+=2) {
     $v = $key->[$x+1];
     if (ref($v)) {
        $o .= "[" . $v->keyValues . "],";
     } else {
        $o .= "$v,";
     }
  }
  chop($o) if ($o);
  return $o;
}


sub toString {
  my($key) = @_;
  my($v, $k, $x);
  my($o) = ""; 
  for ($x=1; $x <= $#$key; $x+=2) {
     $v = $key->[$x+1];
     if (ref($v)) {
        $o .= "\n       '$key->[$x]'->" . $v->toString . ",";
     } else {
        $o .= "'$key->[$x]'->'$v',";
     }
  }
  chop($o) if ($o);
  return "['$key->[0]',$o]";
}


1;


# 1;
#


__END__

=head1 NAME

Key.pm - Class that contains a CIM key.


=head3 SYNOPSIS

 use Key.

 $rep = Key->new({ ... });

 or 

 $ins = Instance->new(...);

 $key = $ins->key();



=head3 DESCRIPTION

This module creates a key object, it can be generated from the 'key'
method of an instance.



=head3 CONSTRUCTOR

=over 4

=item new([ <class>, <key1>, <val1>, <key2>, <value2> ]);

 Example:
   $key= Key->new([ 'Purple', serialNo => "123123123"]);


=back 4


=head3 METHODS

=over 4

=item className();

return the className of the Key.

=item keys();

returns an ARRAYREF to the keyname and values.

=item toXML();

convert to XML.

=item toSerial();

serialize.

=item fromSerial();

Unserialize.

=item toString();

Convert to a string for debugging.

=item shortString();

Convert to a short string to use in hashes.

returns category . ":" . name ;


=back 4

=head3 SEE ALSO

CIM::Instance


=head3 AUTHOR

 Christian Cadieux (ccadieux@central.sun)



=head3 COPYRIGHT

Copyright (c) 2000 Sun Microsystems

=cut
