package Agent::SE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2001, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $ 
#  $Id: SE.pm,v 1.23 2004/05/27 17:25:48 ccadieux Exp $

use Catalog;
use strict;
use Report;
use Agent;
use State;
use Agent::SE_MODULE;
use Agent::SLAVE;
use base 'Agent::SE_MODULE';
use Agent::SWITCH;

sub isSelectable { "Sun 3900/6900" }  # used to control rack as device
sub type         { Report::CAT_SE }

sub revision     {'$Revision: 1.23 $'}

use vars qw(%N2IP $ERR);

sub new {
  my($self) = Agent->new();

  bless ($self, 'Agent::SE');
  return $self;
}

sub RUN {
  my($agent, $static_list, $pass) = @_;
  my($err_lines, $warn_lines,  $out,$device, $connect_errs);
  my($report ,  $id, $lines, $log_err, $type);
  my($onedayold, $wwn, $portWWN, $port2WWN, $timelapse);
  $DB::single = 1;
  my ($renv, $devs, $hosts, $notifs, $Config) = PDM::ConfigFile->read();
  my $se = $agent->type();


  my($sdt);
  my($dc) = 0;

  if (index("|$renv->{categories}|", "|$se|") < 0) {
     return [];
  }

  my $processed_list = [];
  foreach $device ( $agent->deviceList($static_list, $se) ) {
       next if ($device->{mgmtLevel} ne "D");

       Debug->print1("-> Reading device $device->{name}: $device->{ip}");

       my($err, $report);
       if (System->get_testMode()) {
          $report = Report->readTest($device);
          
       } else {
          Timelapse->startDev( $device);
          ($err, $report) = Report->readReport($device->{type} . ":" . $device->{key}, 
                                    $device->{ipno}, 120);
          Timelapse->stopDev( $device);
          $report = $report ? $report->value() : {};
       }
       $id = { 
              deviceName  =>  $device->{key},
              active      =>  $device->{active},
              name        =>  $device->{name},
              class       => "storage.$se",
              display     => $device->{name},
              category    => $se,
              ip          => $device->{ip},
          };
       my $new_rep;
       if ($err) {
         $report->{'id.connect_errs'} = $err;
         $new_rep = Report->new($id, $report , "", Report::STATUS_CANNOT_CONNECT);
       } else {
         if (index("|$renv->{categories}|", "|san|") >= 0) {
            $report->{"FC_COUNTERS"} = $agent->FCfromReport($device, $report);
         }
         $report->{"id.name"}        = $device->{name};
         $report->{'id.mgmtLevel'}   = "D";
         $report->{"id.ip"}          = $device->{ip};
         $report->{"id.ipno"}        = $device->{ipno};
         $report->{"id.wwn"}         = $device->{key};
         $agent->copyDev($device, $report);
         $new_rep = Report->new($id, $report, "");
       }

       my $problems = PDM->get_last_event();

       if ($report->{"info.SLAVE_DATA"}) {
          my $idlist = Agent::SLAVE->readSlaveData($device->{ipno}, 
                                       "SLAVE_DATA.2", $device->{key}, 20);
          $idlist = Agent::SLAVE->readSlaveData($device->{ipno},   
                                       "SLAVE_DATA", $device->{key},   20);
       }
       require Health::SE_MODULE;
       Health::SE_MODULE->all_logic($new_rep);
       PDM->saveReport($new_rep);

       my ($broke, $abort) = $agent->new_events($problems, $device, 1);
       push(@$processed_list, $device);
       last if ($broke && $pass == 1 || $abort);
  }

  return $processed_list;

}

sub FCfromReport {
  my($agent, $device, $report) = @_;

  return {};
}



1;
