package Agent::SAMLOGMESSAGE;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2004, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>
#  $Name:  $ 
#  $Id: SAMLOGMESSAGE.pm,v 1.8 2004/08/26 23:48:35 ccadieux Exp $

use strict;
use State;
use PDM::Parse;
use Report;
use Agent;
use base 'Agent';
use Policies;
use RasThread;

sub isSelectable { 0 }
sub revision     { '$Revision: 1.8 $'}
sub type         { Report::CAT_SAMLOG }

use vars qw( $ERR %FOUND);

sub new {
  my($self) = Agent->new();
  bless ($self, 'Agent::SAMLOGMESSAGE');
  return $self;
}

use vars qw ($DONE);

sub RUN {
   my($agent, $static_list) = @_;

   Debug->print1("Executing agent SAMLOGMESSAGE");

   my $Config = PDM::ConfigFile->read();
   my $devs = $Config->devices();
   $DB::single = 1;
   if(!$devs) {
    return;
   }

    #Ensure that only active local SAM-QFS 
    my $found = 0;
    foreach my $d (@$devs) {
       next if (!$d->{ipno});
  	   if ($d->{ipno} eq Util->name2ip()) {
	     if ($d->{type} eq "samfs") {
           $found = 1;
		 }
	   } 
    }
	return if($found == 0);
    Debug->print3("SAMLOGMESSAGE: Processing found local SAM-QFS");

   my($err_lines, $warn_lines,  $out,$device, $connect_errs);
   my($report , $id, $lines, $log_err, $type);
   my( $wwn, $portWWN, $port2WWN);
   my $type = uc($agent->type());
 
   my $processed_list = [];
  
   my $renv     = System->get_renv();

   my ($logline, $logfile, $sysFac, $facID, $linesPointer, @confLines);
   my $CONFFILE = "/etc/opt/SUNWsamfs/defaults.conf";
   open(O, $CONFFILE); @confLines = <O>; close(O);
   $linesPointer = \@confLines;

   for (my $x=0; $x <= $#$linesPointer; $x++) {
     my $line = $linesPointer->[$x];
       if($line !~ /log\=LOG/) {
         next;
       } else {
         $logline = $line;	 
       }
   }
   
   if ($logline) {
     $sysFac = substr($logline, 4);
     if ($sysFac =~ /LOG_LOCAL/) {
	     my $x = substr($sysFac,9,1);
         $facID = "local$x\.notice";
     } else {
       #return error, can't find file location
     }
   } else {
	 $facID = "local7.notice";
   }

   my $SYSConf = "/etc/syslog.conf";
   open(O, $SYSConf); @confLines = <O>; close(O);
   $linesPointer = \@confLines;

   for (my $x=0; $x <= $#$linesPointer; $x++) {
     my $line = $linesPointer->[$x];
       if($line !~ /$facID/) {
         next;
       } else {
       $logfile = substr($line, 14);	 
     }
   }

   my $warn_lines = [];
   my $ISP;
   $DONE = 1;
   $logfile =~ s/[\n\t]//g;



   $logfile = "/var/adm/messages.sam" if (System->get_testMode());

   my @samlog = split(/\s+/, $logfile);  
   foreach my $logf (@samlog) {
     if ($logf && -r $logf) {
       ($log_err, $lines) = $agent->read_log_file($logf,'NEW');  
       Debug->err('CANNOT_READ', $logf) if ($log_err);
       $agent->find_alert($lines, $device, \$ISP, $warn_lines);
     }
   }
 
   my($name) = $renv->{hostname} || System->hostname();
   if ($#$warn_lines >= 0) {
      $id = {
            deviceName  =>  ($renv->{solution} eq "N") ? $renv->{hostname}: System->hostid(),
            active      => "Y",
            logFile     => $logfile,
            display     => "$name (id=" . System->hostid() . ")",
            name        => $name, 
            class       => "host",
            category    => Report::CAT_SAMLOG,
            ip          => "",
         };
      $report->{"id.name"} = $name;
      my $new_rep = Report->new($id, $report , $warn_lines, Report::STATUS_DONT_SAVE);
      require Health::Message;
      my $broke_list = Health::Message->all_logic($new_rep);
      foreach my $dev (@$broke_list) {
         $dev->{problems} = 2; # broke but not processed yet.
         push(@$processed_list, $dev);
      }
      PDM->saveReport($new_rep);
   }
 
   return $processed_list;
}



############################################################
#                    SUBROUTINES
############################################################


# 1 = warning
# 2 = errors

sub find_alert {
  my($agent, $lines, $device, $ISP, $err) = @_;
  my( $level, $name, $no1, $no2, $rest);
  my($m, $year, $date, $comp, $x);
  my($ipno);

  my $renv   = System->get_renv();
  my $Config = PDM::ConfigFile->read();
  my $devs = $Config->devices();
  my ( %IP, %DEV);


  my $policies = Policies->new("samfs_policies");
  my $playback = $main::TESTMODE;

  my ($comp1, $comp2, %MAP);
  
  for ($x=1; $x <= 2; $x++) {
    foreach my $d (@$devs) {
       next if (!$d->{ipno});
	   
       my $key = $d->{type} . ":" . $d->{key};
       my $hn  = $d->{host} || $renv->{hostname}; 

       if ($x == 1      && ($hn eq $renv->{hostname}) ) {
          $IP{$d->{ipno}} = $key;
          $DEV{$d->{ipno}} = $d;

       } elsif ($x == 2 && !exists $IP{$d->{ipno}}) {
          $IP{$d->{ipno}} = $key;
          $DEV{$d->{ipno}} = $d;
       }
       if ($x == 1 && $playback) {
         my $name    = $d->{name};
         $MAP{$name} = $d->{ipno};
         my $ix      = index($name, "-");
         if ($ix > 0) {
            $name       = substr($name, $ix+1);
            $MAP{$name} = $d->{ipno};
         }
       }
    }
  }

  for ($x = 0; $x <= $#$lines; $x++ ) {
     my $line = $lines->[$x];
     my(@a) = split(/\s+/, $line);
     my $ipnumber = $MAP{$a[3]} || Util->name2ip($a[3]);
     my ($key, $knownDevice, $key0);
     $knownDevice = 1;
     $key  = $IP{$ipnumber} . ":sam-log";
     $key0 = $IP{$ipnumber};
     my @lineFields = split(/\s+/, $line);

     my $date = $lineFields[0].$lineFields[1];
	 my $time   = $lineFields[2];
     my $device = $lineFields[3];
     my $topic  = $lineFields[4];
     my $id     = $lineFields[5].$lineFields[6];
     next if (!$time || !$device || !$topic || !$id || !$date);

 	 my $sev  = substr($lineFields[7], 7);

     chop($sev) if (substr($sev,-1) eq "]");

 	 next if (!$sev);

     my $desc;
     for (my $z = 8; $z <= $#lineFields; $z++ ) {
  	  $desc = $desc.$lineFields[$z]." ";
     }
 	 if (!$desc){
	  next;
	 }

  	 my $loglines = ["$date $time $device $device sev:$sev Type:$topic SystemID:$id Description: $desc"];

     my $y = 0;
     $policies->run($err,  $loglines, \$y, $topic, $device, $key, $ipnumber, 
                    $key0, $knownDevice);
  }         
  return ($err);
}
1;
