package Agent::3511;
#<copyright>
# ----------------------------------------------------------
# Sun Proprietary/Confidential Code
# Copyright 2004, Sun Microsystems, Inc. All rights reserved.
# ----------------------------------------------------------
#</copyright>

#  $Name:  $
#  $Id:
use strict;
use Agent::3310;
use base 'Agent::3310';

sub isSelectable {"Sun 3511"}
sub revision {'$Revision: 1.8 $'}

# DO NOT REMOVE THIS COMMENT
# Report::CAT_3310MESSAGE


sub category {Report::CAT_3511}

sub new 
{
  my($self) = Agent->new();

  bless ($self, 'Agent::3511');
  return $self;
}


sub REPORT 
{
  my($class, $host, $r, $arg) = @_;

  my($v) = $r->{_value};
  my($out);
  my($tableCnt) = $arg->{tableCnt};
  my($host0) = $host || System->hostname();
  my $comm = ($r->{_status} eq "CC") ? "<font color=red>Communication Lost: Data may be old!</font>" : "";
 

  $out .= $class->reportHead($v->{'info.product'}, $r);
  my $cnt;
  $out .= "<tr> <td colspan=4><center><b>$v->{'info.Product'} $v->{'info.unique_id'}</td>";
  $out .= "<tr> <td colspan=4><b><center>$comm</td>";
  foreach my $el (sort keys %$v) 
  {
     if ($el =~ /^info\.(.+)/)  
     {
       my $n = $1;
       next if (index(",Serial_Number,manufacturer,model,bootrecord_version,total_disk,total_other,Vendor,name,sccli,unique_id,", ",$n,") >= 0);
       next if (index(",Product,Revision,disk_map,top_disk,Device_Type,", ",$n,") >= 0);
       next if ($n =~ /id_of_/);
       $n =~ s/^total_//;
       $n =~ s/_/ /g;
       $out .= "<tr>" if ($cnt++ % 2 == 0);
       my $v1 = $v->{$el};
       my $le = length($v1);
       if ($le > 20) 
       {
         my $half = int($le/2);
         $v1 = "<small>" . substr($v1,0,$half) . " " . substr($v1,$half);
       }
       $out .= "<td bgcolor=$Style::LIGHT align=right>$n:</td>
                   <td>&nbsp;$v1</td>";
     }
  }
  $out .= "</table>";

# CHANNELS

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=7><font color=white><b>Channels</td>
    <tr bgcolor=$Style::LIGHT>
        <th>#
        <th>Port
        <th>Type
        <th>Media
        <th>Speed
        <th>Width
        <th>PID/SID
   ";
  my($x);
  my $port= 0;
  for ($x=1; $x <= 100; $x++) 
  {
     last if (!$v->{"channel.$x.type"});
     my $mode = $v->{"channel.$x.mode"};
     my $p;
     if ($mode eq "Host") 
     {
        $port++;
        $p = $port;
     }
     $out .=<<EOF;
        <tr><td>$v->{"channel.$x.idx"}</td>
         <td>&nbsp;$p</td>
         <td>$mode</td>
         <td><center>$v->{"channel.$x.type"}</td>
         <td><center>$v->{"channel.$x.curclk"} 
         <td><center>$v->{"channel.$x.defwid"}
         <td><center>$v->{"channel.$x.pid"}/$v->{"channel.$x.sid"}&nbsp;
EOF
  }
  $out .= "</table>";

######################
# DISKS

  my %DD;
  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=7><font color=white><b>Disks</td>
    <tr bgcolor=$Style::LIGHT>
        <th>Ch-Id
        <th>enclosure-id
        <th>Size
        <th>Status
        <th>Model / Serial#
        <th>Rev
   ";
  my $x;
  my $top_disk = $v->{"info.top_disk"};
  for ($x=0; $x <= $top_disk; $x++) 
  {
     next if (!$v->{"components.disk.$x.model"});
     my $s = $v->{"components.disk.$x.capacity"};
     my $ch = $v->{"components.disk.$x.ch"};
     my $eid = $v->{"components.disk.$x.enclosure_id"};
     my $tg = $v->{"components.disk.$x.target"};
     $DD{"$ch.$tg"} = $v->{"components.disk.$x.model"} . " " . 
                      $v->{"components.disk.$x.serial_number"} . " $s";
     my $st = $v->{"components.disk.$x.status"};
     my $col = "bgcolor=#FFC0C0" if ($st =~ /Bad/i);
     $s="N/A" if ($st =~ /Bad/);
                  
     $out .=<<EOF;
        <tr><td><center>$ch-$tg</td>
         <td><center>$eid</td>
         <td align=right>$s&nbsp;</td>
         <td $col><center>$st</td>
         <td><small>$v->{"components.disk.$x.model"} / 
                    $v->{"components.disk.$x.serial_number"}&nbsp;
         <td>$v->{"components.disk.$x.product_revision"} 
EOF
  }
  $out .= "</table>";


# FRUS

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=7><font color=white><b>Frus</td>
    <tr bgcolor=$Style::LIGHT>
        <th>#
        <th>Name
        <th>enclosure id
        <th>Vendor/Model/Serial
        <th>Chassis Serial #
        <th>Location
        <th>Rev
   ";
  my $x;

  foreach my $el (keys %$v) {
    if ($el =~ /fru\.(\w+)\.name/) {
     my $x = $1;
     my $item = $v->{"fru.$x.description"};
     $out .=<<EOF;
        <tr>
              <td>$v->{"fru.$x.idx"}</td>
              <td><small>$item</td>
              <td><small>$v->{"fru.$x.enclosure_id"}</td>
              <td><small>$v->{"fru.$x.manufacturer_jedec_id"}/ $v->{"fru.$x.part_number"}/ $v->{"fru.$x.serial_number"}</td>
              <td><small>$v->{"fru.$x.chassis_serial_number"}</td>
              <td><small>$v->{"fru.$x.fru_location"}</td>
              <td><center>$v->{"fru.$x.revision"}</td>
EOF
    }
  }
  $out .= "</table>";

# Router Asset Data

  $out .="<table border=1 cellspacing=0 width=95% bgcolor=white>
  <tr bgcolor=$Style::DARK><td colspan=7><font color=white><b>SATA Router</td>
  <tr bgcolor=$Style::LIGHT>
        <th>Channel
        <th>Enclosure ID
        <th>Slot
        <th>HW Rev
        <th>Boot Rev
        <th>Revision
        <th>CSB
  ";

  my $routerCount = $v->{"info.total_sata_routers"};

  for ($x=1; $x <= $routerCount; $x++) 
  {
     last if (!$v->{"sata_router.$x.ch"});
     $out .=<<EOF;
        <tr>
              <td><small>$v->{"sata_router.$x.ch"}</td>
              <td><small>$v->{"sata_router.$x.encl_id"}</td>
              <td><small>$v->{"sata_router.$x.slot"}</td>
              <td><small>$v->{"sata_router.$x.hw_rev"}</td>
              <td><small>$v->{"sata_router.$x.boot_rev"}</td>
              <td><small>$v->{"sata_router.$x.rev"}</td>
              <td><small>$v->{"sata_router.$x.csb"}</td>
EOF
  }


  $out .= "</table>";

# MUX Asset Data

  $out .="<table border=1 cellspacing=0 width=95% bgcolor=white>
  <tr bgcolor=$Style::DARK><td colspan=5><font color=white><b>FC-SATA MUX Board</td>
  <tr bgcolor=$Style::LIGHT>
        <th>Ch-Id
        <th>Serial Number
        <th>Type
        <th>PC-150 Boot
        <th>PC-150 Rev
  ";

  my $muxCount = $v->{"info.total_sata_mux"};

  for ($x=1; $x <= $muxCount; $x++) 
  {
     last if (!$v->{"sata_mux.$x.ch"});

     my $ch = $v->{"sata_mux.$x.ch"};
     my $id = $v->{"sata_mux.$x.id"};

     $out .=<<EOF;
        <tr>
              <td><small>$ch-$id</td>
              <td><small>$v->{"sata_mux.$x.mux_sn"}</td>
              <td><small>$v->{"sata_mux.$x.mux_type"}</td>
              <td><small>$v->{"sata_mux.$x.pc150_boot"}</td>
              <td><small>$v->{"sata_mux.$x.pc150_rev"}</td>
EOF
  }


  $out .= "</table>";


# Battery Status

  $out .="<table border=1 cellspacing=0 width=95% bgcolor=white>
  <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Battery</td>
  <tr bgcolor=$Style::LIGHT>
        <th>Manufacturing date
        <th>Name
        <th>Start service date
        <th>Expire date
        <th>Status
        <th>Type
  ";

  for ($x=1; $x <= 4; $x++) 
  {
     last if (!$v->{"battery_status.$x.manufacturing_date"});
     $out .=<<EOF;
        <tr>
              <td><small>$v->{"battery_status.$x.manufacturing_date"}</td>
              <td><small>$v->{"battery_status.$x.name"}</td>
              <td><small>$v->{"battery_status.$x.placed_in_service"}</td>
              <td><small>$v->{"battery_status.$x.expiration_date"}</td>
              <td><small>$v->{"battery_status.$x.status"}</td>
              <td><small>$v->{"battery_status.$x.type"}</td>
EOF
  }


  $out .= "</table>";
  

######################
# LOGICAL DRIVE

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Logical Drives</td>
    <tr bgcolor=$Style::LIGHT>
        <th> LD Number 
        <th>Role
        <th>Drives
        <th>Status
        <th>Size
        <th>Raid
   ";
  my ($x, $y);
  foreach my $el (keys %$v) 
  {
     if ($el =~ /logical_drive\.(\w+)\.status/) 
     {
       my $x = $1;
       $out .=<<EOF;
        <tr><td><b><center>$v->{"logical_drive.$x.ld_id"}
            <td><center>$v->{"logical_drive.$x.assignment"}
            <td><center>$v->{"logical_drive.$x.number_of_drives"}
            <td><center>$v->{"logical_drive.$x.status"}
            <td align=right>$v->{"logical_drive.$x.size"}
            <td><center>$v->{"logical_drive.$x.raid_level"}
EOF
       my $details = &logical_drives($v, "logical_drive.$x", \%DD);
       my $parts   = &logical_partitions($v, "logical_drive.$x");

       $out .= "<tr><td>&nbsp;</td><td colspan=5>$details $parts</td>";
     }
  }
  $out .= "</table>";

######################
# LOGICAL VOLUME

  $out .= "<table border=1 cellspacing=0 width=95% bgcolor=white>
    <tr bgcolor=$Style::DARK><td colspan=6><font color=white><b>Logical Volumes</td>
    <tr bgcolor=$Style::LIGHT>
        <th>#
        <th>Assignment
        <th>Status
        <th>Size
   ";
  my ($x, $y, $p, $d);
  for ($x=1; $x <= 2000; $x++) 
  {
     last if (!exists $v->{"logical_volume.$x.lv_idx"});
     my $idx = $v->{"logical_volume.$x.lv_idx"};
     my $ass = $v->{"logical_volume.$x.assignment"};
#     my $size= &size($v->{"logical_volume.$x.size"});
     my $size= $v->{"logical_volume.$x.size"};
     my $status= $v->{"logical_volume.$x.status"};
     my $pre = "logical_volume.$x";
     $out .= "
        <tr><td><b><center><b>lv$idx</td>
            <td><center>$ass</td>
            <td>$status</td>
            <td align=right>$size</td>";

     my $parts   = &logical_partitions($v, "logical_volume.$x");
     my ($details, $dd);
     $details = "<table border=1 cellspacing=0 width=100%><tr bgcolor=$Style::LIGHT>
        <th>Drive#</th>
        <th>Role</th>
        <th>Drives</th>
        <th>Status</th>
        <th>Size</th>
        <th>Raid</th>";

     for ($dd=1; $dd <= 1000; $dd++) 
     {
        last if (!exists $v->{"$pre.logical_drive.$dd.ld_idx"});
        my $idx = $v->{"$pre.logical_drive.$dd.ld_idx"};
        my $ass = $v->{"$pre.logical_drive.$dd.assignment"};
        my $cnt = $v->{"$pre.logical_drive.$dd.number_of_drives"};
        my $level = $v->{"$pre.logical_drive.$dd.raid_level"};
        my $status= $v->{"$pre.logical_drive.$dd.status"};
#        my $size  = &size($v->{"$pre.logical_drive.$dd.size"});
        my $size  = $v->{"$pre.logical_drive.$dd.size"};
        $details .= "<tr>
                   <td><b>ld$idx</td>
                   <td>$ass</td>
                   <td>$cnt</td>
                   <td>$status</td>
                   <td>$size</td>
                   <td>$level</td>";

        $details .= "<tr><td>&nbsp;</td><td colspan=5> " . 
                     &logical_drives($v, "$pre.logical_drive.$dd", \%DD) . "</td>";
     }
     $details .= "</table>";
     $out .= "<tr><td colspan=1>&nbsp;</td><td colspan=3>$parts $details</td>";
  }
  $out .= "</table>&nbsp;<p>&nbsp;<p>";

  return $out;

}



sub logical_drives 
{
  my($v, $pre, $DD) = @_;
  my $details;
  my @dd = split(/\s+/, $v->{"$pre.physical_drive"});

  foreach my $d (@dd) 
  {
       my $d0 = $d; $d0 =~ s/\./-/;
       my $dinfo = 
       $details .= "&nbsp;[Disk $d0] <small>$DD->{$d}</small> <br>";
  }
  return $details;
}

sub logical_partitions 
{
  my($v, $pre) = @_;
  my ($details);
  my $part_cnt = $v->{"$pre.total_partitions"};
  my($y);
  for ($y=1; $y <= $part_cnt; $y++) 
  {
       my $eff0 = $v->{"$pre.partition.$y.effective_size"};
#       my $eff  = sprintf("%.3f GB", $eff0 / 1024);
       my $map  = $v->{"$pre.partition.$y.mapping"};
       my $idx  = $v->{"$pre.partition.$y.idx"};
       $details .= "&nbsp;Partition-$idx: [$eff0] Mapping: $map<br>";
  }
  return $details;
}

1;
