package Advisor;

use System;
use strict;
use Html;
use Grid;
#
# <svc procedure=6020.disk>Replace a disk</a>
#
#  $fru = $q->{fru}
# <svc include=Service/test2&fru=$fru>
# <svc include=Service::Rules::rule1>
# <svc if=Service::Rules::rule2 include=Service/test4,Service/test5>   # true, false
# <svc case=Service::Rules::rule2 include=Service/test4,Service/test5> # case1, case2
#
# <svc help=Service/test3&fru=$fru>Display test3 in the same window</a>
# <svc window_help=Service/test3 size=400x600>Display test3 in a new window</a>
# <svc next=/Service/test2>
# <svc sp>
#
# <svc http=Service::Util::ether>Go to the Ethers Section</a>
# <svc window_http=Service::Util::ether size=300x300>Go to the Ethers Section in a new window</a>
#
# <svc checkbox=1>
#
# <svc step=1 name="This is step 1">
# This is step 1
# <b>STEP 1</b>
# <svc step=2 name="This is step 2">
# This is step 2 <b>STEP 2</b



sub process {
 my($class, $data, $page, $wiz, $q, $level) = @_;
 $wiz = {} if (!defined($wiz));
 Grid->loadServices();

 $data =~ s/\$(\w+)/$q->{$1}/eg;
 $data =~ s/\<svc\s+([^>]+)\>/&process_($1,$page, $wiz, $q, $level)/eg;

 return $data;
}

sub readHtdocs {
  my($class, $file, $q) = @_;

  my $page = Html->readHtdocs($file);
  my $wiz = {};
  $page = Advisor->process($page, 1, $wiz, $q);
}

sub functions {
  my($class) = @_;
  my $renv = System->get_renv();
  my $opener = ($renv->{window} eq "N") ? "window" : "opener";
  $a=<<EOF;
<script>
 function win2(a,w,h) {
   var b = '$Http::WEBPROC?GO=' + a;
   var O = window.open(b,'advisor','menubar=no,resizable=yes,scrollbars=yes,width='+w+',height='+h);
   O.focus();
 }
 function win1(a, from, w, h, section) {
   var b = '$Http::WEBPROC?GO=Service::Advisor::helpW&SVC_PAGE=' + a + '&FROM=' + from + '&SECTION=' + section;
   var O = window.open(b,'advisor','menubar=no,resizable=yes,scrollbars=yes,width='+w+',height='+h);
   O.focus();
 }
 function service(a) {
    $opener.document.location = '$Http::WEBPROC?GO=Service::Advisor::help&SVC_PAGE=' + a;
 }
</script>
EOF

}


########################
##  PROCESS
########################

sub process_  {
  my($rest, $page, $wiz, $q, $level) = @_;
  
  if ($rest =~ /^step\=(\d+)\s+name=(.*)/) {
     my $step = $1;
     my $name = $2;
     $wiz->{max} = $step if ($step > $wiz->{max});
     $name = substr($name,1,-1) if (substr($name,0,1) eq "\"");
     $wiz->{$step} = $name;
     return "<svc step=$1 name=$name>";

  } elsif ($rest =~ /^include\=([\/\w\-\:\=\&\$\.]+)/) {
      return  &include($1,$level,$page, $q);

  } elsif ($rest =~ /^includeNNL\=([\/\w\-\:\=\&\$\.]+)/) {  # remove newlines
      my $rc = &include($1,$level,$page, $q);
      $rc =~ s/\n//g;
      return $rc;

  } elsif ($rest =~ /^case\=([\/\w\-\:]+)\s+include=([\/\w\-\:\,\&\=\$\.]+)/) {
      my $func    = $1;
      my $options = $2;
      return &case($func , $options, $level, $page, $q);

  } elsif ($rest =~ /^if\=([\/\w\-\:]+)\s+include=([\/\w\-\:\,\.\&\=\$]+)/) {
      my $func    = $1;
      my $options = $2;
      return &if($func , $options, $level, $page, $q);

  } elsif ($rest =~ /^mainPage=([\/\w\-\:\,\&\=\$\.]+)/) {
      return &service_procedure($1,$level, $page, $q); 

  } elsif ($rest =~ /^procedure=([\/\w\-\:\,\&\=\$\.]+)/) {
      my $url = Grid->readService($1);
      return &service_procedure($url,$level, $page, $q); 

  } elsif ($rest =~ /^checkbox=(\d+)/) {
      return &checkbox($1);

  } elsif ($rest =~ /^window_help=([\w\-\/\&\:\=\$\.]+)/) {
      return &adv_help($1,1,$page, $rest, $q);

  } elsif ($rest =~ /^page=([\w\-\,\/\&\:\=\$\.]+)/ ) {
      my $pag = $1;
      my($prev, $next) = split(/,/, $pag);
      my $o;
      $o .= " <input type=submit name=\"ACTION_NP_$prev\" value=\"PrevPage\"> " if ($prev);
      $o .= " <input type=submit name=\"ACTION_NP_$next\" value=\"NextPage\"> " if ($next);
      return "<table border=0 width=100% bgcolor=white><tr><td>$o</table>";

  } elsif ($rest =~ /^select=([\w\-\/\&\:\=\$\.]+)\s+name=([\w]+)/ ) {
     my $func = $1;
     my $nam = $2;
     return &select($func, $nam, $level, $page, $q);

  } elsif ($rest =~ /^next=([\w\-\/\&\:\=\$\.]+)\s+label=([\w]+)/ ) {
      my $pag = $1;
      my $n   = $2;
      return " <input type=submit name=\"ACTION_NP_$pag\" value=\"$n\"> ";

  } elsif ($rest =~ /^prev=([\w\-\/\&\:\=\$\.]+)\s+label=([\w]+)/ ) {
      my $pag = $1;
      my $n   = $2;
      return " <input type=submit name=\"ACTION_NP_$pag\" value=\"$n\"> ";

 
  } elsif ($rest =~ /^help=([\w\-\/\&\:\=\$\.]+)/) {
      return &adv_help($1,0,$page, $rest, $q);

  } elsif ($rest =~ /^window_http=([\w\-\/\:\&\=\$\.]+)/) {
      return &http_link($1,1,$page, $rest, $q);

  } elsif ($rest =~ /^http=([\w\-\/\:\&\=\$\.]+)/) {
      return &http_link($1,0,$page, $q);
  }
}
  

# NOT USED

sub sp_link {
  my($renv) = System->get_renv();
  my($ip);
  if (open(O, System->get_home() . "/DATA/EXTERNAL_IP")) {
     $ip = <O>; close(O);
  }
  my ($port, $text);
  if ($renv->{solution} eq "N") {
     $text = "StorADE Master";   $port = "7654";
  } elsif ($renv->{solution} eq "se") {
     $text = "Service Processor"; $port = "7654";
  } else {
     $text = "Service Processor"; $port = "6789";
  }
  if ($ip) {
    return "<a href=$ip>$text</a>";
  } else {
    return "[$text (port $port)]";
  }
}
     


sub  http_link {
  my($file, $window, $from, $rest, $q) = @_;
 
  my $args;
  foreach my $e (keys %$q) {
    next if ($e eq "GO" || substr($e,0,6) eq "COOKIE" || substr($e,0,7) eq "ACTION_");
    $args .= "&$e=$q->{$e}";
  }
  if ($window) {
    my($W, $H) = &calc_size($rest);
    return "<a href=javascript:win2('$file$args',$W,$H)>";
  } else {
    return "<a href=\"/rashttp?GO=$file$args\">";
  }
}

sub calc_size {
  my($rest) = @_;

  my $W = 650;
  my $H;
  if ($rest =~ / size=([x\d]+)/) {
     ($W,$H) = split(/x/, $1);
  }
  $H = int($W * 1.1) if (!$H);
  return ($W, $H);
}

sub select {
  my($func, $name, $level, $pageno, $q) = @_;

  my $select_list;
  if (index($func, "::") >= 0) {  # program
     my($file0, $file1) = &parse($func, $q);
     eval "require $file0";
     $select_list = &$file1($q);
  } else {                        # file
     $select_list = Html->readHtdocs($func);
  }
  my @L = split(/\n/, $select_list);
  my $sel = "<select name=$name>";
  foreach my $e (@L) {
    my @a = split(/\=/, $e);
    next if ($#a < 1);
    $sel .= "<option value=$a[0]>$a[1]</option>";
  }
  $sel .= "</select>";
  return $sel;
}


sub adv_help {
  my($file, $window, $from, $rest, $q) = @_;

  my $args;
  foreach my $e (keys %$q) {
    next if ($e eq "SVC_PAGE" || $e eq "FROM" || $e eq "GO" || substr($e,0,6) eq "COOKIE" 
             || substr($e,0,7) eq "ACTION_");
    $args .= "&$e=$q->{$e}";
  }
  
  if ($window) {
    my($W, $H) = &calc_size($rest);
    return "<a href=javascript:win1('$file$args','$from',$W,$H,'$q->{SECTION}')>";
  } else {
    return "<a href=\"/rashttp?GO=Service::Advisor::help$args&SVC_PAGE=$file&FROM=$from\">";
  }
}

#
# CALL DOUG's procedures
# #
sub service_procedure {
  my($entry, $level, $page, $q) = @_;
  my $args = Html->makeArgs($q, "SVC_PAGE,FROM,");
  return "<a href=javascript:service('$entry$args')>";

}

sub checkbox {
  my($val) = @_;

  $val = "checked" if ($val);

  return "<input type=checkbox $val>";
}


sub if {
   my($func, $options, $level, $pageno, $q) = @_;

   my($file0, $file1) = &parse($func, $q);
   eval "require $file0";
   my $rc = &$file1($q);
   my @options = split(/,/, $options);
   my $page;
   my $p = $rc ? $options[0] : $options[1];
   if ($p) {
     $page = Html->readHtdocs($p);
     my $wiz = {};
     $page = Advisor->process($page, $pageno, $wiz, $q, $level);
   } else {
     $page = "No page $rc in $options ($func)";
   }
   return $page;
}


sub case {
   my($func, $options, $level, $pageno, $q) = @_;

   my($file0, $file1) = &parse($func, $q);
   eval "require $file0";
   my $rc = &$file1($q);
   my @options = split(/,/, $options);
   my $page;
   if ($options[$rc-1]) {
     $page = Html->readHtdocs($options[$rc-1]);
     my $wiz = {};
     $page = Advisor->process($page, $pageno, $wiz, $q, $level);
   } else {
     $page = "No page $rc in $options ($func)";
   }
   return $page;
}

sub parse {
  my($file, $q) = @_;

  my $ix = index($file, "&");
  my ($file2, $args);
  if ($ix >= 0) {
     $file2 = substr($file, 0, $ix);
     $args  = substr($file, $ix+1);
  } else {
     $file2 = $file;
  }
  my $ix = rindex($file2, "::");
  my($file0, $file1, $all);
  if ($ix > 0) {
    $file0 = substr($file2, 0, $ix);
    $file1 = substr($file2, $ix+2);
    $all = $file0 . "::$file1";
  } else {
    $file0 = $all = $file2;
  }
  Http::parse($args, $q) if ($args);
  return ($file0, $all);
}

sub log1 {
  my($v) = @_;
  open(W, ">>/tmp/advisor"); print W "$v\n"; close(W);
}

sub include {
  my($file, $level, $pageno, $q) = @_;

  my $page;
  if (index($file, "::") >= 0) {  # program
     my($file0, $file1) = &parse($file, $q);
     eval "require $file0";
     $page .= &$file1($q);
  } else {                        # file
     my($file0, $file1) = &parse($file, $q);
     $page = Html->readHtdocs($file0);
  }
  $level++;
  if ($level < 5) {
    my $wiz = {};
    $page = Advisor->process($page, $pageno, $wiz, $q, $level);
  } else {
    $page .= "<font color=red><b>ERROR svc_include recurse more than $level levels deep!</b></font>";
  }
  return $page;
}


1;


  
