#!/usr/bin/perl -I/opt/SUNWstade/lib
use Email;
use MakeKey;

# Takes 1 argument. Argument 1 is the directory where the persistence queue exis ts.

if($#ARGV != 0) {
 print "Usage: emailIS.pl persistenceQueueDir\n";
 exit 1;
}

$| = 1;

$outputDir = $ARGV[0];

$filename = "$outputDir/$$." . time;

$ncdfilename = $filename.".toc";

# Read from STDIN until the end of the email header.
# First empty line is the end of the header.

my($in, $message, $key, $all);

while ($l = <STDIN>) {
  if ($in) {
     $message .= $l;
  } elsif ($l =~ /secureTOC: \[(\w+)\]/) {
     $key = $1;
  } elsif ($l =~ /^$/) {
     $in = 1;
  }
}

if ($key) {
  $key = MakeKey->make_key($key);
}
my($sig, $decrypt) = Email->decrypt_email($message, $key);

open(MSG,">$filename");
print MSG $decrypt;
close(MSG);

chmod(0777,$filename);

# Change the filename so that it has the ".ncd" extension and thus can be
# consumed by the Repository Manager.

rename($filename,$ncdfilename);
