/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.fm.storade.util;

import com.sun.netstorage.fm.storade.util.LockManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class ResourceLock {
    private String resourceName;
    private long expireSeconds;
    private String pid;
    private String info;
    private String application = "Java";
    private String description = "";
    private String ip_address = "localhost";
    private String userName = "nobody";
    public static final String sccs_id = "@(#)ResourceLock.java 1.2     03/12/05 SMI";

    public ResourceLock(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null");
        }
        int n = string.lastIndexOf(".lock");
        this.resourceName = n > 0 ? string.substring(0, n) : string;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public long getExpireTime() {
        return this.expireSeconds;
    }

    public long getExpireInterval() {
        long l = this.expireSeconds - this.getCurrentSeconds();
        return l < 0L ? 0L : l;
    }

    public String getLockProcessId() {
        return this.pid;
    }

    public String getInfo() {
        return this.info;
    }

    private String getInfo(int n) {
        String string = null;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.info, "|", true);
            int n2 = 0;
            String string2 = "|";
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if ("|".equals(string3)) {
                    ++n2;
                    if ("|".equals(string2)) {
                        string = "";
                    }
                } else {
                    string = string3;
                }
                if (n2 == n) {
                    return string;
                }
                string2 = string3;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    public String getApplication() {
        return this.getInfo(1);
    }

    public String getDescription() {
        return this.getInfo(3);
    }

    public Date getStartDate() {
        String string = this.getInfo(4);
        if (string == null) {
            return null;
        }
        try {
            int n = Integer.parseInt(string.substring(0, 4));
            int n2 = Integer.parseInt(string.substring(5, 7));
            int n3 = Integer.parseInt(string.substring(8, 10));
            int n4 = Integer.parseInt(string.substring(11, 13));
            int n5 = Integer.parseInt(string.substring(14, 16));
            int n6 = Integer.parseInt(string.substring(17, 19));
            Calendar calendar = Calendar.getInstance();
            calendar.set(n, n2, n3, n4, n5, n6);
            return calendar.getTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getDuration() {
        String string = this.getInfo(5);
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return (int)(this.getExpireInterval() / 60L);
        }
    }

    public String getIpAddress() {
        return this.getInfo(6);
    }

    public String getUser() {
        return this.getInfo(7);
    }

    public void setInfo(String string, String string2, String string3, String string4) {
        this.application = string;
        this.description = string2;
        this.ip_address = string3;
        this.userName = string4;
    }

    public boolean isLocked() {
        if (this.getCurrentSeconds() > this.expireSeconds) {
            this.unlink();
            return false;
        }
        return true;
    }

    public boolean isFRULocked() throws IOException {
        Object object;
        File file = new File("/tmp/MgmtLocks");
        String string = this.resourceName + "~";
        String[] stringArray = file.list(new FRUFilter(string));
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                object = new ResourceLock(stringArray[n]);
                ((ResourceLock)object).readLock();
                if (((ResourceLock)object).isLocked()) {
                    return true;
                }
                ++n;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.resourceName, "~");
        object = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            object = object == null ? string2 : (String)object + "~" + string2;
            ResourceLock resourceLock = new ResourceLock((String)object);
            resourceLock.readLock();
            if (!resourceLock.isLocked()) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void readLock() throws IOException {
        FileReader fileReader;
        block8: {
            block7: {
                File file = this.getResourceFile();
                if (!file.exists()) {
                    this.expireSeconds = 0L;
                    this.pid = null;
                    this.info = null;
                    return;
                }
                fileReader = null;
                try {
                    try {
                        fileReader = new FileReader(file);
                        BufferedReader bufferedReader = new BufferedReader(fileReader);
                        String string = bufferedReader.readLine();
                        if (string == null) {
                            this.expireSeconds = 0L;
                            this.pid = null;
                            this.info = null;
                            Object var6_6 = null;
                            if (fileReader == null) return;
                            break block7;
                        }
                        this.expireSeconds = Long.parseLong(string);
                        this.pid = bufferedReader.readLine();
                        this.info = bufferedReader.readLine();
                        break block8;
                    }
                    catch (IOException iOException) {
                        this.expireSeconds = 0L;
                        this.pid = null;
                        this.info = null;
                        throw iOException;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (fileReader == null) throw throwable;
                    fileReader.close();
                    throw throwable;
                }
            }
            fileReader.close();
            return;
        }
        Object var6_7 = null;
        if (fileReader == null) return;
        fileReader.close();
    }

    synchronized boolean lock(long l, String string) throws IOException {
        this.readLock();
        if (this.isLocked()) {
            return false;
        }
        File file = this.getResourceFile();
        file.createNewFile();
        PrintWriter printWriter = null;
        String string2 = Long.toString(l);
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            printWriter.println(string2);
            printWriter.println(LockManager.getPid());
            if (string == null) {
                string = this.getInfo(l);
            }
            printWriter.println(string);
            Object var9_6 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
        return true;
    }

    synchronized void unlock() throws IOException {
        this.readLock();
        if (this.isLocked()) {
            this.unlink();
        }
    }

    private String getInfo(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setMinimumIntegerDigits(2);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(calendar.get(1));
        stringBuffer2.append("-");
        stringBuffer2.append(numberFormat.format(calendar.get(2) + 1));
        stringBuffer2.append("-");
        stringBuffer2.append(numberFormat.format(calendar.get(5)));
        stringBuffer2.append(" ");
        stringBuffer2.append(numberFormat.format(calendar.get(11)));
        stringBuffer2.append(":");
        stringBuffer2.append(numberFormat.format(calendar.get(12)));
        stringBuffer2.append(":");
        stringBuffer2.append(numberFormat.format(calendar.get(13)));
        long l2 = (l - calendar.getTimeInMillis() / 1000L) / 60L;
        stringBuffer.append(this.application);
        stringBuffer.append("|");
        stringBuffer.append(this.resourceName);
        stringBuffer.append("|");
        stringBuffer.append(this.description);
        stringBuffer.append("|");
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append("|" + l2);
        stringBuffer.append("|");
        stringBuffer.append(this.ip_address);
        stringBuffer.append("|");
        stringBuffer.append(this.userName);
        return stringBuffer.toString();
    }

    private void unlink() {
        File file = this.getResourceFile();
        if (file.exists()) {
            this.expireSeconds = 0L;
            this.pid = null;
            this.info = null;
            file.delete();
        }
    }

    private File getResourceFile() {
        return new File("/tmp/MgmtLocks", this.resourceName + ".lock");
    }

    private long getCurrentSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    private class FRUFilter
    implements FilenameFilter {
        private String comp;

        FRUFilter(String string) {
            this.comp = string;
        }

        public boolean accept(File file, String string) {
            return string.startsWith(this.comp);
        }
    }
}

