/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.wwhelp4;

import com.webworks.wwhelp4.DirectionButton;
import com.webworks.wwhelp4.GeneralUtils;
import com.webworks.wwhelp4.ImageListBox;
import com.webworks.wwhelp4.OS;
import com.webworks.wwhelp4.PropertyChangeSupport;
import com.webworks.wwhelp4.VetoableChangeSupport;
import com.webworks.wwhelp4.WWHelp;
import com.webworks.wwhelp4.ZOrderUtils;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;

public class ComboBox
extends Panel
implements MouseListener,
KeyListener,
FocusListener,
ItemListener {
    boolean wasPressed = false;
    WWHelp wwhelp;
    protected String actionCommand;
    protected ArrowListener arrowListener = null;
    protected ActionListener actionListener = null;
    protected ComboTextField editBox;
    protected DirectionButton arrow;
    protected ImageListBox list;
    protected int maxNumChars = 0;
    protected transient boolean bOverList = false;
    protected transient boolean bOverArrow = false;
    protected transient boolean bDown = false;
    protected transient String sLastText;
    protected boolean bEditable;
    protected boolean bSearchable;
    protected boolean bCaseSensitive;
    protected int ix;
    protected int iy;
    protected int iwidth;
    protected int lheight;
    protected int arrowDim;
    protected int hPad = 1;
    protected int vPad = 0;
    protected boolean showHScroll = false;
    protected boolean showVScroll = true;
    protected static transient boolean bOsFlag = !OS.isWindows() && !OS.isMacintosh();
    protected String sSearchText;
    protected String sSearchItem;
    protected String sSearchOrig;
    protected int searchIndex;
    protected int searchLen;
    protected int searchI;
    private KeyBox keyBox = null;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ComboBox(WWHelp wWHelp) {
        this(false, false, wWHelp);
    }

    public ComboBox(boolean bl, boolean bl2, WWHelp wWHelp) {
        super.setLayout(null);
        this.wwhelp = wWHelp;
        this.editBox = new ComboTextField("");
        this.editBox.setEditable(false);
        ((Component)this.editBox).setBackground(Color.white);
        this.arrow = new DirectionButton(3);
        try {
            this.arrow.setShowFocus(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.arrow.setEnabled(false);
        this.list = new ImageListBox("ILB");
        this.list.hide();
        try {
            this.list.setComboMode(true);
            this.list.setShowHorizontalScroll(false);
            this.list.setShowVerticalScroll(true);
            this.list.setBackground(Color.white);
            this.list.setBorderType(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.add(this.list);
        this.add(this.editBox);
        this.add(this.arrow);
        this.lheight = 0;
        try {
            this.setEditable(bl);
            this.setSearchable(bl2);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.bCaseSensitive = true;
    }

    public void setEditable(boolean bl) throws PropertyVetoException {
        if (this.bEditable != bl) {
            Boolean bl2 = new Boolean(this.bEditable);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("editable", bl2, bl3);
            this.bEditable = bl;
            this.editBox.setEditable(this.bEditable || this.bSearchable);
            this.changes.firePropertyChange("editable", bl2, bl3);
        }
    }

    public boolean isEditable() {
        return this.bEditable;
    }

    public boolean getEditable() {
        return this.isEditable();
    }

    public void setSearchable(boolean bl) throws PropertyVetoException {
        if (this.bSearchable != bl) {
            Boolean bl2 = new Boolean(this.bSearchable);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("searchable", bl2, bl3);
            this.bSearchable = bl;
            this.editBox.setEditable(this.bEditable || this.bSearchable);
            this.changes.firePropertyChange("searchable", bl2, bl3);
        }
    }

    public boolean isSearchable() {
        return this.bSearchable;
    }

    public boolean getSearchable() {
        return this.isSearchable();
    }

    public void setCaseSensitive(boolean bl) throws PropertyVetoException {
        if (this.bCaseSensitive != bl) {
            Boolean bl2 = new Boolean(this.bCaseSensitive);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("caseSensitive", bl2, bl3);
            this.bCaseSensitive = bl;
            this.changes.firePropertyChange("caseSensitive", bl2, bl3);
        }
    }

    public boolean isCaseSensitive() {
        return this.bCaseSensitive;
    }

    public boolean getCaseSensitive() {
        return this.isCaseSensitive();
    }

    public void setShowHorizontalScroll(boolean bl) throws PropertyVetoException {
        if (this.showHScroll != bl) {
            Boolean bl2 = new Boolean(this.showHScroll);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("showHorizontalScroll", bl2, bl3);
            this.showHScroll = bl;
            this.list.setShowHorizontalScroll(bl);
            this.changes.firePropertyChange("showHorizontalScroll", bl2, bl3);
        }
    }

    public boolean isShowHorizontalScroll() {
        return this.showHScroll;
    }

    public boolean getShowHorizontalScroll() {
        return this.isShowHorizontalScroll();
    }

    public void setShowVerticalScroll(boolean bl) throws PropertyVetoException {
        if (this.showVScroll != bl) {
            Boolean bl2 = new Boolean(this.showVScroll);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("showVerticalScroll", bl2, bl3);
            this.showVScroll = bl;
            this.list.setShowVerticalScroll(bl);
            this.changes.firePropertyChange("showVerticalScroll", bl2, bl3);
        }
    }

    public boolean isShowVerticalScroll() {
        return this.showVScroll;
    }

    public boolean getShowVerticalScroll() {
        return this.isShowVerticalScroll();
    }

    public void setListItems(String[] stringArray) throws PropertyVetoException {
        String[] stringArray2 = this.getListItems();
        if (!GeneralUtils.objectsEqual(stringArray2, stringArray)) {
            this.vetos.fireVetoableChange("listItems", stringArray2, stringArray);
            this.list.clear();
            int n = 0;
            while (n < stringArray.length) {
                this.addItem(stringArray[n]);
                ++n;
            }
            this.updateMaxNumChars();
            this.changes.firePropertyChange("listItems", stringArray2, stringArray);
        }
    }

    public String[] getListItems() {
        int n = this.countItems();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.editBox.setFont(font);
        this.list.setFont(font);
        this.repaint();
    }

    public String getItem(int n) {
        return this.getListText(n);
    }

    public String getListText(int n) {
        return this.list.getText(n);
    }

    public void setText(String string) throws PropertyVetoException {
        String string2 = this.getText();
        if (!GeneralUtils.objectsEqual(string2, string)) {
            this.vetos.fireVetoableChange("text", string2, string);
            ((TextComponent)this.editBox).setText(string);
            this.changes.firePropertyChange("text", string2, string);
        }
    }

    public String getText() {
        this.verify();
        return this.editBox.getText();
    }

    public String getSelectedItem() {
        return this.list.getSelectedItem();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public synchronized boolean isSelected(int n) {
        return this.list.isSelected(n);
    }

    public static boolean addFirstTopDown() {
        return ComboBox.addLastBottomUp() ^ true;
    }

    public static boolean addLastBottomUp() {
        return ZOrderUtils.isFirstDrawnOverSecond();
    }

    public static boolean needsPlatformHelp() {
        return bOsFlag;
    }

    public void clear() {
        this.list.clear();
        ((TextComponent)this.editBox).setText("");
        this.updateMaxNumChars();
    }

    public synchronized void addItem(String string) throws PropertyVetoException {
        this.addItem(null, string, true);
    }

    public synchronized void addItem(String string, boolean bl) throws PropertyVetoException {
        this.addItem(null, string, bl);
    }

    public synchronized void addItem(Image image, String string) throws PropertyVetoException {
        this.addItem(image, string, true);
    }

    public synchronized void addItem(Image image, String string, boolean bl) throws PropertyVetoException {
        this.list.addItem(image, string, bl);
        this.arrow.setEnabled(true);
        this.updateMaxNumChars();
    }

    public int countItems() {
        return this.list.countItems();
    }

    public void setImage(int n, Image image) throws PropertyVetoException {
        this.list.setImage(n, image);
    }

    public void changeImage(int n, Image image) throws PropertyVetoException {
        this.setImage(n, image);
    }

    public void setListText(int n, String string) throws PropertyVetoException {
        this.list.setText(n, string);
        this.updateMaxNumChars();
    }

    public void changeText(int n, String string) throws PropertyVetoException {
        this.setListText(n, string);
    }

    public void setEnabled(int n) throws PropertyVetoException {
        this.setEnabled(n, true);
    }

    public void enable(int n) throws PropertyVetoException {
        this.setEnabled(n);
    }

    public void disable(int n) throws PropertyVetoException {
        this.setEnabled(n, false);
    }

    public void setEnabled(int n, boolean bl) throws PropertyVetoException {
        this.list.setEnabled(n, bl);
    }

    public void enable(int n, boolean bl) throws PropertyVetoException {
        this.setEnabled(n, bl);
    }

    public synchronized void delItem(int n) throws PropertyVetoException {
        this.list.delItem(n);
        if (this.list.countItems() == 0) {
            this.arrow.setEnabled(false);
            this.dropList(false);
        }
        this.updateMaxNumChars();
    }

    public synchronized void delItems(int n, int n2) throws PropertyVetoException {
        this.list.delItems(n, n2);
        if (this.list.countItems() == 0) {
            this.arrow.setEnabled(false);
            this.dropList(false);
        }
        this.updateMaxNumChars();
    }

    public synchronized void delSelectedItem() throws PropertyVetoException {
        this.list.delSelectedItems();
        this.updateMaxNumChars();
    }

    public synchronized void select(int n) throws PropertyVetoException {
        if (n >= 0 && n <= this.list.countItems()) {
            this.list.setSelectedIndex(n, true);
            ((TextComponent)this.editBox).setText(this.list.getSelectedItem());
            if (bOsFlag) {
                this.repaint();
            }
        }
    }

    public void select(String string) throws PropertyVetoException {
        this.list.setSelectedItem(string, true);
        ((TextComponent)this.editBox).setText(this.list.getSelectedItem());
        if (bOsFlag) {
            this.repaint();
        }
    }

    public synchronized void deselect(int n) throws PropertyVetoException {
        this.list.setSelectedIndex(n, false);
        ((TextComponent)this.editBox).setText("");
    }

    public void setListDown(boolean bl) throws PropertyVetoException {
        if (this.bDown != bl) {
            Boolean bl2 = new Boolean(this.bDown);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("listDown", bl2, bl3);
            this.bDown = bl;
            if (this.bDown) {
                this.list.show();
                this.vPad = 1;
            } else {
                this.list.hide();
                this.vPad = 0;
            }
            this.reshapeInternals();
            super.reshape(this.ix, this.iy, this.iwidth, this.lheight + this.arrowDim + this.vPad);
            this.invalidate();
            this.changes.firePropertyChange("listDown", bl2, bl3);
        }
    }

    public boolean isListDown() {
        return this.bDown;
    }

    public void dropList(boolean bl) throws PropertyVetoException {
        this.setListDown(bl);
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.ix = n;
        this.iy = n2;
        this.iwidth = n3;
        this.reshapeInternals();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.reshapeInternals();
    }

    public Dimension getPreferredSize() {
        this.reshapeInternals();
        int n = this.editBox.getPreferredSize((int)this.maxNumChars).width;
        if (this.bDown) {
            return new Dimension(n + this.arrowDim + this.hPad, this.arrowDim + this.vPad + this.lheight);
        }
        return new Dimension(n + this.arrowDim + this.hPad, this.arrowDim);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setActionCommand(String string) throws PropertyVetoException {
        String string2 = this.actionCommand;
        this.vetos.fireVetoableChange("actionCommand", string2, string);
        this.actionCommand = string;
        this.changes.firePropertyChange("actionCommand", string2, string);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.list.addMouseListener(this);
        this.editBox.addMouseListener(this);
        this.list.addKeyListener(this);
        this.list.addItemListener(this);
        this.list.addFocusListener(this);
        this.arrow.addFocusListener(this);
        this.editBox.addFocusListener(this);
        this.arrowListener = new ArrowListener();
        this.arrow.addMouseListener(this.arrowListener);
        this.keyBox = new KeyBox();
        this.editBox.addKeyListener(this.keyBox);
    }

    public synchronized void removeNotify() {
        this.list.removeMouseListener(this);
        this.editBox.removeMouseListener(this);
        this.list.removeItemListener(this);
        this.removeFocusListener(this);
        this.arrow.removeFocusListener(this);
        this.editBox.removeFocusListener(this);
        super.removeNotify();
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void validate() {
        super.validate();
        this.reshapeInternals();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.list) {
            this.bOverList = true;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.bOverList = false;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        this.wasPressed = object == this.editBox;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.editBox && this.wasPressed && !this.bEditable && !this.bSearchable) {
            try {
                this.setListDown(this.bDown ^ true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else if (object == this.list) {
            this.editBox.selectAll();
            this.editBox.requestFocus();
        }
        this.wasPressed = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (!(object instanceof DirectionButton) && actionEvent.getActionCommand().equals("ImageSelected")) {
            this.sourceActionEvent("ImageSelected");
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.sLastText = this.editBox.getText();
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 36: {
                try {
                    this.list.setSelectedIndex(0, true);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            case 35: {
                try {
                    this.list.setSelectedIndex(this.list.countItems() - 1, true);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            case 33: 
            case 38: {
                try {
                    this.list.setSelectedIndex(this.list.getSelectedIndex() - 1, true);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            case 34: 
            case 40: {
                try {
                    this.list.setSelectedIndex(this.list.getSelectedIndex() + 1, true);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
        }
        ((TextComponent)this.editBox).setText(this.list.getSelectedItem());
        this.editBox.selectAll();
        this.verify();
    }

    public void focusGained(FocusEvent focusEvent) {
        block3: {
            Object object = focusEvent.getSource();
            if (object instanceof ComboBox && !this.bDown) {
                this.editBox.selectAll();
                this.editBox.requestFocus();
            }
            if (!bOsFlag || object != this.editBox) break block3;
            try {
                this.setListDown(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        block2: {
            if (focusEvent.getSource() != this.arrow || this.bOverList || this.bOverArrow) break block2;
            try {
                this.setListDown(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ((TextComponent)this.editBox).setText(this.list.getSelectedItem());
        this.sourceActionEvent();
        try {
            this.setListDown(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    protected void sourceActionEvent(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    protected void sourceActionEvent() {
        this.sourceActionEvent(this.actionCommand);
    }

    protected void updateMaxNumChars() {
        this.maxNumChars = 0;
        String[] stringArray = this.getListItems();
        if (stringArray != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.maxNumChars = Math.max(stringArray[n2].length(), this.maxNumChars);
                ++n2;
            }
        }
    }

    protected void reshapeInternals() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.arrow.getPreferredSize();
        Dimension dimension3 = this.editBox.getPreferredSize();
        this.arrowDim = Math.max(dimension2.width, dimension2.height);
        if (dimension3.height > this.arrowDim) {
            this.arrowDim = dimension3.height;
        }
        this.editBox.reshape(0, 0, dimension.width - 1 - this.arrowDim - this.hPad, dimension3.height);
        this.arrow.setBounds(dimension.width - this.arrowDim, 0, this.arrowDim, this.arrowDim);
        this.arrow.shrinkTriangle(1, 1, 4, 3);
        if (this.bDown) {
            int n;
            int n2;
            this.lheight = this.getParent() != null ? ((n2 = this.getParent().bounds().height - this.iy - this.arrowDim - this.vPad) < (n = this.list.getMinimumSize().height) ? this.list.getMinimumSize((int)((n2 - this.list.getBorderWidth()) / this.list.getCellHeight())).height : n) : this.list.getMinimumSize().height;
            this.list.reshape(0, this.arrowDim + this.vPad, dimension.width, this.lheight);
        } else {
            this.lheight = 0;
        }
    }

    protected void verify() {
        if (this.bSearchable) {
            this.searchIndex = this.editBox.getSelectionStart();
            this.sSearchOrig = this.editBox.getText().substring(0, this.searchIndex);
            this.sSearchText = this.bCaseSensitive ? this.sSearchOrig : this.sSearchOrig.toUpperCase();
            this.searchLen = this.list.countItems();
            this.searchI = 0;
            int n = this.sSearchText.length();
            int n2 = 0;
            int n3 = 0;
            String string = "";
            if (n > 0) {
                while (this.searchI < this.searchLen) {
                    this.sSearchItem = this.bCaseSensitive ? this.list.getText(this.searchI) : this.list.getText(this.searchI).toUpperCase();
                    boolean bl = false;
                    for (n2 = 1; n2 <= n; ++n2) {
                        String string2 = this.sSearchText.substring(0, n2);
                        if (this.sSearchItem.startsWith(string2)) {
                            try {
                                this.list.setSelectedIndex(this.searchI, true);
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                            if (n3 < n2) {
                                n3 = n2;
                                string = this.sSearchItem;
                            }
                            bl = true;
                            continue;
                        }
                        bl = false;
                        ++this.searchI;
                        break;
                    }
                    if (bl) break;
                }
                if (!this.bEditable) {
                    ((TextComponent)this.editBox).setText(string);
                    if (this.searchI == this.searchLen) {
                        this.editBox.select(n3, n3);
                    } else {
                        this.editBox.select(this.searchIndex, this.searchIndex);
                    }
                    if (this.editBox.getSelectionStart() == 0) {
                        ((TextComponent)this.editBox).setText("");
                    }
                }
            }
        }
        this.sLastText = this.editBox.getText();
    }

    class ArrowListener
    implements MouseListener {
        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                ComboBox.this.setListDown(ComboBox.this.bDown ^ true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ComboBox.this.bOverArrow = true;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ComboBox.this.bOverArrow = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        ArrowListener() {
        }
    }

    class KeyBox
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent keyEvent) {
            ComboBox.this.sLastText = ComboBox.this.editBox.getText();
        }

        public void keyReleased(KeyEvent keyEvent) {
            ComboBox.this.verify();
        }

        KeyBox() {
        }
    }

    class ComboTextField
    extends TextField
    implements KeyListener,
    MouseMotionListener,
    MouseListener {
        ComboTextField(String string) {
            super(string);
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 13) {
                Boolean bl = ComboBox.this.wwhelp.bSearchInProgress;
                synchronized (bl) {
                    if (ComboBox.this.wwhelp.bSearchInProgress == Boolean.TRUE) {
                        Object var3_3 = null;
                        return;
                    }
                }
                if (this.getText().trim().length() == 0) {
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                ComboBox.this.wwhelp.SGoButton_ActionPerformed(null);
                super.setEditable(false);
                this.selectAll();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (ComboBox.this.wwhelp.bSearchInProgress == Boolean.TRUE) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(2));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (ComboBox.this.wwhelp.bSearchInProgress == Boolean.TRUE) {
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(2));
            }
        }

        public synchronized void addNotify() {
            super.addNotify();
            this.addKeyListener(this);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        public synchronized void removeNotify() {
            this.removeMouseMotionListener(this);
            this.removeMouseListener(this);
            super.removeNotify();
        }
    }
}

