/*
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 */
package samples.jndi.externalResource;


import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

import java.util.*;

import org.apache.naming.resources.FileDirContext;


/**
 * TestContextFactory: use Catalina's FileDirContext
 */
public class MyExternalConnectionFactory implements InitialContextFactory {

    /** Creates a new instance of MyConnectionFactory */
    public MyExternalConnectionFactory() {}

    public Context getInitialContext(Hashtable environment)
            throws NamingException {

        FileDirContext dir = new FileDirContext(environment);

        dir.setDocBase((String) environment.get("basedir"));

        return(Context) dir;
    }
}
