/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class FileDirContext
extends BaseDirContext {
    protected static final int BUFFER_SIZE = 2048;
    protected File base = null;
    protected String absoluteBase = null;
    protected boolean caseSensitive = true;

    public FileDirContext() {
    }

    public FileDirContext(Hashtable hashtable) {
        super(hashtable);
    }

    public void setDocBase(String string) {
        if (string == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        this.base = new File(string);
        try {
            this.base = this.base.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(this.base.exists() && this.base.isDirectory() && this.base.canRead())) {
            throw new IllegalArgumentException(this.sm.getString("fileResources.base", string));
        }
        this.absoluteBase = this.normalize(this.base.getAbsolutePath());
        super.setDocBase(string);
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void release() {
        this.caseSensitive = true;
        this.absoluteBase = null;
        this.base = null;
        super.release();
    }

    public Object lookup(String string) throws NamingException {
        Object object = null;
        File file = this.file(string);
        if (file == null) {
            throw new NamingException(resourceNotFoundMsg + string);
        }
        if (file.isDirectory()) {
            FileDirContext fileDirContext = new FileDirContext(this.env);
            fileDirContext.setDocBase(file.getPath());
            object = fileDirContext;
        } else {
            object = new FileResource(file);
        }
        return object;
    }

    public void unbind(String string) throws NamingException {
        File file = this.file(string);
        if (file == null) {
            throw new NamingException(resourceNotFoundMsg + string);
        }
        if (!file.delete()) {
            throw new NamingException(this.sm.getString("resources.unbindFailed", string));
        }
    }

    public void rename(String string, String string2) throws NamingException {
        File file = this.file(string);
        if (file == null) {
            throw new NamingException(resourceNotFoundMsg + string);
        }
        File file2 = new File(this.base, string2);
        file.renameTo(file2);
    }

    public NamingEnumeration list(String string) throws NamingException {
        File file = this.file(string);
        if (file == null) {
            throw new NamingException(resourceNotFoundMsg + string);
        }
        Vector vector = this.list(file);
        return new NamingContextEnumeration(vector);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        File file = this.file(string);
        if (file == null) {
            throw new NamingException(resourceNotFoundMsg + string);
        }
        Vector vector = this.list(file);
        return new NamingContextBindingsEnumeration(vector);
    }

    public void destroySubcontext(String string) throws NamingException {
        this.unbind(string);
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        File file = this.file(string);
        if (file == null) {
            throw new NamingException(resourceNotFoundMsg + string);
        }
        return new FileResourceAttributes(file);
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
    }

    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        File file = new File(this.base, string);
        if (file.exists()) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", string));
        }
        this.rebind(string, object, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        File file = new File(this.base, string);
        InputStream inputStream = null;
        if (object instanceof Resource) {
            try {
                inputStream = ((Resource)object).streamContent();
            }
            catch (IOException iOException) {}
        } else if (object instanceof InputStream) {
            inputStream = (InputStream)object;
        } else if (object instanceof DirContext) {
            if (file.exists() && !file.delete()) {
                throw new NamingException(this.sm.getString("resources.bindFailed", string));
            }
            if (!file.mkdir()) {
                throw new NamingException(this.sm.getString("resources.bindFailed", string));
            }
        }
        if (inputStream == null) {
            throw new NamingException(this.sm.getString("resources.bindFailed", string));
        }
        try {
            block16: {
                FileOutputStream fileOutputStream = null;
                byte[] byArray = new byte[2048];
                int n = -1;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    Object var10_11 = null;
                    if (fileOutputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    inputStream.close();
                    throw throwable;
                }
                fileOutputStream.close();
            }
            inputStream.close();
            {
            }
        }
        catch (IOException iOException) {
            throw new NamingException(this.sm.getString("resources.bindFailed", iOException));
        }
    }

    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        File file = new File(this.base, string);
        if (file.exists()) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", string));
        }
        if (!file.mkdir()) {
            throw new NamingException(this.sm.getString("resources.bindFailed", string));
        }
        return (DirContext)this.lookup(string);
    }

    public DirContext getSchema(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String string, Attributes attributes) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String string, String string2, SearchControls searchControls) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return null;
    }

    protected String normalize(String string) {
        int n;
        String string2 = string;
        if (string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        return string2;
    }

    protected File file(String string) {
        File file;
        if (File.separatorChar == '\\') {
            string = string.replace('/', File.separatorChar);
        }
        if ((file = new File(this.base, string)).exists() && file.canRead()) {
            if (this.caseSensitive && File.separatorChar == '\\') {
                String string2 = file.getAbsolutePath();
                if (string2.endsWith(".")) {
                    string2 = string2 + "/";
                }
                String string3 = this.normalize(string2);
                String string4 = null;
                try {
                    string4 = file.getCanonicalPath();
                    if (string4 != null) {
                        string4 = this.normalize(string4);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.absoluteBase.length() < string3.length() && this.absoluteBase.length() < string4.length()) {
                    string3 = string3.substring(this.absoluteBase.length());
                    if (string4 == null || string3 == null) {
                        return null;
                    }
                    if (string3.equals("")) {
                        string3 = "/";
                    }
                    if ((string4 = string4.substring(this.absoluteBase.length())).equals("")) {
                        string4 = "/";
                    }
                    if (!string4.equals(string3)) {
                        return null;
                    }
                }
            }
        } else {
            return null;
        }
        return file;
    }

    protected Vector list(File file) {
        Vector<NamingEntry> vector = new Vector<NamingEntry>();
        if (!file.isDirectory()) {
            return vector;
        }
        Object[] objectArray = file.list();
        Arrays.sort(objectArray);
        if (objectArray == null) {
            return vector;
        }
        NamingEntry namingEntry = null;
        for (int i = 0; i < objectArray.length; ++i) {
            File file2 = new File(file, (String)objectArray[i]);
            Object object = null;
            if (file2.isDirectory()) {
                FileDirContext fileDirContext = new FileDirContext(this.env);
                fileDirContext.setDocBase(file.getPath());
                object = fileDirContext;
            } else {
                object = new FileResource(file2);
            }
            namingEntry = new NamingEntry((String)objectArray[i], object, 0);
            vector.addElement(namingEntry);
        }
        return vector;
    }

    protected class FileResourceAttributes
    extends ResourceAttributes {
        protected File file;
        protected boolean accessed = false;

        public FileResourceAttributes(File file) {
            this.file = file;
        }

        public boolean isCollection() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.isCollection();
        }

        public long getContentLength() {
            if (this.contentLength != -1L) {
                return this.contentLength;
            }
            this.contentLength = this.file.length();
            return this.contentLength;
        }

        public long getCreation() {
            if (this.creation != -1L) {
                return this.creation;
            }
            this.creation = this.file.lastModified();
            return this.creation;
        }

        public Date getCreationDate() {
            if (this.creation == -1L) {
                this.creation = this.file.lastModified();
            }
            return super.getCreationDate();
        }

        public long getLastModified() {
            if (this.lastModified != -1L) {
                return this.lastModified;
            }
            this.lastModified = this.file.lastModified();
            return this.lastModified;
        }

        public Date getLastModifiedDate() {
            if (this.lastModified == -1L) {
                this.lastModified = this.file.lastModified();
            }
            return super.getLastModifiedDate();
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.file.getName();
            }
            return this.name;
        }

        public String getResourceType() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.getResourceType();
        }
    }

    protected class FileResource
    extends Resource {
        protected File file;
        protected long length = -1L;

        public FileResource(File file) {
            this.file = file;
        }

        public InputStream streamContent() throws IOException {
            if (this.binaryContent == null) {
                this.inputStream = new FileInputStream(this.file);
            }
            return super.streamContent();
        }
    }
}

