/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.runtime.BodyContentImpl;
import org.apache.jasper.runtime.JspException;
import org.apache.jasper.runtime.JspRuntimeLibrary;
import org.apache.jasper.runtime.JspWriterImpl;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;

public class PageContextImpl
extends PageContext {
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "PageContextImpl");
    protected Servlet servlet;
    protected ServletConfig config;
    protected ServletContext context;
    protected JspFactory factory;
    protected boolean needsSession;
    protected String errorPageURL;
    protected boolean autoFlush;
    protected int bufferSize;
    protected transient Hashtable attributes = new Hashtable(16);
    protected transient ServletRequest request;
    protected transient ServletResponse response;
    protected transient Object page;
    protected transient HttpSession session;
    protected boolean isIncluded;
    protected JspWriter[] outs = new JspWriter[5];
    protected int depth = -1;
    protected transient JspWriter out;

    PageContextImpl(JspFactory jspFactory) {
        this.factory = jspFactory;
    }

    public void initialize(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) throws IOException, IllegalStateException, IllegalArgumentException {
        this._initialize(servlet, servletRequest, servletResponse, string, bl, n, bl2);
    }

    void _initialize(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) throws IOException, IllegalStateException, IllegalArgumentException {
        this.servlet = servlet;
        this.config = servlet.getServletConfig();
        this.context = this.config.getServletContext();
        this.needsSession = bl;
        this.errorPageURL = string;
        this.bufferSize = n;
        this.autoFlush = bl2;
        this.request = servletRequest;
        this.response = servletResponse;
        if (servletRequest instanceof HttpServletRequest && bl) {
            this.session = ((HttpServletRequest)servletRequest).getSession();
        }
        if (bl && this.session == null) {
            throw new IllegalStateException("Page needs a session and none is available");
        }
        if (this.out == null) {
            this.out = this._createOut(n, bl2);
        } else {
            ((JspWriterImpl)this.out).init(servletResponse, n, bl2);
        }
        if (this.out == null) {
            throw new IllegalStateException("failed initialize JspWriter");
        }
        this.depth = 0;
        this.outs[0] = this.out;
        this.setAttribute("javax.servlet.jsp.jspOut", this.out);
        this.setAttribute("javax.servlet.jsp.jspRequest", servletRequest);
        this.setAttribute("javax.servlet.jsp.jspResponse", servletResponse);
        if (this.session != null) {
            this.setAttribute("javax.servlet.jsp.jspSession", this.session);
        }
        this.setAttribute("javax.servlet.jsp.jspPage", servlet);
        this.setAttribute("javax.servlet.jsp.jspConfig", this.config);
        this.setAttribute("javax.servlet.jsp.jspPageContext", (Object)this);
        this.setAttribute("javax.servlet.jsp.jspApplication", this.context);
        this.isIncluded = servletRequest.getAttribute("javax.servlet.include.servlet_path") != null;
    }

    public void release() {
        try {
            if (this.out instanceof JspWriterImpl) {
                ((JspWriterImpl)this.out).flushBuffer();
            }
        }
        catch (IOException iOException) {
            this.loghelper.log("Internal error flushing the buffer in release()", 1);
        }
        this.servlet = null;
        this.config = null;
        this.context = null;
        this.needsSession = false;
        this.errorPageURL = null;
        this.bufferSize = -1;
        this.autoFlush = true;
        this.request = null;
        this.response = null;
        this.out = null;
        this.session = null;
        this.depth = -1;
        for (int i = 0; i < this.outs.length; ++i) {
            this.outs[i] = null;
        }
        this.attributes.clear();
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Object getAttribute(String string, int n) {
        switch (n) {
            case 1: {
                return this.attributes.get(string);
            }
            case 2: {
                return this.request.getAttribute(string);
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
                }
                return this.session.getAttribute(string);
            }
            case 4: {
                return this.context.getAttribute(string);
            }
        }
        throw new IllegalArgumentException("unidentified scope");
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public void setAttribute(String string, Object object, int n) {
        switch (n) {
            case 1: {
                this.attributes.put(string, object);
                break;
            }
            case 2: {
                this.request.setAttribute(string, object);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
                }
                this.session.setAttribute(string, object);
                break;
            }
            case 4: {
                this.context.setAttribute(string, object);
                break;
            }
        }
    }

    public void removeAttribute(String string, int n) {
        switch (n) {
            case 1: {
                this.attributes.remove(string);
                break;
            }
            case 2: {
                this.request.removeAttribute(string);
                break;
            }
            case 3: {
                if (this.session == null) {
                    throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
                }
                this.session.removeAttribute(string);
                break;
            }
            case 4: {
                this.context.removeAttribute(string);
                break;
            }
        }
    }

    public int getAttributesScope(String string) {
        if (this.attributes.get(string) != null) {
            return 1;
        }
        if (this.request.getAttribute(string) != null) {
            return 2;
        }
        if (this.session != null && this.session.getAttribute(string) != null) {
            return 3;
        }
        if (this.context.getAttribute(string) != null) {
            return 4;
        }
        return 0;
    }

    public Object findAttribute(String string) {
        Object object = this.attributes.get(string);
        if (object != null) {
            return object;
        }
        object = this.request.getAttribute(string);
        if (object != null) {
            return object;
        }
        if (this.session != null && (object = this.session.getAttribute(string)) != null) {
            return object;
        }
        return this.context.getAttribute(string);
    }

    public Enumeration getAttributeNamesInScope(int n) {
        switch (n) {
            case 1: {
                return this.attributes.keys();
            }
            case 2: {
                return this.request.getAttributeNames();
            }
            case 3: {
                if (this.session != null) {
                    return this.session.getAttributeNames();
                }
                throw new IllegalArgumentException("can't access SESSION_SCOPE without an HttpSession");
            }
            case 4: {
                return this.context.getAttributeNames();
            }
        }
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                throw new NoSuchElementException();
            }
        };
    }

    public void removeAttribute(String string) {
        try {
            this.removeAttribute(string, 1);
            this.removeAttribute(string, 2);
            this.removeAttribute(string, 3);
            this.removeAttribute(string, 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JspWriter getOut() {
        return this.out;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public Exception getException() {
        return (Exception)this.request.getAttribute("javax.servlet.jsp.jspException");
    }

    public Object getPage() {
        return this.servlet;
    }

    private final String getAbsolutePathRelativeToContext(String string) {
        String string2 = string;
        if (!string2.startsWith("/")) {
            String string3 = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
            if (string3 == null) {
                string3 = ((HttpServletRequest)this.request).getServletPath();
            }
            String string4 = string3.substring(0, string3.lastIndexOf(47));
            string2 = string4 + '/' + string2;
        }
        return string2;
    }

    public void include(String string) throws ServletException, IOException {
        JspRuntimeLibrary.include((HttpServletRequest)this.request, (HttpServletResponse)this.response, string, this.out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void forward(String string) throws ServletException, IOException {
        block5: {
            while (this.response instanceof ServletResponseWrapperInclude) {
                this.response = ((ServletResponseWrapperInclude)this.response).getResponse();
            }
            String string2 = this.getAbsolutePathRelativeToContext(string);
            String string3 = (String)this.request.getAttribute("javax.servlet.include.servlet_path");
            if (string3 != null) {
                this.request.removeAttribute("javax.servlet.include.servlet_path");
            }
            try {
                this.context.getRequestDispatcher(string2).forward(this.request, this.response);
                Object var5_4 = null;
                if (string3 == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (string3 != null) {
                    this.request.setAttribute("javax.servlet.include.servlet_path", (Object)string3);
                }
                this.request.setAttribute("javax.servlet.forward.seen", (Object)"true");
                throw throwable;
            }
            this.request.setAttribute("javax.servlet.include.servlet_path", (Object)string3);
        }
        this.request.setAttribute("javax.servlet.forward.seen", (Object)"true");
    }

    public BodyContent pushBody() {
        ++this.depth;
        if (this.depth >= this.outs.length) {
            JspWriter[] jspWriterArray = new JspWriter[this.depth + 1];
            for (int i = 0; i < this.outs.length; ++i) {
                jspWriterArray[i] = this.outs[i];
            }
            this.outs = jspWriterArray;
        }
        if (this.outs[this.depth] == null) {
            this.outs[this.depth] = new BodyContentImpl(this.out);
        } else {
            try {
                this.outs[this.depth].clear();
            }
            catch (IOException iOException) {
                this.outs[this.depth] = new BodyContentImpl(this.out);
            }
        }
        this.out = this.outs[this.depth];
        return (BodyContent)this.out;
    }

    public JspWriter popBody() {
        --this.depth;
        this.out = this.outs[this.depth];
        return this.out;
    }

    public void handlePageException(Exception exception) throws IOException, ServletException {
        this.handlePageException((Throwable)exception);
    }

    public void handlePageException(Throwable throwable) throws IOException, ServletException {
        this.request.setAttribute("javax.servlet.jsp.jspException", (Object)throwable);
        if (this.errorPageURL != null && !this.errorPageURL.equals("")) {
            try {
                this.forward(this.errorPageURL);
            }
            catch (IllegalStateException illegalStateException) {
                this.include(this.errorPageURL);
            }
        } else {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof JspException) {
                Throwable throwable2 = ((JspException)((Object)throwable)).getRootCause();
                if (throwable2 != null) {
                    throw new ServletException(throwable.getMessage(), throwable2);
                }
                throw new ServletException(throwable);
            }
            throw new ServletException(throwable);
        }
    }

    protected JspWriter _createOut(int n, boolean bl) throws IOException, IllegalArgumentException {
        try {
            return new JspWriterImpl(this.response, n, bl);
        }
        catch (Throwable throwable) {
            this.loghelper.log("creating out", throwable);
            return null;
        }
    }
}

