/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.parser.MyEntityResolver;
import org.apache.jasper.parser.MyErrorHandler;
import org.apache.jasper.parser.TreeNode;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserUtils {
    protected ClassLoader classLoader = null;
    protected ErrorHandler errorHandler = new MyErrorHandler();
    protected EntityResolver entityResolver = new MyEntityResolver();
    private static HashMap classLoaders = new HashMap();

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public TreeNode parseXMLDocument(String string, InputStream inputStream) throws JasperException {
        Document document = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Thread.currentThread().setContextClassLoader(classLoader);
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(this.entityResolver);
            documentBuilder.setErrorHandler(this.errorHandler);
            document = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{string, parserConfigurationException.getMessage()}));
        }
        catch (SAXParseException sAXParseException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml.line", new Object[]{string, new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.getMessage()}));
        }
        catch (SAXException sAXException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{string, sAXException.getMessage()}));
        }
        catch (IOException iOException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{string, iOException.toString()}));
        }
        return this.convert(null, document.getDocumentElement());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected TreeNode convert(TreeNode treeNode, Node node) {
        NodeList nodeList;
        int n;
        TreeNode treeNode2 = new TreeNode(node.getNodeName(), treeNode);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = namedNodeMap.item(n);
                treeNode2.addAttribute(node2.getNodeName(), node2.getNodeValue());
            }
        }
        if ((nodeList = node.getChildNodes()) != null) {
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Node node3 = nodeList.item(i);
                if (node3 instanceof Comment) continue;
                if (node3 instanceof Text) {
                    object = ((Text)node3).getData();
                    if (object == null || ((String)(object = ((String)object).trim())).length() <= 0) continue;
                    treeNode2.setBody((String)object);
                    continue;
                }
                object = this.convert(treeNode2, node3);
            }
        }
        return treeNode2;
    }

    private ParserUtils() {
    }

    public static synchronized ParserUtils createParserUtils(ClassLoader classLoader) {
        ParserUtils parserUtils = null;
        parserUtils = new ParserUtils();
        parserUtils.setClassLoader(classLoader);
        return parserUtils;
    }

    public static synchronized ClassLoader createClassLoader(ClassLoader classLoader) throws MalformedURLException {
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoaders.get(classLoader);
        if (uRLClassLoader != null) {
            return uRLClassLoader;
        }
        URL[] uRLArray = new URL[]{new URL("file:///classes/jaxp.jar"), new URL("file:///classes/crimson.jar")};
        uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
        classLoaders.put(classLoader, uRLClassLoader);
        System.out.println("PUF:  createClassLoader:\r\n" + uRLClassLoader);
        uRLArray = uRLClassLoader.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            System.out.println("PUF:    url=" + uRLArray[i]);
        }
        return uRLClassLoader;
    }
}

