/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import com.sun.appserv.server.util.PreprocessorUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.loader.Extension;
import org.apache.catalina.loader.Reloader;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class WebappClassLoader
extends URLClassLoader
implements Reloader,
Lifecycle {
    private static final String[] triggers = new String[]{"javax.servlet.Servlet"};
    private static final String[] packageTriggers = new String[]{"javax.naming", "javax.naming.directory", "javax.xml.parsers", "org.xml.sax", "org.xml.sax.ext", "org.xml.sax.helpers", "org.w3c.dom"};
    protected DirContext resources = null;
    protected ArrayList available = new ArrayList();
    protected HashMap resourceEntries = new HashMap();
    protected HashMap notFoundResources = new HashMap();
    protected int debug = 0;
    protected boolean delegate = false;
    protected String[] repositories = new String[0];
    protected File[] files = new File[0];
    protected JarFile[] jarFiles = new JarFile[0];
    protected File[] jarRealFiles = new File[0];
    protected String jarPath = null;
    protected String[] jarNames = new String[0];
    protected long[] lastModifiedDates = new long[0];
    protected String[] paths = new String[0];
    protected ArrayList required = new ArrayList();
    private ArrayList permissionList = new ArrayList();
    private HashMap loaderPC = new HashMap();
    private SecurityManager securityManager = null;
    private ClassLoader parent = null;
    private ClassLoader system = null;
    private ClassLoader boot = null;
    protected boolean started = false;
    protected boolean hasExternalRepositories = false;
    private Permission allPermission = new AllPermission();

    public WebappClassLoader(DirContext dirContext) {
        super(new URL[0]);
        this.resources = dirContext;
        this.parent = this.getParent();
        this.system = WebappClassLoader.getSystemClassLoader();
        this.boot = this.system.getParent();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public WebappClassLoader(ClassLoader classLoader, DirContext dirContext) {
        super(new URL[0], classLoader);
        this.resources = dirContext;
        this.parent = this.getParent();
        this.system = WebappClassLoader.getSystemClassLoader();
        this.boot = this.system.getParent();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean bl) {
        this.delegate = bl;
    }

    public void addPermission(String string) {
        if (this.securityManager != null) {
            Permission permission = null;
            permission = string.startsWith("jndi:") || string.startsWith("jar:jndi:") ? new JndiPermission(string + "*") : new FilePermission(string + "-", "read");
            this.addPermission(permission);
        }
    }

    public void addPermission(URL uRL) {
        this.addPermission(uRL.toString());
    }

    public void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String string) {
        this.jarPath = string;
    }

    public void addRepository(String string) {
        if (string.startsWith("/WEB-INF/lib") || string.startsWith("/WEB-INF/classes")) {
            return;
        }
        try {
            URL uRL = new URL(string);
            super.addURL(uRL);
            this.hasExternalRepositories = true;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.toString());
        }
    }

    synchronized void addRepository(String string, File file) {
        int n;
        if (string == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log("addRepository(" + string + ")");
        }
        String[] stringArray = new String[this.repositories.length + 1];
        for (n = 0; n < this.repositories.length; ++n) {
            stringArray[n] = this.repositories[n];
        }
        stringArray[this.repositories.length] = string;
        this.repositories = stringArray;
        File[] fileArray = new File[this.files.length + 1];
        for (n = 0; n < this.files.length; ++n) {
            fileArray[n] = this.files[n];
        }
        fileArray[this.files.length] = file;
        this.files = fileArray;
    }

    synchronized void addJar(String string, JarFile jarFile, File file) throws IOException {
        Object object;
        Object object2;
        int n;
        Object[] objectArray;
        if (string == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log("addJar(" + string + ")");
        }
        if (this.jarPath != null && string.startsWith(this.jarPath)) {
            String string2 = string.substring(this.jarPath.length());
            while (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            objectArray = new String[this.jarNames.length + 1];
            for (n = 0; n < this.jarNames.length; ++n) {
                objectArray[n] = this.jarNames[n];
            }
            objectArray[this.jarNames.length] = string2;
            this.jarNames = objectArray;
        }
        try {
            long l = ((ResourceAttributes)this.resources.getAttributes(string)).getLastModified();
            object2 = new String[this.paths.length + 1];
            for (n = 0; n < this.paths.length; ++n) {
                object2[n] = this.paths[n];
            }
            object2[this.paths.length] = string;
            this.paths = object2;
            object = new long[this.lastModifiedDates.length + 1];
            for (n = 0; n < this.lastModifiedDates.length; ++n) {
                object[n] = this.lastModifiedDates[n];
            }
            object[this.lastModifiedDates.length] = l;
            this.lastModifiedDates = object;
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (!this.validateJarFile(file)) {
            return;
        }
        JarFile[] jarFileArray = new JarFile[this.jarFiles.length + 1];
        for (n = 0; n < this.jarFiles.length; ++n) {
            jarFileArray[n] = this.jarFiles[n];
        }
        jarFileArray[this.jarFiles.length] = jarFile;
        this.jarFiles = jarFileArray;
        objectArray = new File[this.jarRealFiles.length + 1];
        for (n = 0; n < this.jarRealFiles.length; ++n) {
            objectArray[n] = this.jarRealFiles[n];
        }
        objectArray[this.jarRealFiles.length] = file;
        this.jarRealFiles = objectArray;
        object2 = jarFile.getManifest();
        if (object2 != null) {
            object = Extension.getAvailable((Manifest)object2).iterator();
            while (object.hasNext()) {
                this.available.add(object.next());
            }
            object = Extension.getRequired((Manifest)object2).iterator();
            while (object.hasNext()) {
                this.required.add(object.next());
            }
        }
    }

    public Extension[] findAvailable() {
        Extension[] extensionArray;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.available.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        ClassLoader classLoader = this;
        while ((classLoader = classLoader.getParent()) != null) {
            if (!(classLoader instanceof WebappClassLoader)) continue;
            extensionArray = ((WebappClassLoader)classLoader).findAvailable();
            for (int i = 0; i < extensionArray.length; ++i) {
                arrayList.add(extensionArray[i]);
            }
        }
        extensionArray = new Extension[arrayList.size()];
        return arrayList.toArray(extensionArray);
    }

    public String[] findRepositories() {
        return this.repositories;
    }

    public Extension[] findRequired() {
        Extension[] extensionArray;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.required.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        ClassLoader classLoader = this;
        while ((classLoader = classLoader.getParent()) != null) {
            if (!(classLoader instanceof WebappClassLoader)) continue;
            extensionArray = ((WebappClassLoader)classLoader).findRequired();
            for (int i = 0; i < extensionArray.length; ++i) {
                arrayList.add(extensionArray[i]);
            }
        }
        extensionArray = new Extension[arrayList.size()];
        return arrayList.toArray(extensionArray);
    }

    public boolean modified() {
        int n;
        int n2;
        if (this.debug >= 2) {
            this.log("modified()");
        }
        if ((n2 = this.paths.length) > (n = this.lastModifiedDates.length)) {
            n2 = n;
        }
        for (int i = 0; i < n2; ++i) {
            try {
                long l = ((ResourceAttributes)this.resources.getAttributes(this.paths[i])).getLastModified();
                if (l == this.lastModifiedDates[i]) continue;
                this.log("  Resource '" + this.paths[i] + "' was modified; Date is now: " + new Date(l) + " Was: " + new Date(this.lastModifiedDates[i]));
                return true;
            }
            catch (NamingException namingException) {
                this.log("    Resource '" + this.paths[i] + "' is missing", 1);
                return true;
            }
        }
        n2 = this.jarNames.length;
        if (this.getJarPath() != null) {
            try {
                String string;
                NameClassPair nameClassPair;
                NamingEnumeration<Binding> namingEnumeration = this.resources.listBindings(this.getJarPath());
                int n3 = 0;
                while (namingEnumeration.hasMoreElements() && n3 < n2) {
                    nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                    string = nameClassPair.getName();
                    if (!string.endsWith(".jar") && !string.endsWith(".zip")) continue;
                    if (!string.equals(this.jarNames[n3])) {
                        this.log("    Additional JARs have been added : '" + string + "'");
                        return true;
                    }
                    ++n3;
                }
                if (namingEnumeration.hasMoreElements()) {
                    while (namingEnumeration.hasMoreElements()) {
                        nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                        string = nameClassPair.getName();
                        if (!string.endsWith(".jar") && !string.endsWith(".zip")) continue;
                        this.log("    Additional JARs and ZIPs have been added");
                        return true;
                    }
                } else if (n3 < this.jarNames.length) {
                    this.log("    Additional JARs have been added");
                    return true;
                }
            }
            catch (NamingException namingException) {
                if (this.debug > 2) {
                    this.log("    Failed tracking modifications of '" + this.getJarPath() + "'");
                }
            }
            catch (ClassCastException classCastException) {
                this.log("    Failed tracking modifications of '" + this.getJarPath() + "' : " + classCastException.getMessage(), 1);
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("WebappClassLoader\r\n");
        stringBuffer.append("  available:\r\n");
        Iterator iterator = this.available.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("    ");
            stringBuffer.append(iterator.next().toString());
            stringBuffer.append("\r\n");
        }
        stringBuffer.append("  delegate: ");
        stringBuffer.append(this.delegate);
        stringBuffer.append("\r\n");
        stringBuffer.append("  repositories:\r\n");
        for (int i = 0; i < this.repositories.length; ++i) {
            stringBuffer.append("    ");
            stringBuffer.append(this.repositories[i]);
            stringBuffer.append("\r\n");
        }
        stringBuffer.append("  required:\r\n");
        Iterator iterator2 = this.required.iterator();
        while (iterator2.hasNext()) {
            stringBuffer.append("    ");
            stringBuffer.append(iterator2.next().toString());
            stringBuffer.append("\r\n");
        }
        if (this.getParent() != null) {
            stringBuffer.append("----------> Parent Classloader:\r\n");
            stringBuffer.append(this.getParent().toString());
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public Class findClass(String string) throws ClassNotFoundException {
        int n;
        if (this.debug >= 3) {
            this.log("    findClass(" + string + ")");
        }
        if (this.securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            try {
                if (this.debug >= 4) {
                    this.log("      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(string.substring(0, n));
            }
            catch (Exception exception) {
                if (this.debug >= 4) {
                    this.log("      -->Exception-->ClassNotFoundException", exception);
                }
                throw new ClassNotFoundException(string);
            }
        }
        Class<?> clazz = null;
        try {
            if (this.debug >= 4) {
                this.log("      findClassInternal(" + string + ")");
            }
            try {
                clazz = this.findClassInternal(string);
            }
            catch (AccessControlException accessControlException) {
                accessControlException.printStackTrace();
                throw new ClassNotFoundException(string);
            }
            catch (RuntimeException runtimeException) {
                if (this.debug >= 4) {
                    this.log("      -->RuntimeException Rethrown", runtimeException);
                }
                throw runtimeException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null && this.hasExternalRepositories) {
                try {
                    clazz = super.findClass(string);
                }
                catch (AccessControlException accessControlException) {
                    throw new ClassNotFoundException(string);
                }
                catch (RuntimeException runtimeException) {
                    if (this.debug >= 4) {
                        this.log("      -->RuntimeException Rethrown", runtimeException);
                    }
                    throw runtimeException;
                }
            }
            if (clazz == null) {
                if (this.debug >= 3) {
                    this.log("    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.debug >= 3) {
                this.log("    --> Passing on ClassNotFoundException", classNotFoundException);
            }
            throw classNotFoundException;
        }
        if (this.debug >= 4) {
            this.log("      Returning class " + clazz);
        }
        if (this.debug >= 4 && clazz != null) {
            this.log("      Loaded by " + clazz.getClassLoader());
        }
        return clazz;
    }

    public URL findResource(String string) {
        if (this.debug >= 3) {
            this.log("    findResource(" + string + ")");
        }
        URL uRL = null;
        ResourceEntry resourceEntry = (ResourceEntry)this.resourceEntries.get(string);
        if (resourceEntry == null) {
            if (this.securityManager != null) {
                PrivilegedFindResource privilegedFindResource = new PrivilegedFindResource(string, string);
                resourceEntry = (ResourceEntry)AccessController.doPrivileged(privilegedFindResource);
            } else {
                resourceEntry = this.findResourceInternal(string, string);
            }
        }
        if (resourceEntry != null) {
            uRL = resourceEntry.source;
        }
        if (uRL == null && this.hasExternalRepositories) {
            uRL = super.findResource(string);
        }
        if (this.debug >= 3) {
            if (uRL != null) {
                this.log("    --> Returning '" + uRL.toString() + "'");
            } else {
                this.log("    --> Resource not found, returning null");
            }
        }
        return uRL;
    }

    public Enumeration findResources(String string) throws IOException {
        Object object;
        int n;
        if (this.debug >= 3) {
            this.log("    findResources(" + string + ")");
        }
        Vector<URL> vector = new Vector<URL>();
        int n2 = this.jarFiles.length;
        int n3 = this.repositories.length;
        for (n = 0; n < n3; ++n) {
            try {
                object = this.repositories[n] + string;
                this.resources.lookup((String)object);
                try {
                    vector.addElement(this.getURL(new File(this.files[n], string)));
                }
                catch (MalformedURLException malformedURLException) {}
                continue;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        for (n = 0; n < n2; ++n) {
            object = this.jarFiles[n].getJarEntry(string);
            if (object == null) continue;
            try {
                String string2 = this.getURL(this.jarRealFiles[n]).toString();
                string2 = "jar:" + string2 + "!/" + string;
                vector.addElement(new URL(string2));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (this.hasExternalRepositories) {
            object = super.findResources(string);
            while (object.hasMoreElements()) {
                vector.addElement((URL)object.nextElement());
            }
        }
        return vector.elements();
    }

    public URL getResource(String string) {
        ClassLoader classLoader;
        if (this.debug >= 2) {
            this.log("getResource(" + string + ")");
        }
        URL uRL = null;
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((classLoader = this.parent) == null) {
                classLoader = this.system;
            }
            if ((uRL = classLoader.getResource(string)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + uRL.toString() + "'");
                }
                return uRL;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((uRL = this.findResource(string)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning '" + uRL.toString() + "'");
            }
            return uRL;
        }
        if (!this.delegate) {
            classLoader = this.parent;
            if (classLoader == null) {
                classLoader = this.system;
            }
            if ((uRL = classLoader.getResource(string)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning '" + uRL.toString() + "'");
                }
                return uRL;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        Object object;
        if (this.debug >= 2) {
            this.log("getResourceAsStream(" + string + ")");
        }
        InputStream inputStream = null;
        inputStream = this.findLoadedResource(string);
        if (inputStream != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from cache");
            }
            return inputStream;
        }
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((object = this.parent) == null) {
                object = this.system;
            }
            if ((inputStream = ((ClassLoader)object).getResourceAsStream(string)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return inputStream;
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        if ((object = this.findResource(string)) != null) {
            if (this.debug >= 2) {
                this.log("  --> Returning stream from local");
            }
            inputStream = this.findLoadedResource(string);
            try {
                if (this.hasExternalRepositories && inputStream == null) {
                    inputStream = ((URL)object).openStream();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (inputStream != null) {
                return inputStream;
            }
        }
        if (!this.delegate) {
            ClassLoader classLoader;
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((classLoader = this.parent) == null) {
                classLoader = this.system;
            }
            if ((inputStream = classLoader.getResourceAsStream(string)) != null) {
                if (this.debug >= 2) {
                    this.log("  --> Returning stream from parent");
                }
                return inputStream;
            }
        }
        if (this.debug >= 2) {
            this.log("  --> Resource not found, returning null");
        }
        return null;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        ClassLoader classLoader;
        int n;
        if (this.debug >= 2) {
            this.log("loadClass(" + string + ", " + bl + ")");
        }
        Class<?> clazz = null;
        if (!this.started) {
            this.log("Lifecycle error : CL stopped", 1);
            throw new ClassNotFoundException(string);
        }
        clazz = this.findLoadedClass0(string);
        if (clazz != null) {
            if (this.debug >= 3) {
                this.log("  Returning class from cache");
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(string);
        if (clazz != null) {
            if (this.debug >= 3) {
                this.log("  Returning class from cache");
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        try {
            clazz = this.boot.loadClass(string);
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(string.substring(0, n));
            }
            catch (SecurityException securityException) {
                String string2 = "Security Violation, attempt to use Restricted Class: " + string;
                this.log(string2, 1);
                throw new ClassNotFoundException(string2);
            }
        }
        if (this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((classLoader = this.parent) == null) {
                classLoader = this.system;
            }
            try {
                clazz = classLoader.loadClass(string);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (bl) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.debug >= 3) {
            this.log("  Searching local repositories");
        }
        try {
            clazz = this.findClass(string);
            if (clazz != null) {
                if (this.debug >= 3) {
                    this.log("  Loading class from local repository");
                }
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!this.delegate) {
            if (this.debug >= 3) {
                this.log("  Delegating to parent classloader");
            }
            if ((classLoader = this.parent) == null) {
                classLoader = this.system;
            }
            try {
                clazz = classLoader.loadClass(string);
                if (clazz != null) {
                    if (this.debug >= 3) {
                        this.log("  Loading class from parent");
                    }
                    if (bl) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(string);
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String string = codeSource.getLocation().toString();
        PermissionCollection permissionCollection = (PermissionCollection)this.loaderPC.get(string);
        if (permissionCollection == null && (permissionCollection = super.getPermissions(codeSource)) != null) {
            Iterator iterator = this.permissionList.iterator();
            while (iterator.hasNext()) {
                Permission permission = (Permission)iterator.next();
                permissionCollection.add(permission);
            }
            this.loaderPC.put(string, permissionCollection);
        }
        return permissionCollection;
    }

    public URL[] getURLs() {
        URL[] uRLArray = super.getURLs();
        int n = this.files.length;
        int n2 = this.jarRealFiles.length;
        int n3 = n + n2 + uRLArray.length;
        try {
            URL[] uRLArray2 = new URL[n3];
            for (int i = 0; i < n3; ++i) {
                uRLArray2[i] = i < n ? this.getURL(this.files[i]) : (i < n + n2 ? this.getURL(this.jarRealFiles[i - n]) : uRLArray[i - n - n2]);
            }
            return uRLArray2;
        }
        catch (MalformedURLException malformedURLException) {
            return new URL[0];
        }
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
    }

    public void start() throws LifecycleException {
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.started = false;
        int n = this.jarFiles.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.jarFiles[i].close();
                this.jarFiles[i] = null;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.notFoundResources.clear();
        this.resourceEntries.clear();
        this.repositories = new String[0];
        this.files = new File[0];
        this.jarFiles = new JarFile[0];
        this.jarRealFiles = new File[0];
        this.jarPath = null;
        this.jarNames = new String[0];
        this.lastModifiedDates = new long[0];
        this.paths = new String[0];
        this.hasExternalRepositories = false;
        this.required.clear();
        this.permissionList.clear();
        this.loaderPC.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClassInternal(String string) throws ClassNotFoundException {
        Serializable serializable;
        Class clazz;
        if (!this.validate(string)) {
            throw new ClassNotFoundException(string);
        }
        String string2 = string.replace('.', '/');
        String string3 = string2 + ".class";
        ResourceEntry resourceEntry = null;
        if (this.securityManager != null) {
            clazz = new PrivilegedFindResource(string, string3);
            resourceEntry = (ResourceEntry)AccessController.doPrivileged(clazz);
        } else {
            resourceEntry = this.findResourceInternal(string, string3);
        }
        if (resourceEntry == null || resourceEntry.binaryContent == null) {
            throw new ClassNotFoundException(string);
        }
        clazz = resourceEntry.loadedClass;
        if (clazz != null) {
            return clazz;
        }
        String string4 = null;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string4 = string.substring(0, n);
        }
        Package package_ = null;
        if (string4 != null) {
            serializable = this.loaderPC;
            synchronized (serializable) {
                package_ = this.getPackage(string4);
                if (package_ == null) {
                    if (resourceEntry.manifest == null) {
                        this.definePackage(string4, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(string4, resourceEntry.manifest, resourceEntry.source);
                    }
                }
            }
        }
        serializable = new CodeSource(resourceEntry.source, resourceEntry.certificates);
        if (this.securityManager != null && package_ != null) {
            boolean bl = true;
            if (package_.isSealed()) {
                bl = package_.isSealed(resourceEntry.source);
            } else {
                boolean bl2 = bl = resourceEntry.manifest == null || !this.isPackageSealed(string4, resourceEntry.manifest);
            }
            if (!bl) {
                throw new SecurityException("Sealing violation loading " + string + " : Package " + string4 + " is sealed.");
            }
        }
        WebappClassLoader webappClassLoader = this;
        synchronized (webappClassLoader) {
            if (resourceEntry.loadedClass == null) {
                resourceEntry.loadedClass = clazz = this.defineClass(string, resourceEntry.binaryContent, 0, resourceEntry.binaryContent.length, (CodeSource)serializable);
            } else {
                clazz = resourceEntry.loadedClass;
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceEntry findResourceInternal(String string, String string2) {
        Object object;
        Object object2;
        int n;
        if (!this.started) {
            this.log("Lifecycle error : CL stopped", 1);
            return null;
        }
        if (string == null || string2 == null) {
            return null;
        }
        ResourceEntry resourceEntry = (ResourceEntry)this.resourceEntries.get(string);
        if (resourceEntry != null) {
            return resourceEntry;
        }
        int n2 = -1;
        InputStream inputStream = null;
        int n3 = this.jarFiles.length;
        int n4 = this.repositories.length;
        Resource resource = null;
        for (n = 0; resourceEntry == null && n < n4; ++n) {
            try {
                object2 = this.repositories[n] + string2;
                object = this.resources.lookup((String)object2);
                if (object instanceof Resource) {
                    resource = (Resource)object;
                }
                resourceEntry = new ResourceEntry();
                try {
                    resourceEntry.source = this.getURL(new File(this.files[n], string2));
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
                ResourceAttributes resourceAttributes = (ResourceAttributes)this.resources.getAttributes((String)object2);
                n2 = (int)resourceAttributes.getContentLength();
                resourceEntry.lastModified = resourceAttributes.getLastModified();
                if (resource == null) continue;
                try {
                    inputStream = resource.streamContent();
                }
                catch (IOException iOException) {
                    return null;
                }
                WebappClassLoader webappClassLoader = this;
                synchronized (webappClassLoader) {
                    int n5;
                    long[] lArray = new long[this.lastModifiedDates.length + 1];
                    for (n5 = 0; n5 < this.lastModifiedDates.length; ++n5) {
                        lArray[n5] = this.lastModifiedDates[n5];
                    }
                    lArray[this.lastModifiedDates.length] = resourceEntry.lastModified;
                    this.lastModifiedDates = lArray;
                    String[] stringArray = new String[this.paths.length + 1];
                    for (n5 = 0; n5 < this.paths.length; ++n5) {
                        stringArray[n5] = this.paths[n5];
                    }
                    stringArray[this.paths.length] = object2;
                    this.paths = stringArray;
                    continue;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (resourceEntry == null && this.notFoundResources.containsKey(string)) {
            return null;
        }
        object2 = null;
        for (n = 0; resourceEntry == null && n < n3; ++n) {
            object2 = this.jarFiles[n].getJarEntry(string2);
            if (object2 == null) continue;
            resourceEntry = new ResourceEntry();
            try {
                object = this.getURL(this.jarRealFiles[n]).toString();
                object = "jar:" + (String)object + "!/" + string2;
                resourceEntry.source = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return null;
            }
            n2 = (int)((ZipEntry)object2).getSize();
            try {
                resourceEntry.manifest = this.jarFiles[n].getManifest();
                inputStream = this.jarFiles[n].getInputStream((ZipEntry)object2);
                continue;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (resourceEntry == null) {
            object = this.notFoundResources;
            synchronized (object) {
                this.notFoundResources.put(string, string);
            }
            return null;
        }
        if (inputStream != null) {
            object = new byte[n2];
            try {
                int n6;
                int n7 = 0;
                while ((n6 = inputStream.read((byte[])object, n7, ((Object)object).length - n7)) > 0) {
                    n7 += n6;
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            if (PreprocessorUtil.isPreprocessorEnabled()) {
                object = PreprocessorUtil.processClass(string, (byte[])object);
            }
            resourceEntry.binaryContent = (byte[])object;
            if (object2 != null) {
                resourceEntry.certificates = ((JarEntry)object2).getCertificates();
            }
        }
        object = this;
        synchronized (object) {
            ResourceEntry resourceEntry2 = (ResourceEntry)this.resourceEntries.get(string);
            if (resourceEntry2 == null) {
                this.resourceEntries.put(string, resourceEntry);
            } else {
                resourceEntry = resourceEntry2;
            }
        }
        return resourceEntry;
    }

    protected boolean isPackageSealed(String string, Manifest manifest) {
        String string2 = string + "/";
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    protected InputStream findLoadedResource(String string) {
        ResourceEntry resourceEntry = (ResourceEntry)this.resourceEntries.get(string);
        if (resourceEntry != null && resourceEntry.binaryContent != null) {
            return new ByteArrayInputStream(resourceEntry.binaryContent);
        }
        return null;
    }

    protected Class findLoadedClass0(String string) {
        ResourceEntry resourceEntry = (ResourceEntry)this.resourceEntries.get(string);
        if (resourceEntry != null) {
            return resourceEntry.loadedClass;
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean validate(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("java.")) {
            return false;
        }
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return true;
        }
        string2 = string.substring(0, n);
        for (int i = 0; i < packageTriggers.length; ++i) {
            if (!string2.equals(packageTriggers[i])) continue;
            return false;
        }
        return true;
    }

    private boolean validateJarFile(File file) throws IOException {
        if (triggers == null) {
            return true;
        }
        JarFile jarFile = new JarFile(file);
        for (int i = 0; i < triggers.length; ++i) {
            JarEntry jarEntry;
            Class<?> clazz = null;
            try {
                clazz = this.parent != null ? this.parent.loadClass(triggers[i]) : Class.forName(triggers[i]);
            }
            catch (Throwable throwable) {
                clazz = null;
            }
            if (clazz == null) continue;
            String string = triggers[i].replace('.', '/') + ".class";
            if (this.debug >= 2) {
                this.log(" Checking for " + string);
            }
            if ((jarEntry = jarFile.getJarEntry(string)) == null) continue;
            jarFile.close();
            return false;
        }
        jarFile.close();
        return true;
    }

    protected URL getURL(File file) throws MalformedURLException {
        File file2 = file;
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new URL("file:" + file2.getPath());
    }

    private void log(String string) {
        System.out.println("WebappClassLoader: " + string);
    }

    private void log(String string, int n) {
        System.out.println("WebappClassLoader: " + string);
    }

    private void log(String string, Throwable throwable) {
        System.out.println("WebappClassLoader: " + string);
        throwable.printStackTrace(System.out);
    }

    protected static class ResourceEntry {
        long lastModified;
        byte[] binaryContent;
        Class loadedClass;
        URL source;
        Manifest manifest = null;
        Certificate[] certificates = null;

        protected ResourceEntry() {
        }
    }

    protected class PrivilegedFindResource
    implements PrivilegedAction {
        private String name;
        private String path;

        PrivilegedFindResource(String string, String string2) {
            this.name = string;
            this.path = string2;
        }

        public Object run() {
            return WebappClassLoader.this.findResourceInternal(this.name, this.path);
        }
    }
}

