/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import com.iplanet.ias.web.connector.nsapi.NSAPICertificatesValve;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Connector;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;

public class SSLAuthenticator
extends AuthenticatorBase {
    private static final String info = "org.apache.catalina.authenticator.SSLAuthenticator/1.0";

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest httpRequest, HttpResponse httpResponse, LoginConfig loginConfig) throws IOException {
        X509Certificate[] x509CertificateArray;
        Principal principal = ((HttpServletRequest)httpRequest.getRequest()).getUserPrincipal();
        if (principal != null) {
            if (this.debug >= 1) {
                this.log("Already authenticated '" + principal.getName() + "'");
            }
            return true;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)httpResponse.getResponse();
        if (this.debug >= 1) {
            this.log(" Looking up certificates");
        }
        if ((x509CertificateArray = (X509Certificate[])httpRequest.getRequest().getAttribute("javax.servlet.request.X509Certificate")) == null) {
            Connector connector = httpRequest.getConnector();
            x509CertificateArray = NSAPICertificatesValve.getCertificates(connector, true);
            httpRequest.getRequest().setAttribute("javax.servlet.request.X509Certificate", (Object)x509CertificateArray);
        }
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            if (this.debug >= 1) {
                this.log("  No certificates included with this request");
            }
            httpServletResponse.sendError(400);
            return false;
        }
        principal = this.context.getRealm().authenticate(x509CertificateArray);
        if (principal == null) {
            if (this.debug >= 1) {
                this.log("  Realm.authenticate() returned false");
            }
            httpServletResponse.sendError(401);
            return false;
        }
        this.register(httpRequest, httpResponse, principal, "CLIENT-CERT", null, null);
        return true;
    }

    public void start() throws LifecycleException {
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
    }
}

