/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.taglibs;

import com.sun.web.search.retrieval.Result;
import com.sun.web.search.retrieval.SearchException;
import com.sun.web.search.taglibs.ResultIterationTag;
import com.sun.web.search.taglibs.util.ResourceUtil;
import com.sun.web.search.taglibs.util.TagSupportEx;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;

public class ItemTag
extends TagSupportEx {
    private static final String PROP_TITLE = "title";
    private static final String PROP_PASSAGES = "passages";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_SCORE = "score";
    private static final String PROP_FILENAME = "fileName";
    private static final String PROP_URL = "url";
    private static final String PROP_SIZE = "size";
    private static final String PROP_DATE = "date";
    private String property;
    private Result resultItem;
    private ResultIterationTag parent;

    public void setProperty(String string) {
        this.property = string;
    }

    private String getPropertyValue() throws JspException {
        String string;
        if (this.property.equalsIgnoreCase(PROP_SCORE)) {
            return Float.toString(this.resultItem.getScore());
        }
        if (this.property.equalsIgnoreCase(PROP_NUMBER)) {
            return Integer.toString(this.parent.getCurIndex());
        }
        if (this.property.equalsIgnoreCase(PROP_FILENAME)) {
            return this.resultItem.getPath();
        }
        if (this.property.equalsIgnoreCase(PROP_URL)) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)this.pageContext.getRequest();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(httpServletRequest.getScheme() + "://");
            stringBuffer.append(httpServletRequest.getServerName());
            if (httpServletRequest.getServerPort() != 80) {
                stringBuffer.append(":" + httpServletRequest.getServerPort());
            }
            String string2 = this.resultItem.getPath();
            stringBuffer.append(string2.replaceFirst(this.parent.getCollRoot(), this.parent.getCollUri()));
            return stringBuffer.toString();
        }
        if (this.property.equalsIgnoreCase(PROP_TITLE)) {
            String string3;
            try {
                string3 = this.resultItem.getFieldValue(PROP_TITLE);
            }
            catch (SearchException searchException) {
                string3 = null;
            }
            if (string3 == null || string3.equals("")) {
                return "no title";
            }
            String[] stringArray = this.resultItem.getPassages();
            if (stringArray == null || stringArray.length == 0 || stringArray[0] == null || stringArray[0].length() == 0) {
                return string3;
            }
            return stringArray[0];
        }
        if (this.property.equalsIgnoreCase(PROP_PASSAGES)) {
            String string4;
            int n = 1;
            try {
                string4 = this.resultItem.getFieldValue(PROP_TITLE);
            }
            catch (SearchException searchException) {
                string4 = null;
            }
            if (string4 == null || string4.equals("")) {
                n = 0;
            }
            String[] stringArray = this.resultItem.getPassages();
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray.length > 1) {
                for (int i = n; i < stringArray.length && i < n + 2; ++i) {
                    stringBuffer.append(stringArray[i] + "...<br>");
                }
            }
            return stringBuffer.toString();
        }
        if (this.property.equalsIgnoreCase(PROP_DATE)) {
            return ResourceUtil.getLocalizedDateFormat(this.pageContext).format(this.resultItem.getDate());
        }
        if (this.property.equalsIgnoreCase(PROP_SIZE)) {
            long l = this.resultItem.getSize();
            if (l >= 1000L) {
                return Long.toString(l / 1000L) + " KB";
            }
            return Long.toString(l) + " Bytes";
        }
        try {
            string = this.resultItem.getFieldValue(this.property);
        }
        catch (SearchException searchException) {
            string = null;
        }
        return string;
    }

    public void otherDoStartTagOperations() throws JspException, JspTagException {
        this.parent = (ResultIterationTag)ItemTag.findAncestorWithClass((Tag)this, (Class)ResultIterationTag.class);
        if (this.parent != null) {
            String string;
            try {
                this.resultItem = this.parent.getCurrentItem();
            }
            catch (JspException jspException) {
                throw new JspTagException("No current item found");
            }
            if (this.resultItem != null && (string = this.getPropertyValue()) != null) {
                try {
                    JspWriter jspWriter = this.pageContext.getOut();
                    jspWriter.print(string);
                }
                catch (IOException iOException) {
                    throw new JspTagException("Error in ItemTag: " + iOException.getMessage());
                }
            }
        }
    }

    public boolean theBodyShouldBeEvaluated() {
        return false;
    }

    public void otherDoEndTagOperations() {
    }

    public boolean shouldEvaluateRestOfPageAfterEndTag() {
        return true;
    }

    public int doStartTag() throws JspException {
        this.otherDoStartTagOperations();
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }
}

