/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.index;

import com.sun.web.search.index.Index;
import com.sun.web.search.index.IndexDirectory;
import com.sun.web.search.index.IndexException;
import com.sun.web.search.index.KtIndex;
import com.sun.web.search.util.CollectionInfo;
import com.sun.web.search.util.SearchConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IndexManager {
    private HashMap collectionMap = new HashMap();
    private SearchConfig config;

    public IndexManager(SearchConfig searchConfig) throws IndexException {
        this.config = searchConfig;
        this.init();
    }

    public Index createIndex(String string, IndexDirectory indexDirectory, String string2, String string3) throws IndexException {
        if (this.collectionMap.get(string) != null) {
            throw new IndexException("Index exists.");
        }
        KtIndex ktIndex = new KtIndex(this.config, string, indexDirectory);
        this.collectionMap.put(string, ktIndex);
        return ktIndex;
    }

    public Index getIndex(String string) {
        return (Index)this.collectionMap.get(string);
    }

    public void deleteIndex(String string) throws IndexException {
        Index index = this.getIndex(string);
        if (index != null) {
            index.delete();
            this.collectionMap.remove(string);
        }
    }

    public String[] getIndexNames() {
        Set set = this.collectionMap.keySet();
        int n = set.size();
        String[] stringArray = new String[n];
        return set.toArray(stringArray);
    }

    public Iterator getIndices() {
        return this.collectionMap.values().iterator();
    }

    private void init() throws IndexException {
        HashMap hashMap = this.config.getCollectionConfig().getAllCollections();
        Iterator iterator = hashMap.entrySet().iterator();
        this.collectionMap.clear();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CollectionInfo collectionInfo = (CollectionInfo)entry.getValue();
            this.createIndex(collectionInfo.getName(), new IndexDirectory(collectionInfo.getIndexDirectory(), false), collectionInfo.getRootDirectory(), collectionInfo.getUri());
        }
    }
}

