/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.index;

import com.sun.kt.search.SearchEngine;
import com.sun.web.search.index.IndexException;
import com.sun.web.search.util.SearchProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Properties;

public class IndexDirectory {
    private String path = null;
    private File directory = null;
    private File indexDirectory = null;
    private File lockDirectory = null;
    private File conversionDirectory = null;
    private File logFile;
    private File historyFile;
    private PrintWriter logWriter = null;
    private PrintWriter historyWriter = null;

    public IndexDirectory(String string, boolean bl) throws IndexException {
        this.path = string;
        this.directory = new File(string);
        this.indexDirectory = new File(string + File.separator + "index");
        this.lockDirectory = new File(string + File.separator + "lock");
        this.conversionDirectory = new File(string + File.separator + "converted");
        this.prepare(bl);
    }

    private void prepare(boolean bl) throws IndexException {
        this.ensureDirectory(this.directory);
        this.ensureDirectory(this.indexDirectory);
        this.ensureDirectory(this.lockDirectory);
        this.ensureDirectory(this.conversionDirectory);
        FileOutputStream fileOutputStream = null;
        this.logFile = new File(this.path + File.separator + "log");
        try {
            fileOutputStream = new FileOutputStream(this.logFile, true);
            this.logWriter = new PrintWriter(fileOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.logWriter.println("Log file for collection ");
            this.logWriter.println("created " + new Date().toString());
            this.logWriter.println("");
            this.logWriter.flush();
            try {
                SearchProperties searchProperties = new SearchProperties();
                searchProperties.put("indexDir", this.getIndexDirectory().getAbsolutePath());
                searchProperties.put("lockDir", this.getLockDirectory().getAbsolutePath());
                SearchEngine searchEngine = new SearchEngine((Properties)searchProperties);
                searchEngine.close();
            }
            catch (Exception exception) {
                throw new IndexException(exception);
            }
        }
        this.historyFile = new File(this.path + File.separator + "history");
        try {
            fileOutputStream = new FileOutputStream(this.historyFile, true);
            this.historyWriter = new PrintWriter(fileOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cleanup() throws IndexException {
        this.nukeDirectory(this.indexDirectory);
        this.nukeDirectory(this.conversionDirectory);
        this.nukeDirectory(this.lockDirectory);
        this.logWriter.close();
        this.historyWriter.close();
        this.logFile.delete();
        this.historyFile.delete();
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public PrintWriter getHistoryWriter() {
        return this.historyWriter;
    }

    public String getTempConversionFilename() throws IndexException {
        try {
            File file = File.createTempFile("tmp", ".html", this.conversionDirectory);
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            throw new IndexException("Could not create temporary file.");
        }
    }

    public File getLockDirectory() {
        return this.lockDirectory;
    }

    public File getIndexDirectory() {
        return this.indexDirectory;
    }

    public void clearConversionDirectory() {
        File[] fileArray = this.conversionDirectory.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].isFile()) continue;
            fileArray[i].delete();
        }
    }

    private File ensureDirectory(File file) throws IndexException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IndexException("Could not create directory " + file);
        }
        return file;
    }

    private void nukeDirectory(File file) throws IndexException {
        if (!file.isDirectory()) {
            throw new IndexException(file.getAbsolutePath() + " is not a directory.");
        }
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file2 = fileArray[i];
            String string = file2.getName();
            if (file2.isDirectory() && !string.endsWith(File.separator + ".") && !string.endsWith(File.separator + "..")) {
                this.nukeDirectory(file2);
                continue;
            }
            if (!file2.isFile()) continue;
            file2.delete();
        }
        file.delete();
    }
}

