/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.index;

import com.sun.kt.search.IndexableFile;
import com.sun.web.search.index.ConversionPool;
import com.sun.web.search.index.FileConverter;
import com.sun.web.search.index.IndexDirectory;
import com.sun.web.search.index.IndexingLog;
import com.sun.web.search.index.KtIndexer;
import com.sun.web.search.util.ExtensionChecker;
import com.sun.web.search.util.PooledThread;
import com.sun.web.search.util.ThreadPool;
import java.util.Map;

public class ConversionThread
extends PooledThread {
    protected KtIndexer parent;
    protected FileConverter converter;
    protected IndexDirectory dir;
    protected ExtensionChecker extensionChecker;

    public void setPool(ThreadPool threadPool) {
        super.setPool(threadPool);
        this.parent = ((ConversionPool)threadPool).getParent();
        this.dir = ((ConversionPool)threadPool).getIndexDirectory();
        this.converter = new FileConverter(this.dir);
        this.extensionChecker = new ExtensionChecker(((ConversionPool)threadPool).getExtensionSpec());
        this.extensionChecker.addExtension("PDF");
    }

    protected void objectHandler() {
        String string = null;
        try {
            Map map = (Map)this.current;
            string = (String)map.get("sourcefile");
            if (this.needsConversion(string)) {
                String string2 = this.converter.convert(string);
                if (string2 != null) {
                    IndexingLog.log("indexing " + string2 + " instead of " + string);
                    String string3 = (String)map.get("enc");
                    map.put("sourcefile", string2);
                    map.put("filename", string2);
                    map.put("file", new IndexableFile(string2, string3));
                } else {
                    IndexingLog.log("converting " + string + " failed or is unsupported on this platform");
                    return;
                }
            }
            this.parent.index((String)map.get("dockey"), map);
        }
        catch (Exception exception) {
            IndexingLog.log("indexing " + string + " failed.", exception);
        }
    }

    protected void terminateHandler() {
    }

    protected boolean needsConversion(String string) {
        return this.extensionChecker.checkExtension(string);
    }
}

