/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.search.index;

import com.sun.web.search.index.AttributeMapper;
import com.sun.web.search.index.FileSource;
import com.sun.web.search.index.IndexingLog;
import com.sun.web.search.index.MetaTagParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ArrayFileSource
extends FileSource {
    protected String[] files;
    protected String directory;
    protected String encoding;
    protected String[] encodingArray;
    protected AttributeMapper attributeMapper;
    protected String collection;
    private int currentIndex;

    public ArrayFileSource(String string, String[] stringArray, String string2) {
        this.init(string, stringArray);
        this.encoding = string2;
        this.encodingArray = null;
    }

    public ArrayFileSource(String string, String[] stringArray, String[] stringArray2) {
        this.init(string, stringArray);
        this.encodingArray = stringArray2;
        this.encoding = null;
    }

    protected void init(String string, String[] stringArray) {
        this.collection = string;
        this.filter = null;
        this.attributeMapper = null;
        this.files = stringArray;
        this.currentIndex = 0;
    }

    protected ArrayFileSource() {
        this.collection = null;
        this.directory = null;
        this.encoding = null;
        this.encodingArray = null;
        this.files = null;
    }

    public void setAttributeMapper(AttributeMapper attributeMapper) {
        this.attributeMapper = attributeMapper;
    }

    public Map getNextEntry() {
        String string = null;
        long l = 0L;
        if (this.currentIndex == this.files.length) {
            return null;
        }
        string = this.files[this.currentIndex];
        String string2 = this.encoding == null ? this.encodingArray[this.currentIndex] : this.encoding;
        ++this.currentIndex;
        Map map = this.attributeMapper.getAttributeMap(string, string2);
        return map;
    }

    public String[] getMetaTagKeys() {
        String string = null;
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.files.length; ++i) {
            String string2;
            string = this.files[i];
            String string3 = string2 = this.encoding == null ? this.encodingArray[i] : this.encoding;
            if (!string.toUpperCase().endsWith("HTML") && !string.toUpperCase().endsWith("HTM")) {
                return null;
            }
            try {
                HashMap hashMap2;
                try {
                    hashMap2 = MetaTagParser.parse(string, string2);
                }
                catch (Exception exception) {
                    hashMap2 = MetaTagParser.parse(string, null);
                }
                if (hashMap2 == null || hashMap2.isEmpty()) continue;
                hashMap.putAll(hashMap2);
                continue;
            }
            catch (IOException iOException) {
                IndexingLog.log("Error in opening the file : " + string, iOException);
                continue;
            }
            catch (Exception exception) {
                IndexingLog.log("Error in meta Tag Murging  ", exception);
            }
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        return hashMap.keySet().toArray(new String[hashMap.size()]);
    }
}

