/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.iplanet.ias.server.ApplicationServer;
import com.sun.enterprise.PoolManager;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.JdbcAllocator;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.catalina.deploy.ContextResource;

public class JdbcDataSource
implements DataSource,
Serializable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource");
    static boolean _isFineLevel = _logger.isLoggable(Level.FINE);
    static boolean _isFinestLevel = _logger.isLoggable(Level.FINEST);
    private transient PoolManager poolMgr;
    private String dataSourceName;
    private String desc;
    private String jndiName;
    private String userName = null;
    private String password = null;
    private transient HashMap _allocatorMap;
    private ResourceSpec spec = null;

    private ResourcePrincipal getDefaultPrincipal() {
        ResourcePrincipal resourcePrincipal = this.userName != null && this.password != null ? new ResourcePrincipal(this.userName, this.password) : new ResourcePrincipal();
        return resourcePrincipal;
    }

    public Connection getConnection() throws SQLException {
        String string;
        this.initPoolManager();
        ContextResource contextResource = this.getResourceReference(this.jndiName);
        boolean bl = true;
        if (contextResource == null) {
            _logger.log(Level.INFO, "resource.datasource.reference_null", new Object[]{this.jndiName});
            return this.internalGetConnection(this.getDefaultPrincipal(), bl);
        }
        String string2 = contextResource.getScope();
        if (string2.equalsIgnoreCase("Unshareable")) {
            bl = false;
        }
        if ((string = contextResource.getAuth()).equalsIgnoreCase("Application")) {
            String string3 = Utility.getLocalizedString(_logger, "resource.datasource.password_warning", new Object[]{this.jndiName});
            if (_isFineLevel) {
                _logger.log(Level.FINE, string3);
            }
            throw new SQLException(string3);
        }
        return this.internalGetConnection(this.getDefaultPrincipal(), bl);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        String string3;
        this.initPoolManager();
        ContextResource contextResource = this.getResourceReference(this.jndiName);
        boolean bl = true;
        if (contextResource == null) {
            _logger.log(Level.INFO, "resource.datasource.reference_null", new Object[]{this.jndiName});
            return this.internalGetConnection(new ResourcePrincipal(string, string2), bl);
        }
        String string4 = contextResource.getScope();
        if (string4.equalsIgnoreCase("Unshareable")) {
            bl = false;
        }
        if ((string3 = contextResource.getAuth()).equalsIgnoreCase("Container")) {
            _logger.log(Level.INFO, "resource.datasource.redundant_password", new Object[]{this.jndiName});
            return this.internalGetConnection(this.getDefaultPrincipal(), bl);
        }
        return this.internalGetConnection(new ResourcePrincipal(string, string2), bl);
    }

    private ContextResource getResourceReference(String string) {
        return ApplicationServer.getServerContext().getResourceManager().getResRefDescriptorByGlobalJNDIName(string);
    }

    private Connection internalGetConnection(ResourcePrincipal resourcePrincipal, boolean bl) throws SQLException {
        ResourceAllocator resourceAllocator = null;
        this.spec.setJDBCConnectionPoolResourceName(this.dataSourceName);
        ClientSecurityInfo clientSecurityInfo = new ClientSecurityInfo(resourcePrincipal);
        try {
            resourceAllocator = this.getAllocator(clientSecurityInfo, bl);
            return (Connection)this.poolMgr.getResource(this.spec, resourceAllocator, new ClientSecurityInfo(resourcePrincipal));
        }
        catch (PoolingException poolingException) {
            Exception exception = poolingException.getNestedException();
            if (exception == null) {
                throw new SQLException(poolingException.getMessage());
            }
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            _logger.log(Level.SEVERE, "resource.datasource.getconnection_exception", exception);
            throw new SQLException(exception.toString());
        }
    }

    private ResourceAllocator getAllocator(ClientSecurityInfo clientSecurityInfo, boolean bl) throws PoolingException {
        ResourceAllocator resourceAllocator = null;
        if (this._allocatorMap == null) {
            this._allocatorMap = new HashMap();
        }
        if ((resourceAllocator = (ResourceAllocator)this._allocatorMap.get(clientSecurityInfo)) == null) {
            resourceAllocator = new JdbcAllocator(this.poolMgr, this.dataSourceName, this.spec, clientSecurityInfo);
            this._allocatorMap.put(clientSecurityInfo, resourceAllocator);
        }
        return resourceAllocator;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String string) {
        this.jndiName = string;
        this.spec = new ResourceSpec(this.dataSourceName, 1);
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        DriverManager.setLoginTimeout(n);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        DriverManager.setLogWriter(printWriter);
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    private void initPoolManager() {
        if (this.poolMgr == null) {
            this.poolMgr = ApplicationServer.getServerContext().getResourceManager().getPoolManager();
        }
    }
}

