/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server;

import com.iplanet.ias.loader.ClassLoaderUtils;
import com.iplanet.ias.server.ServerContext;
import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.LifecycleEventContext;
import com.sun.appserv.server.LifecycleEventContextImpl;
import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.logging.LogDomains;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ServerLifecycleModule {
    private LifecycleListener slcl;
    private String name;
    private String className;
    private String classpath;
    private int loadOrder;
    private boolean isFatal = true;
    private String statusMsg = "OK";
    private ServerContext ctx;
    private LifecycleEventContext leContext;
    private ClassLoader urlClassLoader;
    private Properties props = new Properties();
    private static Logger _logger = null;
    private static boolean _isTraceEnabled = false;
    private static ResourceBundle _rb = null;

    ServerLifecycleModule(ServerContext serverContext, String string, String string2) {
        this.name = string;
        this.className = string2;
        this.ctx = serverContext;
        this.leContext = new LifecycleEventContextImpl(serverContext);
        _logger = LogDomains.getLogger("javax.enterprise");
        _isTraceEnabled = _logger.isLoggable(Level.FINE);
        _rb = _logger.getResourceBundle();
    }

    void setClasspath(String string) {
        this.classpath = string;
    }

    void setProperty(String string, String string2) {
        this.props.put(string, string2);
    }

    Properties getProperties() {
        return this.props;
    }

    void setLoadOrder(int n) {
        this.loadOrder = n;
    }

    void setIsFatal(boolean bl) {
        this.isFatal = bl;
    }

    String getName() {
        return this.name;
    }

    String getClassName() {
        return this.className;
    }

    String getclasspath() {
        return this.classpath;
    }

    int getLoadOrder() {
        return this.loadOrder;
    }

    boolean isFatal() {
        return this.isFatal;
    }

    LifecycleListener loadServerLifecycle() throws ServerLifecycleException {
        ClassLoader classLoader = this.ctx.getLifecycleParentClassLoader();
        try {
            Object object;
            if (this.classpath != null) {
                object = this.getURLs();
                if (object != null) {
                    StringBuffer stringBuffer = new StringBuffer(128);
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        stringBuffer.append(((URL)object[i]).toString());
                    }
                    if (_isTraceEnabled) {
                        _logger.fine("Lifecycle module = " + this.getName() + " has classpath URLs = " + stringBuffer.toString());
                    }
                }
                classLoader = this.urlClassLoader = new URLClassLoader((URL[])object, classLoader);
            }
            object = Class.forName(this.className, true, classLoader);
            this.slcl = (LifecycleListener)((Class)object).newInstance();
        }
        catch (Exception exception) {
            String string = _rb.getString("lifecyclemodule.load_exception");
            Object[] objectArray = new Object[]{this.name, exception.toString()};
            string = MessageFormat.format(string, objectArray);
            _logger.log(Level.WARNING, string);
        }
        return this.slcl;
    }

    private URL[] getURLs() {
        return ClassLoaderUtils.getUrlsFromClasspath(this.classpath);
    }

    private void postEvent(int n, Object object) throws ServerLifecycleException {
        block7: {
            if (this.slcl == null) {
                if (this.isFatal) {
                    String string = _rb.getString("lifecyclemodule.loadExceptionIsFatal");
                    Object[] objectArray = new Object[]{this.name};
                    string = MessageFormat.format(string, objectArray);
                    throw new ServerLifecycleException(string);
                }
                return;
            }
            if (this.urlClassLoader != null) {
                this.setClassLoader();
            }
            LifecycleEvent lifecycleEvent = new LifecycleEvent(this, n, object, this.leContext);
            try {
                this.slcl.handleEvent(lifecycleEvent);
            }
            catch (ServerLifecycleException serverLifecycleException) {
                String string = _rb.getString("lifecyclemodule.event_ServerLifecycleException");
                Object[] objectArray = new Object[]{this.name};
                string = MessageFormat.format(string, objectArray);
                _logger.log(Level.WARNING, string, serverLifecycleException);
                if (this.isFatal) {
                    throw serverLifecycleException;
                }
            }
            catch (Exception exception) {
                String string = _rb.getString("lifecyclemodule.event_Exception");
                Object[] objectArray = new Object[]{this.name};
                string = MessageFormat.format(string, objectArray);
                _logger.log(Level.WARNING, string, exception);
                if (!this.isFatal) break block7;
                throw new ServerLifecycleException(_rb.getString("lifecyclemodule.event_exceptionIsFatal"), exception);
            }
        }
    }

    public void onInitialization(ServerContext serverContext) throws ServerLifecycleException {
        this.postEvent(0, this.props);
    }

    public void onStartup(ServerContext serverContext) throws ServerLifecycleException {
        this.postEvent(1, null);
    }

    public void onReady(ServerContext serverContext) throws ServerLifecycleException {
        this.postEvent(2, null);
    }

    public void onShutdown() throws ServerLifecycleException {
        this.postEvent(3, null);
    }

    public void onTermination() throws ServerLifecycleException {
        this.postEvent(4, null);
    }

    private void setClassLoader() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(ServerLifecycleModule.this.urlClassLoader);
                return null;
            }
        });
    }

    public String getStatus() {
        return this.statusMsg;
    }

    public String toString() {
        return "Server LifecycleListener support";
    }
}

