/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.connector.nsapi;

import com.iplanet.ias.web.connector.nsapi.NSAPIConnector;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Connector;

public final class NSAPICertificatesValve {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");

    public static X509Certificate[] getCertificates(Connector connector, boolean bl) {
        X509Certificate[] x509CertificateArray = null;
        if (connector instanceof NSAPIConnector) {
            String string;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Requesting client certificate from core with doRequest=" + bl);
            }
            if ((string = ((NSAPIConnector)connector).getCertificate(bl)) != null) {
                x509CertificateArray = new X509Certificate[]{NSAPICertificatesValve.getX509Certificate(string)};
            }
        } else {
            _logger.fine("getCertificates connector invalid: " + connector.getClass());
        }
        return x509CertificateArray;
    }

    static X509Certificate getX509Certificate(String string) {
        X509Certificate x509Certificate = null;
        if (string != null) {
            String string2 = "-----BEGIN CERTIFICATE-----\n" + string + "\n-----END CERTIFICATE-----\n";
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return x509Certificate;
    }
}

