/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.config.serverbeans.Search;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.Vs;
import com.iplanet.ias.config.serverbeans.Vsclass;
import com.iplanet.ias.config.serverbeans.Webapp;
import com.iplanet.ias.web.WebModule;
import com.iplanet.ias.web.WebModuleConfig;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;

public final class VirtualServer
extends StandardHost {
    private String _id = null;
    private long _jniVS = 0L;
    private static Logger _logger = null;
    private static ResourceBundle _rb = null;
    private boolean _debug = false;
    private static final String _info = "com.iplanet.ias.web.VirtualServer/1.0";

    public VirtualServer() {
        this.setErrorReportValveClass(null);
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
        }
        this._debug = _logger.isLoggable(Level.FINE);
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public void setJNIVirtualServer(long l) {
        this._jniVS = l;
    }

    public String getInfo() {
        return _info;
    }

    public String findMimeMapping(String string) {
        return this.jniFindMimeMapping(this._jniVS, string);
    }

    public String getRealPath(String string) {
        return this.jniGetRealPath(this._jniVS, string);
    }

    protected List getWebModules(Server server, String string) {
        Vector<WebModuleConfig> vector = new Vector<WebModuleConfig>();
        Vsclass[] vsclassArray = server.getVsclass();
        Vs vs = null;
        for (int i = 0; i < vsclassArray.length; ++i) {
            Vs[] vsArray = vsclassArray[i].getVs();
            if (vsArray == null) continue;
            for (int j = 0; j < vsArray.length; ++j) {
                if (!this._id.equals(vsArray[j].getId())) continue;
                vs = vsArray[j];
            }
        }
        if (vs != null) {
            Webapp webapp;
            Search search;
            WebModuleConfig webModuleConfig;
            Webapp[] webappArray = vs.getWebapp();
            if (webappArray != null && webappArray.length > 0) {
                for (int i = 0; i < webappArray.length; ++i) {
                    Webapp webapp2 = webappArray[i];
                    if (webapp2.isEnabled()) {
                        webModuleConfig = this.loadWebModuleConfig(webapp2, string);
                        if (webModuleConfig == null) continue;
                        vector.add(webModuleConfig);
                        continue;
                    }
                    if (!this._debug) continue;
                    _logger.finer("Web Module [" + webapp2.getUri() + "] is not applicable for virtual " + " server [" + this.getID() + "]");
                }
            }
            if ((search = vs.getSearch()) != null && (webapp = search.getWebapp()) != null && webapp.isEnabled() && (webModuleConfig = this.loadWebModuleConfig(webapp, string)) != null) {
                vector.add(webModuleConfig);
            }
        }
        return vector;
    }

    protected WebModuleConfig createSystemDefaultWebModuleIfNecessary() {
        WebModuleConfig webModuleConfig = null;
        String string = this.getAppBase();
        if (this.findChild("") == null && string != null) {
            Webapp webapp = new Webapp();
            webapp.setUri("/");
            webapp.setPath(string);
            webapp.setEnabled(true);
            webModuleConfig = new WebModuleConfig();
            webModuleConfig.setBean(webapp);
            webModuleConfig.setParent(this);
            webModuleConfig.setSystemDefaultContext(true);
        }
        return webModuleConfig;
    }

    protected void handleCoreMappings() {
        Container[] containerArray = this.findChildren();
        for (int i = 0; i < containerArray.length; ++i) {
            Object object;
            int n;
            int n2;
            StandardContext standardContext = (StandardContext)containerArray[i];
            String string = ((WebModule)standardContext).getID();
            if (!standardContext.getAvailable()) {
                this.jniSetContextUnavailable(this._jniVS, standardContext, string, standardContext.getPath(), standardContext.getDocBase());
                continue;
            }
            String[] stringArray = standardContext.findServletMappings();
            String[] stringArray2 = new String[stringArray.length];
            Object[] objectArray = new StandardWrapper[stringArray.length];
            int n3 = n2 = stringArray.length;
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n] = standardContext.findServletMapping(stringArray[n]);
                objectArray[n] = (StandardWrapper)standardContext.findChild(stringArray2[n]);
                object = objectArray[n].getServletClass();
                if (object != null && ((String)object).equals("org.apache.catalina.servlets.InvokerServlet")) {
                    objectArray[n] = null;
                }
                if (!stringArray[n].equals("/") || object == null || !((String)object).equals("com.iplanet.ias.web.servlets.DefaultServlet")) continue;
                n2 = n;
            }
            if (n2 < stringArray.length) {
                stringArray2[n2] = stringArray2[n3 - 1];
                stringArray[n2] = stringArray[n3 - 1];
                objectArray[n2] = objectArray[n3 - 1];
                --n3;
            }
            object = new int[2 * n3];
            byte[] byArray = null;
            byArray = this.createByteBufferForMapping(n3, stringArray2, stringArray, (int[])object);
            String[] stringArray3 = standardContext.findMimeMappings();
            String[] stringArray4 = new String[stringArray3.length];
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray4[n] = standardContext.findMimeMapping(stringArray3[n]);
            }
            int[] nArray = new int[2 * stringArray3.length];
            byte[] byArray2 = this.createByteBufferForMapping(stringArray3.length, stringArray3, stringArray4, nArray);
            String[] stringArray5 = standardContext.findWelcomeFiles();
            int[] nArray2 = new int[stringArray5.length];
            byte[] byArray3 = null;
            byArray3 = this.createByteBufferForList(stringArray5, nArray2);
            int[] nArray3 = standardContext.findStatusPages();
            String[] stringArray6 = new String[nArray3.length];
            for (n = 0; n < nArray3.length; ++n) {
                stringArray6[n] = standardContext.findErrorPage(nArray3[n]).getLocation();
            }
            byte[] byArray4 = null;
            int[] nArray4 = new int[stringArray6.length];
            byArray4 = this.createByteBufferForList(stringArray6, nArray4);
            Object[] objectArray2 = this.handleSecurityConstraints(standardContext);
            Object[] objectArray3 = this.handleFilterMappings(standardContext);
            boolean bl = standardContext.getLoginConfig() != null && standardContext.getLoginConfig().getLoginPage() != null;
            this.jniSetContextMapping(this._jniVS, standardContext, string, standardContext.getPath(), standardContext.getDocBase(), ((Object)object).length, (int[])object, byArray, objectArray, nArray.length, nArray, byArray2, nArray2.length, nArray2, byArray3, nArray3.length, nArray3, nArray4, byArray4, ((int[])objectArray2[0]).length, (int[])objectArray2[0], (int[])objectArray2[1], (byte[])objectArray2[2], (Integer)objectArray3[0], (int[])objectArray3[1], (byte[])objectArray3[2], bl);
        }
    }

    private Object[] handleSecurityConstraints(StandardContext standardContext) {
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        int n2;
        Object[] objectArray3;
        int n3;
        SecurityConstraint[] securityConstraintArray = standardContext.findConstraints();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < securityConstraintArray.length; ++n3) {
            objectArray3 = securityConstraintArray[n3].findCollections();
            for (n2 = 0; n2 < objectArray3.length; ++n2) {
                objectArray2 = objectArray3[n2].findPatterns();
                if (objectArray2.length <= 0) continue;
                ++n5;
                n6 += objectArray3[n2].getName().getBytes().length;
                for (n = 0; n < objectArray2.length; ++n) {
                    n6 += objectArray2[n].getBytes().length;
                    ++n4;
                }
            }
        }
        objectArray3 = new byte[n6];
        objectArray2 = new int[n4 + n5];
        int[] nArray = new int[n5];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < securityConstraintArray.length; ++n3) {
            objectArray = securityConstraintArray[n3].findCollections();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                String[] stringArray = ((SecurityCollection)objectArray[n2]).findPatterns();
                if (stringArray.length <= 0) continue;
                byte[] byArray = ((SecurityCollection)objectArray[n2]).getName().getBytes();
                objectArray2[n7] = byArray.length;
                System.arraycopy(byArray, 0, objectArray3, n8, objectArray2[n7]);
                n8 += objectArray2[n7++];
                nArray[n9++] = stringArray.length;
                for (n = 0; n < stringArray.length; ++n) {
                    byArray = stringArray[n].getBytes();
                    objectArray2[n7] = byArray.length;
                    System.arraycopy(byArray, 0, objectArray3, n8, objectArray2[n7]);
                    n8 += objectArray2[n7++];
                }
            }
        }
        objectArray = new Object[]{nArray, objectArray2, objectArray3};
        return objectArray;
    }

    private Object[] handleFilterMappings(StandardContext standardContext) {
        String string;
        String string2;
        int n;
        FilterMap[] filterMapArray = standardContext.findFilterMaps();
        int[] nArray = new int[2 * filterMapArray.length];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < filterMapArray.length; ++n) {
            string2 = filterMapArray[n].getURLPattern();
            if (string2 == null) continue;
            string = filterMapArray[n].getFilterName();
            nArray[n2] = string.getBytes().length;
            n3 += nArray[n2++];
            nArray[n2] = string2.getBytes().length;
            n3 += nArray[n2++];
        }
        byte[] byArray = new byte[n3];
        int n4 = 0;
        n2 = 0;
        for (n = 0; n < filterMapArray.length; ++n) {
            string2 = filterMapArray[n].getURLPattern();
            if (string2 == null) continue;
            string = filterMapArray[n].getFilterName();
            System.arraycopy(string.getBytes(), 0, byArray, n4, nArray[n2]);
            System.arraycopy(string2.getBytes(), 0, byArray, n4 += nArray[n2++], nArray[n2]);
            n4 += nArray[n2++];
        }
        Object[] objectArray = new Object[]{new Integer(n2), nArray, byArray};
        return objectArray;
    }

    private byte[] createByteBufferForMapping(int n, String[] stringArray, String[] stringArray2, int[] nArray) {
        byte[] byArray;
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            byArray = stringArray[n2].getBytes();
            nArray[n4] = byArray.length;
            n3 += nArray[n4++];
            byArray = stringArray2[n2].getBytes();
            nArray[n4] = byArray.length;
            n3 += nArray[n4++];
        }
        byte[] byArray2 = new byte[n3];
        int n5 = 0;
        n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            byArray = stringArray[n2].getBytes();
            System.arraycopy(byArray, 0, byArray2, n5, nArray[n4]);
            int n6 = n4++;
            byArray = stringArray2[n2].getBytes();
            System.arraycopy(byArray, 0, byArray2, n5 += nArray[n6], nArray[n4]);
            n5 += nArray[n4++];
        }
        return byArray2;
    }

    private byte[] createByteBufferForList(String[] stringArray, int[] nArray) {
        byte[] byArray;
        int n;
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            byArray = stringArray[n].getBytes();
            nArray[n] = byArray.length;
            n2 += nArray[n];
        }
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            byArray = stringArray[n].getBytes();
            System.arraycopy(byArray, 0, byArray2, n3, nArray[n]);
            n3 += nArray[n];
        }
        return byArray2;
    }

    private WebModuleConfig loadWebModuleConfig(Webapp webapp, String string) {
        String string2 = webapp.getPath();
        File file = new File(string2);
        if (!file.isAbsolute()) {
            string2 = string + File.separator + string2;
            webapp.setPath(string2);
        }
        WebModuleConfig webModuleConfig = new WebModuleConfig();
        webModuleConfig.setBean(webapp);
        webModuleConfig.setParent(this);
        return webModuleConfig;
    }

    private native String jniFindMimeMapping(long var1, String var3);

    private native void jniSetContextMapping(long var1, Object var3, String var4, String var5, String var6, int var7, int[] var8, byte[] var9, Object[] var10, int var11, int[] var12, byte[] var13, int var14, int[] var15, byte[] var16, int var17, int[] var18, int[] var19, byte[] var20, int var21, int[] var22, int[] var23, byte[] var24, int var25, int[] var26, byte[] var27, boolean var28);

    private native void jniSetContextUnavailable(long var1, Object var3, String var4, String var5, String var6);

    private native String jniGetRealPath(long var1, String var3);
}

