/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.diagnostics;

import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.diagnostics.FieldInfo;
import java.util.Vector;

class FieldInfoVector {
    Vector v = new Vector();
    private int classNameLength = 0;
    private int fieldNameLength = 0;
    private int modifiersLength = 0;

    FieldInfoVector() {
    }

    public void addElement(Object object) {
        this.v.addElement(object);
    }

    public String toString() {
        int n = this.v.size();
        StringBuffer stringBuffer = new StringBuffer();
        this.setLongestNames();
        stringBuffer.append(StringUtils.padRight("Class", this.classNameLength));
        stringBuffer.append(StringUtils.padRight("Modifiers", this.modifiersLength));
        stringBuffer.append(StringUtils.padRight("Field", this.fieldNameLength));
        stringBuffer.append("Value");
        stringBuffer.append("\n\n");
        for (int i = 0; i < n; ++i) {
            FieldInfo fieldInfo = this.fetch(i);
            stringBuffer.append(StringUtils.padRight(fieldInfo.className, this.classNameLength));
            stringBuffer.append(StringUtils.padRight(fieldInfo.modifiers, this.modifiersLength));
            stringBuffer.append(StringUtils.padRight(fieldInfo.field.getName(), this.fieldNameLength));
            stringBuffer.append(fieldInfo.value);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private FieldInfo fetch(int n) {
        return (FieldInfo)this.v.elementAt(n);
    }

    private void setLongestNames() {
        int n = this.v.size();
        this.classNameLength = 5;
        this.fieldNameLength = 5;
        this.modifiersLength = 5;
        for (int i = 0; i < n; ++i) {
            FieldInfo fieldInfo = this.fetch(i);
            int n2 = fieldInfo.className.length();
            int n3 = fieldInfo.field.getName().length();
            int n4 = fieldInfo.modifiers.length();
            if (n2 > this.classNameLength) {
                this.classNameLength = n2;
            }
            if (n3 > this.fieldNameLength) {
                this.fieldNameLength = n3;
            }
            if (n4 <= this.modifiersLength) continue;
            this.modifiersLength = n4;
        }
        this.classNameLength += 2;
        this.fieldNameLength += 2;
        this.modifiersLength += 2;
    }
}

