/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.util;

import com.sun.web.admin.beans.AdminException;
import java.io.File;

public class ValidateUtil {
    public static boolean isTrue(String string) {
        return "1".equals(string) || "y".equals(string) || "on".equals(string) || "yes".equals(string) || "true".equals(string) || "enable".equals(string) || "enabled".equals(string);
    }

    public static boolean isFalse(String string) {
        return "0".equals(string) || "n".equals(string) || "off".equals(string) || "no".equals(string) || "false".equals(string) || "disable".equals(string) || "disabled".equals(string);
    }

    public static boolean isValidBoolean(String string) {
        return ValidateUtil.isTrue(string) || ValidateUtil.isFalse(string);
    }

    public static boolean isValidId(String string) {
        return string.matches("^[A-Za-z_][A-Za-z0-9\\.\\-_]*$");
    }

    private static int getNumOccurrences(char c, String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    private static boolean hasMoreThanOneDoubleColon(String string) {
        String string2;
        int n = string.indexOf("::");
        return n >= 0 && (string2 = string.substring(n + 1, string.length())).indexOf("::") >= 0;
    }

    private static boolean isIpv6HexSequence(String string) {
        String string2 = "^[A-Fa-f0-9]{0,4}$";
        String[] stringArray = string.split(":");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].matches(string2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidIpv6AddressWithMixedIpv4(String string) {
        int n = string.lastIndexOf(58);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        if (!ValidateUtil.isValidIpv4Address(string3)) {
            return false;
        }
        if (ValidateUtil.getNumOccurrences(':', string2) > 6) {
            return false;
        }
        return ValidateUtil.isIpv6HexSequence(string2);
    }

    private static boolean isValidIpv6AddressNotMixedWithIpv4(String string) {
        if (ValidateUtil.getNumOccurrences(':', string) > 7) {
            return false;
        }
        return ValidateUtil.isIpv6HexSequence(string);
    }

    public static boolean isValidIpv6Address(String string) {
        if ("::".equals(string)) {
            return true;
        }
        if (ValidateUtil.hasMoreThanOneDoubleColon(string)) {
            return false;
        }
        if (string.indexOf(":") >= 0) {
            if (string.indexOf(".") >= 0) {
                return ValidateUtil.isValidIpv6AddressWithMixedIpv4(string);
            }
            return ValidateUtil.isValidIpv6AddressNotMixedWithIpv4(string);
        }
        return false;
    }

    public static boolean isValidIpv4Address(String string) {
        String[] stringArray = string.split(".");
        if (stringArray.length != 4) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n = -1;
            try {
                Integer.parseInt(stringArray[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n >= 0 && n <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidIpAddress(String string) {
        if (ValidateUtil.isIpAny(string)) {
            return true;
        }
        if (ValidateUtil.isValidIpv4Address(string)) {
            return true;
        }
        return ValidateUtil.isValidIpv6Address(string);
    }

    public static boolean isIpAny(String string) {
        return string.equals("::") || string.equals("0") || string.equals("0.0.0.0") || string.equals("any") || string.equals("ANY") || string.equals("INADDR_ANY");
    }

    public static boolean isValidPort(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n > 0 && n < 65536;
    }

    public static boolean isValidInteger(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return n >= 0;
    }

    public static boolean isValidServerName(String string) {
        return string.matches("^[A-Za-z0-9\\.\\-:]+$");
    }

    public static boolean isDigit(String string) {
        return string.matches("^[0-9]$");
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isWhitespace(String string) {
        return string.matches("^\\s*$");
    }

    public static boolean isValidWebapp(String string) throws AdminException {
        File file = new File(string);
        String string2 = null;
        if (!file.exists()) {
            string2 = "The Webapp location does not exist.";
        } else if (!file.isDirectory()) {
            string2 = "The Webapp location is not a directory.";
        } else {
            String string3 = string + "/WEB-INF/web.xml";
            File file2 = new File(string3);
            if (!file2.exists()) {
                string2 = "The Webapp location does not have a web application.";
            }
        }
        if (string2 != null) {
            throw new AdminException(string2);
        }
        return true;
    }
}

