/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.util;

import com.sun.web.admin.util.MultipartFile;
import com.sun.web.admin.util.MultipartInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class MultipartHandler {
    private static final int DEFAULT_MAX_UPLOAD_SIZE = 0xA00000;
    protected Hashtable formFields = new Hashtable();
    protected Hashtable uploadFiles = new Hashtable();
    private HttpServletRequest req;
    private ServletInputStream in;
    private String boundary;
    private byte[] buf = new byte[8192];
    private File uploadDir;
    private String fieldEncoding = "ISO-8859-1";

    public MultipartHandler(HttpServletRequest httpServletRequest, String string) throws IOException {
        this(httpServletRequest, string, 0xA00000, "ISO-8859-1");
    }

    public MultipartHandler(HttpServletRequest httpServletRequest, String string, int n) throws IOException {
        this(httpServletRequest, string, n, "ISO-8859-1");
    }

    public MultipartHandler(HttpServletRequest httpServletRequest, String string, int n, String string2) throws IOException {
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("tmpDirectory cannot be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        this.uploadDir = new File(string);
        if (!this.uploadDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + string);
        }
        if (!this.uploadDir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + string);
        }
        int n2 = httpServletRequest.getContentLength();
        if (n2 > n) {
            throw new IOException("Posted content length of " + n2 + " exceeds limit of " + n);
        }
        String string3 = httpServletRequest.getContentType();
        if (string3 == null || !string3.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        this.fieldEncoding = string2;
        this.req = httpServletRequest;
    }

    public void parseMultipartUpload() throws IOException {
        this.startMultipartParse();
        HashMap hashMap = this.parsePartHeaders();
        while (hashMap != null) {
            String string = (String)hashMap.get("fieldName");
            String string2 = (String)hashMap.get("fileName");
            if (string2 != null) {
                if (string2.equals("")) {
                    string2 = null;
                }
                if (string2 != null) {
                    this.saveUploadFile(string2);
                    this.uploadFiles.put(string, new MultipartFile(this.uploadDir.toString(), string2, (String)hashMap.get("content-type")));
                } else {
                    this.uploadFiles.put(string, new MultipartFile(null, null, null));
                }
            } else {
                byte[] byArray = this.parseFormFieldBytes();
                String string3 = new String(byArray, this.fieldEncoding);
                Vector<String> vector = (Vector<String>)this.formFields.get(string);
                if (vector == null) {
                    vector = new Vector<String>();
                    this.formFields.put(string, vector);
                }
                vector.addElement(string3);
            }
            hashMap.clear();
            hashMap = this.parsePartHeaders();
        }
    }

    private void startMultipartParse() throws IOException {
        String string = this.parseBoundary(this.req.getContentType());
        if (string == null) {
            throw new IOException("Separation boundary was not specified");
        }
        this.in = this.req.getInputStream();
        this.boundary = string;
        String string2 = this.readLine();
        if (string2 == null) {
            throw new IOException("Corrupt form data: premature ending");
        }
        if (!string2.startsWith(string)) {
            throw new IOException("Corrupt form data: no leading boundary: " + string2 + " != " + string);
        }
    }

    private HashMap parsePartHeaders() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Vector<String> vector = new Vector<String>();
        String string = this.readLine();
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        vector.addElement(string);
        while ((string = this.readLine()) != null && string.length() > 0) {
            vector.addElement(string);
        }
        if (string == null) {
            return null;
        }
        hashMap.put("content-type", "text/plain");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.toLowerCase().startsWith("content-disposition:")) {
                this.parseContentDisposition(string2, hashMap);
                continue;
            }
            if (!string2.toLowerCase().startsWith("content-type:")) continue;
            this.parseContentType(string2, hashMap);
        }
        return hashMap;
    }

    private String parseBoundary(String string) {
        int n = string.lastIndexOf("boundary=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 9);
        if (string2.charAt(0) == '\"') {
            n = string2.lastIndexOf(34);
            string2 = string2.substring(1, n);
        }
        string2 = "--" + string2;
        return string2;
    }

    private void parseContentDisposition(String string, HashMap hashMap) throws IOException {
        String string2 = string;
        string = string2.toLowerCase();
        int n = string.indexOf("content-disposition: ");
        int n2 = string.indexOf(";");
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string2);
        }
        String string3 = string.substring(n + 21, n2);
        if (!string3.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + string3);
        }
        n = string.indexOf("name=\"", n2);
        n2 = string.indexOf("\"", n + 7);
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string2);
        }
        String string4 = string2.substring(n + 6, n2);
        String string5 = null;
        String string6 = null;
        n = string.indexOf("filename=\"", n2 + 2);
        n2 = string.indexOf("\"", n + 10);
        if (n != -1 && n2 != -1) {
            string6 = string5 = string2.substring(n + 10, n2);
            int n3 = Math.max(string5.lastIndexOf(47), string5.lastIndexOf(92));
            if (n3 > -1) {
                string5 = string5.substring(n3 + 1);
            }
        }
        hashMap.put("disposition", string3);
        hashMap.put("fieldName", string4);
        hashMap.put("fileName", string5);
        hashMap.put("filePath", string6);
    }

    private void parseContentType(String string, HashMap hashMap) throws IOException {
        String string2 = null;
        String string3 = string;
        if ((string = string3.toLowerCase()).startsWith("content-type")) {
            int n = string.indexOf(" ");
            if (n == -1) {
                throw new IOException("Content type corrupt: " + string3);
            }
            string2 = string.substring(n + 1);
            hashMap.put("content-type", string2);
        } else if (string.length() != 0) {
            throw new IOException("Malformed line after disposition: " + string3);
        }
    }

    private byte[] parseFormFieldBytes() throws IOException {
        int n;
        MultipartInputStream multipartInputStream = new MultipartInputStream(this.in, this.boundary);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        byte[] byArray = new byte[128];
        while ((n = multipartInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        multipartInputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((n = this.in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            stringBuffer.append(new String(this.buf, 0, n, "ISO-8859-1"));
        } while (n == this.buf.length);
        if (stringBuffer.length() == 0) {
            return null;
        }
        int n2 = stringBuffer.length();
        if (stringBuffer.charAt(n2 - 2) == '\r') {
            stringBuffer.setLength(n2 - 2);
        } else {
            stringBuffer.setLength(n2 - 1);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long saveUploadFile(String string) throws IOException {
        long l = 0L;
        OutputStream outputStream = null;
        try {
            int n;
            File file = new File(this.uploadDir, string);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[8192];
            MultipartInputStream multipartInputStream = new MultipartInputStream(this.in, this.boundary);
            while ((n = multipartInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
                l += (long)n;
            }
            multipartInputStream.close();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return l;
    }

    public Enumeration getParameterNames() {
        return this.formFields.keys();
    }

    public Enumeration getFileNames() {
        return this.uploadFiles.keys();
    }

    public String getParameter(String string) {
        try {
            Vector vector = (Vector)this.formFields.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            String string2 = (String)vector.elementAt(vector.size() - 1);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getParameterValues(String string) {
        try {
            Vector vector = (Vector)this.formFields.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFileName(String string) {
        try {
            MultipartFile multipartFile = (MultipartFile)this.uploadFiles.get(string);
            return multipartFile.getFileName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFileType(String string) {
        try {
            MultipartFile multipartFile = (MultipartFile)this.uploadFiles.get(string);
            return multipartFile.getFileType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getFile(String string) {
        try {
            MultipartFile multipartFile = (MultipartFile)this.uploadFiles.get(string);
            return multipartFile.getFile();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void close() throws IOException {
        this.req = null;
        this.in = null;
        this.boundary = null;
        this.buf = null;
        this.uploadDir = null;
    }
}

