/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.cmds;

import com.sun.web.admin.beans.AdminConfig;
import com.sun.web.admin.beans.MagObj;
import com.sun.web.admin.cmds.DeployXmlErrorHandler;
import com.sun.web.admin.cmds.StreamConsumer;
import com.sun.web.admin.util.MiscUtil;
import com.sun.web.admin.util.SlashUtil;
import com.sun.web.admin.util.UnZips;
import com.sun.web.admin.util.XmlConfig;
import com.sun.web.admin.util.XmlNode;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Deploy {
    public String dirToExtract;
    public String warFileName;
    public String uriPath;
    public String vsId;
    public String serverInst;
    public static String serverRoot;
    public static String defaultWebappDir;
    private static String SLASH;
    private static String SERVER_ROOT;
    private static String SERVER_XML_FILE;
    private static String CONFIG_DIR;
    private static String WEBXML_DTD_ID;
    private static String WEBXML_DTD_RESOURCE;
    private static final String WEBXML_DTD_DOCLINE = "<!DOCTYPE SERVER PUBLIC \"-//Sun Microsystems Inc.//DTD Sun ONE Web Server 6.1//EN\" \"file://";
    private static final String WEBXML_DTD_DOCLINE2 = "/bin/https/dtds/sun-web-server_6_1.dtd\">";
    private static int matchFlag;
    private static final String OPTION_VERBOSE = "-V";
    private static final String OPTION_QUIET = "-q";
    private static final String WEBAPP = "WEBAPP";
    private static final String SERVER = "SERVER";
    private static final String VSCLASS = "VSCLASS";
    private static final String VS = "VS";
    private static final String PROP = "PROPERTY";
    private static final String URI = "uri";
    private static final String PATH = "path";
    private static final String ENABLED = "enabled";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String DOCROOT = "docroot";
    private static boolean newDirCreated_;
    private static boolean changeOwner_;
    private static String instUser;
    private static String currentUser;
    private static int verboseLevel;
    private static DeployXmlErrorHandler deployErrorHandler;
    private static final String USAGE = "\nUsage:\nwdeploy deploy -u <uri_path> -i <instance> -v <vs_id> [ [-V <verboseLevel>]| [-q] ] [-n] [-d <directory>] <war_file>  \nwdeploy delete -u <uri_path> -i <instance> -v <vs_id> [ [-V <verboseLevel>] | [-q] ] [-n] hard|soft \nwdeploy list -i <instance> -v <vs_id> [ [-V <verboseLevel>] | [ -q] ]\n";

    public Deploy(String string, String string2, String string3, String string4, String string5) {
        this.uriPath = string;
        this.warFileName = string2;
        this.dirToExtract = string3;
        this.serverInst = string4;
        this.vsId = string5;
    }

    private static boolean validateURI(String string) {
        return string.startsWith("/");
    }

    private static int validateArgs(String[] stringArray, Hashtable hashtable) throws Exception {
        String string;
        Object object;
        int n = 8;
        int n2 = 8;
        int n3 = 5;
        int n4 = stringArray.length;
        Object var6_6 = null;
        boolean bl = false;
        Object var8_8 = null;
        String string2 = stringArray[0];
        if (!(string2.equals("deploy") || string2.equals("delete") || string2.equals("list"))) {
            Deploy.log(1, "wdeploy: Invalid option - " + string2);
            return 1;
        }
        hashtable.put("DepOption", string2);
        if (string2.equals("deploy")) {
            String string3;
            if (n > n4) {
                Deploy.log(1, "wdeploy deploy: Too few arguments");
                return 1;
            }
            for (int i = 1; i < n4; ++i) {
                if (stringArray[i].equals("-u") || stringArray[i].equals("-i") || stringArray[i].equals("-v") || stringArray[i].equals("-d") || stringArray[i].equals(OPTION_VERBOSE)) {
                    if (i + 1 == n4) {
                        Deploy.log(1, "The argument for option " + stringArray[i] + " is not specified");
                        return 1;
                    }
                    if (stringArray[i + 1].startsWith("-")) {
                        Deploy.log(1, "The value for option " + stringArray[i] + " is not correct, value cannot start with -");
                        return 1;
                    }
                    if (stringArray[i].equals("-i")) {
                        object = stringArray[i + 1];
                        if (!((String)object).startsWith("https-")) {
                            object = "https-" + stringArray[i + 1];
                        }
                        hashtable.put(stringArray[i], object);
                    } else if (stringArray[i].equals(OPTION_VERBOSE)) {
                        object = stringArray[i + 1];
                        try {
                            verboseLevel = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            verboseLevel = 0;
                        }
                        hashtable.put(OPTION_VERBOSE, new Integer(verboseLevel));
                    } else {
                        hashtable.put(stringArray[i], stringArray[i + 1]);
                    }
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-n")) {
                    hashtable.put(stringArray[i], "");
                    continue;
                }
                if (stringArray[i].equals(OPTION_QUIET)) {
                    verboseLevel = 0;
                    continue;
                }
                if (!hashtable.containsKey("warFileName")) {
                    hashtable.put("warFileName", stringArray[i]);
                    Deploy.log(1, "The war file name is " + stringArray[i]);
                    continue;
                }
                Deploy.log(1, "Ignoring commandline argument " + stringArray[i]);
            }
            if (hashtable.containsKey("-d")) {
                File file = new File((String)hashtable.get("-d"));
                hashtable.put("-d", file.getCanonicalPath());
            }
            if ((string3 = (String)hashtable.get("warFileName")) == null) {
                Deploy.log(1, "The argument <war_file> is not specified");
                return 1;
            }
            object = new File(string3);
            if (!((File)object).exists()) {
                Deploy.log(1, "The war file " + string3 + " doesn't exist.");
                return 1;
            }
            if (((File)object).isDirectory()) {
                Deploy.log(1, "The " + string3 + " is a directory and not a war file.");
                return 1;
            }
        }
        if (string2.equals("delete")) {
            if (n2 > n4) {
                Deploy.log(1, "wdeploy delete: Too few arguments");
                return 1;
            }
            for (int i = 1; i < n4; ++i) {
                if (stringArray[i].equals("-u") || stringArray[i].equals("-i") || stringArray[i].equals("-v") || stringArray[i].equals("-d") || stringArray[i].equals(OPTION_VERBOSE)) {
                    if (i + 1 == n4) {
                        Deploy.log(1, "The argument for option " + stringArray[i] + " is not specified");
                        return 1;
                    }
                    if (stringArray[i + 1].startsWith("-")) {
                        Deploy.log(1, "The value for option " + stringArray[i] + " is not correct, value cannot start with -");
                        return 1;
                    }
                    if (stringArray[i].equals("-i")) {
                        object = stringArray[i + 1];
                        if (!((String)object).startsWith("https-")) {
                            object = "https-" + stringArray[i + 1];
                        }
                        hashtable.put(stringArray[i], object);
                    } else if (stringArray[i].equals(OPTION_VERBOSE)) {
                        object = stringArray[i + 1];
                        try {
                            verboseLevel = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            verboseLevel = 0;
                        }
                        hashtable.put(OPTION_VERBOSE, new Integer(verboseLevel));
                    } else {
                        hashtable.put(stringArray[i], stringArray[i + 1]);
                    }
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-n")) {
                    hashtable.put(stringArray[i], "");
                    continue;
                }
                if (stringArray[i].equals(OPTION_QUIET)) {
                    verboseLevel = 0;
                    continue;
                }
                object = stringArray[i];
                if (((String)object).equals("hard") || ((String)object).equals("soft")) {
                    hashtable.put("DeleteOption", object);
                    Deploy.log(2, "using delete option=" + (String)object);
                    continue;
                }
                Deploy.log(1, "Ignoring commandline argument " + stringArray[i]);
            }
            if (hashtable.containsKey("-d")) {
                Deploy.log(4, "wdeploy delete: Ignoring -d");
            }
            if (!hashtable.containsKey("DeleteOption")) {
                Deploy.log(1, "Invalid delete mode : specify hard or soft.");
                return 1;
            }
        }
        boolean bl2 = false;
        if (string2.equals("list")) {
            if (n3 > n4) {
                Deploy.log(1, "wdeploy list: Too few arguments");
                return 1;
            }
            bl2 = true;
            for (int i = 1; i < n4; ++i) {
                if (stringArray[i].equals("-u") || stringArray[i].equals("-i") || stringArray[i].equals("-v") || stringArray[i].equals("-d") || stringArray[i].equals(OPTION_VERBOSE)) {
                    if (i + 1 == n4) {
                        Deploy.log(1, "The argument for option " + stringArray[i] + " is not specified");
                        return 1;
                    }
                    if (stringArray[i + 1].startsWith("-")) {
                        Deploy.log(1, "The value for option " + stringArray[i] + " is not correct, value cannot start with -");
                        return 1;
                    }
                    if (stringArray[i].equals("-i")) {
                        string = stringArray[i + 1];
                        if (!string.startsWith("https-")) {
                            string = "https-" + stringArray[i + 1];
                        }
                        hashtable.put(stringArray[i], string);
                    } else if (stringArray[i].equals(OPTION_VERBOSE)) {
                        string = stringArray[i + 1];
                        try {
                            verboseLevel = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            verboseLevel = 0;
                        }
                        hashtable.put(OPTION_VERBOSE, new Integer(verboseLevel));
                    } else {
                        hashtable.put(stringArray[i], stringArray[i + 1]);
                    }
                    ++i;
                    continue;
                }
                if (stringArray[i].equals("-n")) {
                    hashtable.put(stringArray[i], "");
                    continue;
                }
                if (stringArray[i].equals(OPTION_QUIET)) {
                    verboseLevel = 0;
                    continue;
                }
                Deploy.log(1, "Ignoring command line argument " + stringArray[i]);
            }
        }
        if (hashtable.get("-i") == null) {
            Deploy.log(1, "Invalid syntax. Use the -i option to specify the web server instance to deploy to.");
            return 1;
        }
        String string4 = hashtable.get("-i").toString();
        string = null;
        string = serverRoot + SLASH + string4;
        File file = new File(string);
        if (!file.exists() && !file.isDirectory()) {
            Deploy.log(1, "Invalid server instance given with -i option.");
            Deploy.log(1, "The directory '" + file + "' doesn't exist.");
            return 1;
        }
        if (!bl2) {
            if (hashtable.containsKey("-u")) {
                if (!Deploy.validateURI(hashtable.get("-u").toString())) {
                    Deploy.log(1, "Invalid uri specification. The uri specified by the -u option must start with a \"/\" symbol.");
                    return 1;
                }
            } else {
                System.out.println("Invalid syntax. Use -u option to specify the uri.");
                System.out.println("");
                return 1;
            }
        }
        if (hashtable.get("-v") == null) {
            Deploy.log(1, "Invalid syntax. Use the -v option to specify the id of a virtual server.");
            return 1;
        }
        if (!Deploy.isVSAvailible(hashtable.get("-i").toString(), hashtable.get("-v").toString())) {
            return 1;
        }
        return 0;
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    private static boolean isVSAvailible(String string, String string2) throws Exception {
        boolean bl = false;
        XmlNode xmlNode = Deploy.getRootNode(string);
        XmlNode xmlNode2 = Deploy.getVSNode(xmlNode, string2);
        if (xmlNode2 == null) {
            Deploy.listVirtualServers(string);
        } else {
            bl = true;
        }
        return bl;
    }

    private static void listVirtualServers(String string) {
        XmlNode xmlNode = Deploy.getRootNode(string);
        Iterator iterator = xmlNode.iterate(VSCLASS);
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            Iterator iterator2 = xmlNode2.iterate(VS);
            while (iterator2.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator2.next();
                stringBuffer.append(xmlNode3.getString(ID, null)).append("  ");
            }
        }
        Deploy.log(1, "The list of available virtual server(s) : " + stringBuffer.toString());
    }

    private static XmlNode getRootNode(String string) {
        String string2 = serverRoot + SLASH + string + SLASH + CONFIG_DIR + SLASH + SERVER_XML_FILE;
        File file = new File(string2);
        if (file.exists()) {
            if (!file.canRead()) {
                Deploy.log(1, "Cannot read " + string2 + ". Check file permissions.");
                Deploy.log(1, USAGE);
                System.exit(2);
            }
        } else {
            Deploy.log(1, "Cannot find " + string2);
            Deploy.log(1, USAGE);
            System.exit(2);
        }
        Deploy.log(4, "Parsing the file " + string2);
        XmlConfig xmlConfig = new XmlConfig(string2);
        XmlNode xmlNode = null;
        try {
            xmlNode = xmlConfig.parseConfig(deployErrorHandler);
            Deploy.log(4, "Parsed the file " + string2 + " successfully...");
        }
        catch (Exception exception) {
            Deploy.log(1, "Error encountered while parsing " + string2);
            Deploy.log(3, exception);
            System.exit(1);
        }
        Iterator iterator = xmlNode.iterate(SERVER);
        if (iterator.hasNext()) {
            xmlNode = (XmlNode)iterator.next();
        } else {
            Deploy.log(1, "Can't find SERVER element in file " + string2);
            System.exit(1);
        }
        return xmlNode;
    }

    private static XmlNode getVSNode(XmlNode xmlNode, String string) {
        Iterator iterator = xmlNode.iterate(VSCLASS);
        while (iterator.hasNext()) {
            XmlNode xmlNode2 = (XmlNode)iterator.next();
            Iterator iterator2 = xmlNode2.iterate(VS);
            while (iterator2.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator2.next();
                if (!string.equals(xmlNode3.getString(ID, null))) continue;
                return xmlNode3;
            }
        }
        Deploy.log(1, "Can't find VS element for virtual server " + string);
        return null;
    }

    public static Vector getList(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        try {
            XmlNode xmlNode = Deploy.getRootNode(string);
            XmlNode xmlNode2 = Deploy.getVSNode(xmlNode, string2);
            Iterator iterator = xmlNode2.iterate(WEBAPP);
            boolean bl = false;
            while (iterator.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator.next();
                String string3 = xmlNode3.getString(URI, null);
                String string4 = xmlNode3.getString(PATH, null);
                String string5 = xmlNode3.getString(ENABLED, null);
                vector.add(string3 + "=" + string4 + "=" + string5);
            }
        }
        catch (Exception exception) {
            Deploy.log(1, "Cannot form the list of installed web apps.");
            Deploy.log(3, exception);
            Deploy.log(1, USAGE);
            System.exit(1);
        }
        return vector;
    }

    private static String getDirToExtract(String string, String string2, String string3) {
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            XmlNode xmlNode = Deploy.getRootNode(string2);
            XmlNode xmlNode2 = Deploy.getVSNode(xmlNode, string3);
            Iterator iterator = xmlNode2.iterate(WEBAPP);
            while (iterator.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator.next();
                String string5 = xmlNode3.getString(URI, null);
                if (string5.equals(string)) {
                    string4 = xmlNode3.getString(PATH, null);
                    break;
                }
                stringBuffer.append("\n").append(string5);
            }
        }
        catch (Exception exception) {
            Deploy.log(1, "Cannot determine the directory corresponding to the URI - " + string);
            Deploy.log(3, exception);
            Deploy.log(1, USAGE);
            System.exit(1);
        }
        if (string4 == null) {
            Deploy.log(1, "The uri path \"" + string + "\" is not found in " + string3);
            Deploy.log(1, "The list of available web application URI paths are " + stringBuffer.toString());
            System.exit(1);
        }
        return string4;
    }

    private static void ShowList(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            int n2 = string.indexOf("=");
            int n3 = i + 1;
            System.out.println("Web application: " + n3);
            System.out.println("    URI Path:    " + string.substring(0, n2));
            int n4 = string.substring(n2 + 1, string.length()).indexOf("=");
            n4 = n4 + n2 + 1;
            System.out.println("    Directory:   " + string.substring(n2 + 1, n4));
            System.out.println("    Enabled:     " + string.substring(n4 + 1, string.length()));
            System.out.println("");
        }
        System.out.println("Total number of web applications deployed: " + n);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        String string = null;
        String string2 = null;
        int n2 = 0;
        String string3 = null;
        try {
            Object object;
            serverRoot = System.getProperty(SERVER_ROOT);
            Hashtable hashtable = new Hashtable();
            n = stringArray.length;
            if (n == 0) {
                System.out.println(USAGE);
                System.exit(1);
            }
            deployErrorHandler = new DeployXmlErrorHandler();
            n2 = Deploy.validateArgs(stringArray, hashtable);
            if (n2 != 0) {
                Deploy.log(1, USAGE);
                System.exit(n2);
            }
            string = hashtable.get("DepOption").toString();
            if (hashtable.containsKey(new String("-u"))) {
                string3 = hashtable.get("-u").toString();
            }
            String string4 = hashtable.get("-v").toString();
            String string5 = hashtable.get("-i").toString();
            String string6 = null;
            if (hashtable.containsKey(new String("warFileName"))) {
                string6 = hashtable.get("warFileName").toString();
            }
            String string7 = null;
            if (string.equals("list")) {
                object = Deploy.getList(string5, string4);
                Deploy.ShowList((Vector)object);
                System.exit(0);
            }
            if (string.equals("deploy")) {
                defaultWebappDir = SlashUtil.de_slashes(serverRoot + SLASH + string5 + SLASH + "webapps" + SLASH + string4);
                if (hashtable.containsKey(new String("-d"))) {
                    string7 = (String)hashtable.get("-d");
                    if (string7 != null && (string7 = SlashUtil.de_slashes(string7.trim())).equals(defaultWebappDir)) {
                        string7 = defaultWebappDir + string3;
                    }
                } else {
                    string7 = defaultWebappDir + string3;
                }
                if (string7 != null) {
                    object = new File(string7 = SlashUtil.de_slashes(string7.trim()));
                    if (((File)object).exists() && ((File)object).isDirectory()) {
                        if (!((File)object).canWrite()) {
                            Deploy.log(1, "The directory " + string7 + " is not writable.");
                            Deploy.log(1, USAGE);
                            System.exit(2);
                        }
                    } else {
                        Deploy.log(1, "The directory " + string7 + " doesn't exist. Creating it.");
                        if (!((File)object).mkdirs()) {
                            Deploy.log(1, "Cannot create " + string7 + ". Check permissions.");
                            Deploy.log(1, USAGE);
                            System.exit(2);
                        } else {
                            newDirCreated_ = true;
                        }
                    }
                    Deploy.checkUser(string5);
                } else {
                    Deploy.log(1, "The directory in which to deploy the web application has not been specified.");
                    Deploy.log(1, "Specify it using the -d option or ensure that a document root is specified for");
                    Deploy.log(1, "the virtual server in which the web applications are being deployed.");
                    Deploy.log(1, USAGE);
                    System.exit(1);
                }
            } else {
                string7 = Deploy.getDirToExtract(string3, string5, string4);
                if (hashtable.containsKey(new String("DeleteOption"))) {
                    string2 = hashtable.get("DeleteOption").toString();
                }
                if (string2.equals("hard") && string7 != null) {
                    object = new File(string7);
                    if (((File)object).exists() && ((File)object).isDirectory()) {
                        if (!((File)object).canWrite()) {
                            Deploy.log(1, "The directory " + string7 + " is not writable.");
                            Deploy.log(1, USAGE);
                            System.exit(2);
                        }
                    } else {
                        Deploy.log(1, "The directory " + string7 + " doesn't exist.");
                        Deploy.log(1, USAGE);
                        System.exit(2);
                    }
                }
            }
            if (hashtable.containsKey(new String("DeleteOption"))) {
                string2 = hashtable.get("DeleteOption").toString();
            }
            object = new Deploy(string3, string6, string7, string5, string4);
            if (string.equals("deploy")) {
                if (((Deploy)object).process()) {
                    ((Deploy)object).reconfigureServer(hashtable);
                }
            } else if (string2.equals("hard")) {
                ((Deploy)object).deleteWebApplication(string3);
                ((Deploy)object).reconfigureServer(hashtable);
                if (matchFlag != 2) {
                    super.deleteFile(string7);
                }
            } else {
                ((Deploy)object).deleteWebApplication(string3);
                ((Deploy)object).reconfigureServer(hashtable);
            }
            n2 = 0;
            switch (matchFlag) {
                case 0: {
                    Deploy.log(1, "This web application is already deployed");
                    break;
                }
                case 2: {
                    Deploy.log(1, "Invalid URI specified with -u option.");
                    n2 = 1;
                    break;
                }
                default: {
                    Deploy.log(1, "Web application " + Deploy.ShowMsg(string) + " successful");
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Deploy.log(3, throwable);
            n2 = 1;
        }
        if (n2 != 0) {
            Deploy.log(1, "Failed to " + Deploy.ShowMsg(string) + " the web application: " + string3);
            Deploy.log(1, USAGE);
        }
        System.exit(n2);
    }

    public void reconfigureServer(Hashtable hashtable) throws Exception {
        if (!hashtable.containsKey(new String("-n"))) {
            Runtime runtime = Runtime.getRuntime();
            String string = null;
            String string2 = (String)hashtable.get("-i");
            Deploy.log(1, "Loading  new configuration");
            string = Deploy.isWindows() ? "reconfig.bat" : "reconfig";
            string = serverRoot + SLASH + string2 + SLASH + string;
            try {
                Process process = runtime.exec(string);
                StreamConsumer streamConsumer = new StreamConsumer(process.getInputStream(), "OUTPUT");
                StreamConsumer streamConsumer2 = new StreamConsumer(process.getErrorStream(), "ERROR");
                streamConsumer.start();
                streamConsumer2.start();
                process.waitFor();
                Deploy.log(4, "Executed the reconfigure shell script file " + string + " successfully...");
                streamConsumer.destroy();
                streamConsumer2.destroy();
            }
            catch (IOException iOException) {
                Deploy.log(1, "Exception when reconfiguring the server " + iOException.getMessage());
                Deploy.log(1, "Exception is ignored, please reconfigure manually..");
                Deploy.log(3, iOException);
            }
        }
    }

    private static String ShowMsg(String string) {
        if (string.equals("deploy")) {
            return "deploy";
        }
        return "delete";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteFile(String string) {
        File file = new File(string);
        try {
            if (file.isDirectory()) {
                if (!file.canWrite()) throw new Exception("No write permission for directory " + file);
                this.rm(file);
                Deploy.log(4, "Deleted directory " + file + " successfully...");
                return;
            } else {
                Deploy.log(1, "The directory " + string + " not present");
            }
            return;
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 != null) {
                Deploy.log(1, "Error deleting the directory " + string + "." + string2);
            } else {
                Deploy.log(1, "Error deleting the directory " + string + ".");
            }
            Deploy.log(3, exception);
        }
    }

    public void deleteWebApplication(String string) {
        String string2 = serverRoot + SLASH + this.serverInst + SLASH + CONFIG_DIR + SLASH + SERVER_XML_FILE;
        Deploy.log(4, "Deleting web application");
        XmlNode xmlNode = Deploy.getRootNode(this.serverInst);
        boolean bl = false;
        boolean bl2 = false;
        try {
            XmlNode xmlNode2 = Deploy.getVSNode(xmlNode, this.vsId);
            Iterator iterator = xmlNode2.iterate(WEBAPP);
            matchFlag = 2;
            while (iterator.hasNext()) {
                XmlNode xmlNode3 = (XmlNode)iterator.next();
                String string3 = xmlNode3.getString(URI, null);
                if (string3.equals(string)) {
                    xmlNode2.removeChild(xmlNode3);
                    bl2 = true;
                    matchFlag = 1;
                    break;
                }
                bl2 = false;
            }
            if (bl2) {
                AdminConfig.writeXmlToFile(xmlNode, serverRoot, string2);
                bl2 = false;
            }
        }
        catch (Exception exception) {
            Deploy.log(1, "Error deleting the web application");
            Deploy.log(3, exception);
        }
    }

    public static void checkUser(String string) {
        if (!Deploy.isWindows()) {
            try {
                MagObj magObj = new MagObj();
                magObj.init(serverRoot, string);
                instUser = magObj.get_mag_var("User");
                currentUser = System.getProperty("user.name");
                if (!currentUser.equals(instUser)) {
                    if (!currentUser.equals("root")) {
                        Deploy.log(1, "\nWarning: You are not running as the same user that server instance runs as. ");
                        Deploy.log(1, "The application should be deployed as the user the Web Server Instance is running as.");
                        Deploy.log(1, "You are running as " + currentUser + " and the instance is running as " + instUser + ".");
                    } else {
                        changeOwner_ = true;
                    }
                }
            }
            catch (Exception exception) {
                Deploy.log(1, "Exception when checking the server user in magnus.conf file" + exception.getMessage());
                Deploy.log(3, exception);
            }
        }
    }

    public boolean process() throws Exception {
        Object object;
        String string = serverRoot + SLASH + this.serverInst + SLASH + CONFIG_DIR + SLASH + SERVER_XML_FILE;
        boolean bl = false;
        XmlNode xmlNode = Deploy.getRootNode(this.serverInst);
        XmlNode xmlNode2 = Deploy.getVSNode(xmlNode, this.vsId);
        Iterator iterator = xmlNode2.iterate(WEBAPP);
        while (iterator.hasNext()) {
            object = (XmlNode)iterator.next();
            if (!this.uriPath.equals(((XmlNode)object).getString(URI, null))) continue;
            matchFlag = 0;
        }
        object = new File(this.warFileName);
        if (!((File)object).exists()) {
            Deploy.log(1, "The file " + this.warFileName + " does not exist");
            System.exit(1);
        }
        if (matchFlag != 0) {
            Object object2;
            if (((File)object).isDirectory()) {
                this.dirToExtract = this.warFileName;
            } else {
                object2 = new StringBuffer();
                try {
                    Deploy.log(4, "Unzipping the .war file " + this.warFileName + " to " + this.dirToExtract);
                    UnZips.unzipit(this.warFileName, this.dirToExtract);
                    Deploy.log(4, "Unzipped the war file " + this.warFileName + " successfully...");
                    if (newDirCreated_ && changeOwner_) {
                        Deploy.log(1, "Trying to change the ownership of the deployed files to " + instUser + ".");
                        MiscUtil.changeOwner(instUser, this.dirToExtract);
                    }
                }
                catch (Exception exception) {
                    Deploy.log(1, exception);
                    throw new Exception(" Cannot deploy. " + exception.getMessage());
                }
            }
            Deploy.log(1, "Deploying  web application ");
            object2 = new XmlNode(xmlNode2, WEBAPP, "", "", 0);
            ((XmlNode)object2).addChild(URI, this.uriPath, "", 0, true);
            ((XmlNode)object2).addChild(PATH, this.dirToExtract, "", 0, true);
            ((XmlNode)object2).addChild(ENABLED, "true", "", 0, true);
            xmlNode2.addChild((XmlNode)object2);
            AdminConfig.writeXmlToFile(xmlNode, serverRoot, string);
            bl = true;
        }
        return bl;
    }

    public void rm(File file) throws Exception {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.rm(fileArray[i]);
                }
                file.delete();
            } else {
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    public static void log(int n, String string) {
        if (n <= verboseLevel) {
            System.out.println("[wdeploy] " + string);
        }
    }

    public static void log(int n, Throwable throwable) {
        if (n <= verboseLevel) {
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                StringTokenizer stringTokenizer = new StringTokenizer(stringWriter.toString(), "\n");
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append("\n[wdeploy] ").append(stringTokenizer.nextToken());
                }
                System.out.println(stringBuffer.toString());
            }
            catch (Throwable throwable2) {
                throwable.printStackTrace(System.out);
                System.out.flush();
            }
        }
    }

    static {
        SLASH = File.separator;
        SERVER_ROOT = "com.sun.web.instanceRoot";
        SERVER_XML_FILE = "server.xml";
        CONFIG_DIR = "config";
        WEBXML_DTD_ID = "-//Sun Microsystems Inc.//DTD Sun ONE Web Server 6.1//EN";
        WEBXML_DTD_RESOURCE = "sun-web-server_6_1.dtd";
        matchFlag = 1;
        newDirCreated_ = false;
        changeOwner_ = false;
        instUser = null;
        currentUser = null;
        verboseLevel = 1;
        deployErrorHandler = null;
    }
}

