/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.beans;

import com.sun.web.admin.beans.DAV;
import com.sun.web.admin.beans.DAVException;
import com.sun.web.admin.beans.XmlNodeWrapper;
import com.sun.web.admin.util.MiscUtil;
import com.sun.web.admin.util.SlashUtil;
import com.sun.web.admin.util.XmlConfig;
import com.sun.web.admin.util.XmlNode;
import java.util.Iterator;

public class DAVCollection {
    private String rootDir_;
    private String uri_;
    private String sourceUri_;
    private String lockDB_ = null;
    private int minLockTimeout_ = 0;
    private int rqstBodySize_ = 8192;
    private String propDepth_ = "1";
    private boolean enabled_ = true;
    private XmlNode davNode_ = null;
    private DAV dav_ = null;
    private String vsID_;
    private XmlNode rootNode_ = null;
    private String instanceName_;
    private String instanceDir_;
    private boolean useBackup_ = true;

    protected DAVCollection() {
    }

    public DAVCollection(String string, String string2, String string3, int n, int n2, String string4, boolean bl, String string5, String string6, XmlNode xmlNode, DAV dAV, XmlNode xmlNode2) {
        this.uri_ = string;
        if (string2 != null && !string2.trim().equals("")) {
            this.sourceUri_ = SlashUtil.de_slashes(string2);
        }
        if (string3 != null) {
            this.lockDB_ = SlashUtil.de_slashes(string3);
        }
        this.minLockTimeout_ = n;
        this.rqstBodySize_ = n2;
        this.propDepth_ = string4;
        this.enabled_ = bl;
        this.instanceName_ = string5;
        this.instanceDir_ = string6;
        this.davNode_ = xmlNode;
        this.dav_ = dAV;
        this.rootNode_ = xmlNode2;
    }

    public DAVCollection(String string, String string2, String string3, String string4, String string5) throws IllegalArgumentException, DAVException {
        this(string, string2, string3, string4, null, 0, 8192, "1", string5, true);
    }

    public DAVCollection(String string, String string2, String string3, String string4, String string5, int n, int n2, String string6, String string7, boolean bl) throws IllegalArgumentException, DAVException {
        this.initialize(string, string2, string3, string4, string5, n, n2, string6, string7, bl);
        if (this.instanceName_.equals("https-admserv")) {
            this.useBackup_ = false;
        }
        String string8 = null;
        string8 = this.useBackup_ ? this.instanceDir_ + "/conf_bk/server.xml" : this.instanceDir_ + "/config/server.xml";
        this.getDAVNode(string8);
    }

    private void initialize(String string, String string2, String string3, String string4, String string5, int n, int n2, String string6, String string7, boolean bl) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("DAVCollection::initialize, Empty server-root directory");
        }
        this.rootDir_ = SlashUtil.de_slashes(string);
        if (this.rootDir_.length() == 0) {
            throw new IllegalArgumentException("DAVCollection::initialize, Empty server-root directory");
        }
        if (string2 != null) {
            this.instanceName_ = string2.trim();
            if (this.instanceName_.length() == 0) {
                throw new IllegalArgumentException("DAVCollection::initalize, Empty server instance name");
            }
        } else {
            throw new IllegalArgumentException("DAVCollection::initalize, Empty server instance name");
        }
        this.instanceDir_ = this.rootDir_ + '/' + this.instanceName_;
        if (string7 != null) {
            this.vsID_ = string7.trim();
            if (this.vsID_.length() == 0) {
                throw new IllegalArgumentException("DAVCollection::initialize, empty VS id");
            }
        } else {
            throw new IllegalArgumentException("DAVCollection::initialize, empty VS id");
        }
        if (string3 != null) {
            this.uri_ = SlashUtil.de_slashes(string3.trim());
            if (this.uri_.length() == 0) {
                throw new IllegalArgumentException("DAV, invalid uri");
            }
        } else {
            throw new IllegalArgumentException("DAV, invalid uri");
        }
        if (string4 != null) {
            this.sourceUri_ = SlashUtil.de_slashes(string4.trim());
        }
        boolean bl2 = false;
        if (string5 != null) {
            this.lockDB_ = SlashUtil.de_slashes(string5.trim());
            if (this.lockDB_.length() == 0 || this.lockDB_.equalsIgnoreCase("default")) {
                this.lockDB_ = "default";
            }
        } else {
            this.lockDB_ = "default";
        }
        this.minLockTimeout_ = n;
        this.rqstBodySize_ = n2;
        this.propDepth_ = string6;
        this.enabled_ = bl;
    }

    private void initParent(XmlNode xmlNode, boolean bl) throws DAVException {
        XmlNode xmlNode2 = null;
        String string = null;
        int n = 0;
        int n2 = 8192;
        String string2 = "1";
        boolean bl2 = true;
        xmlNode2 = this.davNode_.findChildNode("lockdb");
        if (xmlNode2 != null) {
            string = xmlNode2.getValue();
        }
        if ((xmlNode2 = this.davNode_.findChildNode("minlocktimeout")) != null) {
            n = xmlNode2.getValue().equals("infinity") ? -1 : Integer.parseInt(xmlNode2.getValue());
        }
        if ((xmlNode2 = this.davNode_.findChildNode("maxxmlrequestbodysize")) != null) {
            n2 = Integer.parseInt(xmlNode2.getValue());
        }
        if ((xmlNode2 = this.davNode_.findChildNode("maxpropdepth")) != null) {
            string2 = xmlNode2.getValue();
        }
        if ((xmlNode2 = this.davNode_.findChildNode("enabled")) != null) {
            bl2 = Boolean.valueOf(xmlNode2.getValue());
        }
        this.dav_ = new DAV(xmlNode, this.davNode_, this.rootNode_, this.rootDir_, this.instanceName_, this.vsID_, string, n, n2, string2, bl2);
        if (!bl) {
            xmlNode.addChild(this.davNode_);
        }
    }

    public String getSourceURI() {
        if (this.sourceUri_ != null) {
            return SlashUtil.de_slashes(this.sourceUri_);
        }
        return null;
    }

    public String getURI() {
        return this.uri_;
    }

    public String getLockDB() {
        return SlashUtil.de_slashes(this.lockDB_);
    }

    public int getMinLockTimeout() {
        return this.minLockTimeout_;
    }

    public String getPropDepth() {
        return this.propDepth_;
    }

    public int getRequestSize() {
        return this.rqstBodySize_;
    }

    public boolean enabled() {
        return this.enabled_;
    }

    public XmlNode getDAVNode() {
        return this.davNode_;
    }

    public String getVSID() {
        return this.vsID_;
    }

    public XmlNode getDAVNode(String string) throws DAVException {
        XmlNode xmlNode = null;
        boolean bl = true;
        if (this.davNode_ == null) {
            if (!MiscUtil.isFile(string)) {
                throw new DAVException("DAVCollection:getDAVNode, invalid filename to parse server xml config from");
            }
            XmlNode xmlNode2 = null;
            try {
                this.rootNode_ = xmlNode2 = new XmlConfig(string).parseConfig();
            }
            catch (Exception exception) {
                throw new DAVException("DAVCollection:getDAVNode, Could not parse server.xml");
            }
            XmlNodeWrapper xmlNodeWrapper = new XmlNodeWrapper(xmlNode2);
            String string2 = xmlNodeWrapper.getParentClassName(this.vsID_);
            xmlNode = xmlNodeWrapper.getVSNode(string2, this.vsID_);
            Iterator iterator = xmlNode.iterate("DAV");
            if (iterator.hasNext()) {
                this.davNode_ = (XmlNode)iterator.next();
            } else {
                this.davNode_ = DAV.createDAVNodeForVS(xmlNode, "default", 0, 8192, "1", true, this.instanceDir_);
                bl = false;
            }
        }
        this.initParent(xmlNode, bl);
        return this.davNode_;
    }

    public boolean equals(Object object) {
        if (object instanceof DAVCollection) {
            DAVCollection dAVCollection = (DAVCollection)object;
            return this.uri_.equals(dAVCollection.uri_) && this.sourceUri_.equals(dAVCollection.sourceUri_) && this.lockDB_.equals(dAVCollection.lockDB_) && this.minLockTimeout_ == dAVCollection.minLockTimeout_ && this.rqstBodySize_ == dAVCollection.rqstBodySize_ && this.propDepth_.equals(dAVCollection.propDepth_) && this.enabled_ == dAVCollection.enabled_;
        }
        return false;
    }

    public void add() throws DAVException {
        boolean bl = false;
        if (this.dav_ != null) {
            try {
                bl = this.dav_.addCollection(this);
            }
            catch (Exception exception) {
                throw new DAVException("DAVCollection::add, " + exception.getMessage());
            }
            if (!bl) {
                throw new DAVException("DAVCollection::add operation failed");
            }
        } else {
            throw new DAVException("DAVCollection::add, parent DAV invalid");
        }
    }

    public void edit(String string, boolean bl) throws DAVException {
        this.edit(string, null, -9, -9, "0", bl);
    }

    public void edit(String string, String string2) throws DAVException {
        try {
            if (this.dav_ == null) {
                throw new Exception("DAVCollection.edit, parent DAV not valid");
            }
            this.dav_.addCollection(this, string, string2);
        }
        catch (Exception exception) {
            throw new DAVException("DavCollection::edit for URI : " + string + "  SourceURI : " + string2 + " , " + exception.getMessage());
        }
    }

    public void edit() throws DAVException {
        try {
            if (this.dav_ == null) {
                throw new Exception("DAVCollection.edit, parent DAV not valid");
            }
            this.dav_.addCollection(this);
        }
        catch (Exception exception) {
            throw new DAVException("DAVCollection::edit, " + exception.getMessage());
        }
    }

    public void edit(String string, String string2, int n, int n2, String string3, boolean bl) throws DAVException {
        if (this.dav_ != null) {
            this.uri_ = SlashUtil.de_slashes(string);
            if (string2 != null) {
                this.lockDB_ = SlashUtil.de_slashes(string2);
            }
            if (n != -9) {
                this.minLockTimeout_ = n;
            }
            if (n2 != -9) {
                this.rqstBodySize_ = n2;
            }
            this.propDepth_ = string3;
            this.enabled_ = bl;
            boolean bl2 = false;
            try {
                bl2 = this.dav_.addCollection(this);
            }
            catch (Exception exception) {
                throw new DAVException("DAVCollection::edit, " + exception.getMessage());
            }
            if (!bl2) {
                throw new DAVException("DAVCollection::edit operation failed");
            }
        } else {
            throw new DAVException("DAVCollection::edit, parent DAV invalid");
        }
    }

    public void delete(boolean bl) throws DAVException {
        if (this.dav_ != null) {
            try {
                this.dav_.removeCollection(this);
            }
            catch (Exception exception) {
                throw new DAVException("DAVCollection::delete operation failed");
            }
        } else {
            throw new DAVException("DAVCollection::delete, parent DAV invalid");
        }
    }
}

