/*
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 */
package samples.jndi.customResource;


import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;


public class MyCustomConnectionFactory implements ObjectFactory {

    /** Creates a new instance of MyCustomConnectionFactory */
    public MyCustomConnectionFactory() {}

    public Object getObjectInstance(
            Object obj, Name name, Context nameCtx, Hashtable environment)
                throws NamingException {

        // Acquire an instance of our specified bean class
        MyBean bean = new MyBean();

        // Customize the bean properties from our attributes
        Reference ref   = (Reference) obj;
        RefAddr   addr  = ref.get("info");
        String    value = (String) addr.getContent();

        bean.setInfo(value);

        return(bean);
    }
}

