/*
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 *
 */
package samples.webapps.caching;


import java.io.*;

import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;


/**
 * A simple servlet that returns the Version of the application and other
 * basic information about the application and environment.
 *
 */
public class ServCache extends HttpServlet {

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(
            HttpServletRequest request, HttpServletResponse response)
                throws IOException, ServletException {

        String InputString = request.getParameter("inputtext");

        if(request.getParameter("delivery").equals("mvc")) {
            System.out.println("Executing ServCache (MVC mode) : "
                               + InputString);
            response.setContentType("text/html");

            RequestDispatcher dispatcher;

            dispatcher =
                getServletContext().getRequestDispatcher("/ServCache.jsp");

            dispatcher.include(request, response);
        } else {
            System.out.println("Executing ServCache (println mode) : "
                               + InputString);
            deliverServlet(InputString, response);
        }
    }

    private void deliverServlet(
            String anInputString, HttpServletResponse aResponse)
                throws IOException {

        /* Send Header */
        aResponse.setContentType("text/html");

        PrintWriter out = aResponse.getWriter();

        out.println("<html>");
        out.println("<head>");
        out.println(
            "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso8859-1\">");
        out.println(
            "<meta description=\"Sun One Web Server Caching Sample Application  Results\">");

        /* disable browser caching so that it doesn't mask server caching. */
        out.println("<meta http-equiv=\"pragma\" content=\"no-cache\">");
        out.println("<meta http-equiv=\"expires\" content=\"-1\">");
        out.println("<title>Servlet Caching Sample</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h2>Servlet Cache Sample</h2>");

        /* Send Body */
        out.println("The following was generated by : ");
        out.println("<blockquote><strong>println statements "
                    + "within a Servlet.</strong></blockquote>");
        out.println("The date this content was created was : ");
        out.println("<blockquote><strong>" + new Date().toString()
                    + "</strong></blockquote>");
        out.println("The input string passed into this servlet was:");
        out.println("<blockquote><strong>" + anInputString
                    + "</strong></blockquote>");
        out.println("<a href=\"index.html\">Return to Start Page</a>");
        out.println("</body></html>");
        out.close();
    }
}