/**
 * alert_en.js
 *
 * English-localized alert() calls.
 */

function alertInvalidId(label)
{
    if (label == null || label.length < 1)
        label = "ID";

    alert("The specified " + label + " value is invalid. Please enter an ID that begins with a letter and contains only letters, numbers, underscores, hyphens and periods.");

    return false;
}

function alertInvalidIpAddress(label)
{
    if (label == null || label.length < 1)
        label = "IP address";

    alert("The specified " + label + " value is invalid. Please enter an IP address, an IPv6 address or \"any\" (without the quotes).");

    return false;
}

function alertInvalidPort(label)
{
    if (label == null || label.length < 1)
        label = "port";

    alert("The specified " + label + " value is invalid. Please enter a number between 1 and 65535, inclusive.");

    return false;
}

function alertInvalidServerName(label)
{
    if (label == null || label.length < 1)
        label = "server name";

    alert("The specified " + label + " value is invalid. Please enter a hostname.");

    return false;
}

function alertInvalidNumber(label, min, max)
{
    if (label == null || label.length < 1)
        label = "numeric";

    alert("The specified " + label + " value is invalid. Please enter a number between " + min + " and " + max + ", inclusive.");

    return false;
}

function alertInvalidURI()
{
    alert("Invalid URI.");

    return false;
}

function alertInvalidWebappPath()
{
    alert("Invalid Webapp location.");

    return false;
}

function alertInvalidClassName(label)
{
    if (label == null || label.length < 1)
        label = "class name";

    alert("The specified " + label + " value is invalid. Please enter a class name.");

    return false;
}

function alertInvalidName(label)
{
    if (label == null || label.length < 1)
        label = "Name";

    alert("The specified " + label + " is invalid. Please enter a " + label + " that begins with a letter and contains only letters, numbers, underscores, hyphens and periods.");

    return false;
}

function alertInvalidInteger(label)
{
    if (label == null || label.length < 1)
        label = "input field";

    alert("Please enter a valid integer value for " + label);
    return false;
}

function alertNotAscii(label)
{
    if (label == null || label.length < 1)
        label = "input field";

    alert("Non-Ascii characters are not accepted for " + label);
    return false;
}

function alertInvalidField(label)
{
    if (label == null || label.length < 1)
        label = "input field";

    alert("Please enter a valid " + label);
    return false;
}

function alertInvalidFamily()
{
    alert("Please enter a valid Protocol Family. The valid values are inet, inet6 and nca.");
    return false;
}

function alertRequiredField(label)
{
    if (label == null || label.length < 1)
        label = "input field";

    alert(label + " is a required field. Please enter a valid value.");
    return false;
}